/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.xxljob.executor.common.handler;

import cn.hutool.core.lang.UUID;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.starter.cache.MeiXinReqExtractCache;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.request.MeiXinRequest;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.AuthException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.AuthHandler;
import com.jdaz.sinosoftgz.apis.constants.AnalysisErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorCode;
import java.io.BufferedReader;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MeiXinAuthHandler
implements AuthHandler {
    private static final Logger log = LoggerFactory.getLogger(MeiXinAuthHandler.class);
    @Value(value="${sign.meixin.token}")
    private String token;
    @Value(value="${sign.meixin.companyId}")
    private String companyId;

    public Boolean verifyAuth(HttpServletRequest request) throws AuthException {
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        String signature = request.getParameter("signature");
        if (StringUtils.isBlank((CharSequence)timestamp) || StringUtils.isBlank((CharSequence)nonce) || StringUtils.isBlank((CharSequence)signature) || StringUtils.isBlank((CharSequence)this.token)) {
            log.error("\u9541\u4fe1\u9a8c\u8bc1\u7b7e\u540d\u5165\u53c2\u4e3a\u7a7a\uff1atimestamp:{}, nonce:{}, signature:{}, token:{}", new Object[]{timestamp, nonce, signature, this.token});
            this.cacheReqExtract(request);
            return false;
        }
        String sourceSign = this.sign(timestamp, nonce);
        if (!signature.equals(sourceSign)) {
            log.error("\u9541\u4fe1\u9a8c\u8bc1\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25\uff1atimestamp:{}, nonce:{}, signature:{}, token:{}", new Object[]{timestamp, nonce, signature, this.token});
            this.cacheReqExtract(request);
            return false;
        }
        return true;
    }

    private String sign(String timestamp, String nonce) {
        String source = timestamp + nonce + this.token;
        return DigestUtils.sha1Hex((String)source).toUpperCase();
    }

    public String addAuthToUrl(String url) {
        String timestamp = System.currentTimeMillis() + "";
        String nonce = UUID.fastUUID().toString().replaceAll("-", "");
        String signature = this.sign(timestamp, nonce);
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        paramMap.put("timestamp", timestamp);
        paramMap.put("nonce", nonce);
        paramMap.put("signature", signature);
        paramMap.put("companyId", this.companyId);
        return this.makeUrl(url, paramMap);
    }

    private String makeUrl(String url, Map<String, String> map) {
        if (map != null && !map.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (StringUtils.isEmpty((CharSequence)buffer.toString())) {
                    buffer.append("?");
                } else {
                    buffer.append("&");
                }
                buffer.append(entry.getKey()).append("=").append(entry.getValue());
            }
            url = url + buffer.toString();
        }
        return url;
    }

    private void cacheReqExtract(HttpServletRequest request) throws AuthException {
        MeiXinRequest meiXinRequest = this.getPostData(request);
        MeiXinReqExtractCache.setReqExtract((MeiXinRequest)meiXinRequest);
    }

    private MeiXinRequest<?> getPostData(HttpServletRequest request) throws AuthException {
        StringBuilder data = new StringBuilder();
        try {
            String line;
            BufferedReader reader = request.getReader();
            while (null != (line = reader.readLine())) {
                data.append(line);
            }
            return (MeiXinRequest)JSON.parseObject((String)data.toString(), MeiXinRequest.class);
        }
        catch (Exception e) {
            log.error("\u9a8c\u7b7e\u5931\u8d25\uff0c\u63d0\u53d6\u53c2\u6570\u9519\u8bef", (Throwable)e);
            throw new AuthException((ErrorCode)AnalysisErrorCodeEnum.ERR_A010004);
        }
    }
}

