/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.xxljob.executor.common.jobhandler;

import com.jdaz.sinosoftgz.apis.commons.model.asynInsure.service.ApisBusiAsyncTaskLogService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.apis.xxljob.executor.common.service.DdPolicyConfirmService;
import com.jdaz.sinosoftgz.apis.xxljob.executor.common.utils.CommonTaskUtil;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@JobHandler(value="taskDDPolicyConfirmHandler")
public class TaskDDPolicyConfirmHandler
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(TaskDDPolicyConfirmHandler.class);
    @Autowired
    private ApisBusiAsyncTaskLogService apisBusiAsyncTaskLogService;
    @Autowired
    CommonTaskUtil commonTaskUtil;
    @Autowired
    DdPolicyConfirmService ddPolicyConfirmService;
    @Value(value="${analysis.task.max_push_times}")
    private Integer maxPushTimes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReturnT<String> execute(String s) throws Exception {
        if (this.commonTaskUtil.lock(ApisAutoTaskConstantsEnum.DD_POLICY_CONFIRM.getKey())) {
            try {
                List taskList = this.apisBusiAsyncTaskLogService.getNeedPushTaskRecord(ApisAutoTaskConstantsEnum.DD_POLICY_CONFIRM.getValue(), this.maxPushTimes);
                log.warn("\u8fbe\u8fbe\u4e0b\u5355\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> this.ddPolicyConfirmService.policyConfirm(t));
                ReturnT returnT = SUCCESS;
                return returnT;
            }
            catch (Exception e) {
                log.error("\u8fbe\u8fbe\u4e0b\u5355\u5b9a\u65f6\u4efb\u52a1: ", (Throwable)e);
            }
            finally {
                this.commonTaskUtil.deleteByKey(ApisAutoTaskConstantsEnum.DD_POLICY_CONFIRM.getKey());
            }
        }
        return FAIL;
    }
}

