/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.xxljob.executor.common.jobhandler;

import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.apis.xxljob.executor.common.service.ManUnderwriteSubmitService;
import com.jdaz.sinosoftgz.apis.xxljob.executor.common.utils.CommonTaskUtil;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@JobHandler(value="taskManUnderwriteSubmitHandler")
public class TaskManUnderwriteSubmitHandler
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(TaskManUnderwriteSubmitHandler.class);
    @Autowired
    CommonTaskUtil commonTaskUtil;
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    ManUnderwriteSubmitService manUnderwriteSubmitService;
    @Value(value="${analysis.task.max_push_times}")
    private Integer maxPushTimes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReturnT<String> execute(String s) throws Exception {
        if (this.commonTaskUtil.lock(ApisAutoTaskConstantsEnum.MAN_UNDERWRITE_PUSH_ZZ.getKey())) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord(ApisAutoTaskConstantsEnum.MAN_UNDERWRITE_PUSH_ZZ.getValue(), this.maxPushTimes);
                log.warn("\u4eba\u5de5\u6838\u4fdd-\u63d0\u4ea4\u4f9b\u5e94\u5546\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> this.manUnderwriteSubmitService.submit(t));
                ReturnT returnT = SUCCESS;
                return returnT;
            }
            catch (Exception e) {
                log.error("\u4eba\u5de5\u6838\u4fdd-\u63d0\u4ea4\u4f9b\u5e94\u5546\u5b9a\u65f6\u4efb\u52a1\u51fa\u9519: ", (Throwable)e);
            }
            finally {
                this.commonTaskUtil.deleteByKey(ApisAutoTaskConstantsEnum.MAN_UNDERWRITE_PUSH_ZZ.getKey());
            }
        }
        return FAIL;
    }
}

