/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.xxljob.executor.common.jobhandler;

import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.apis.xxljob.executor.common.service.ManUnderwriteSupplyService;
import com.jdaz.sinosoftgz.apis.xxljob.executor.common.utils.CommonTaskUtil;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@JobHandler(value="taskManUnderwriteSupplyHandler")
public class TaskManUnderwriteSupplyHandler
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(TaskManUnderwriteSupplyHandler.class);
    @Value(value="${analysis.task.max_push_times}")
    private Integer maxPushTimes;
    @Autowired
    CommonTaskUtil commonTaskUtil;
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    ManUnderwriteSupplyService manUnderwriteSupplyService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReturnT<String> execute(String s) throws Exception {
        if (this.commonTaskUtil.lock(ApisAutoTaskConstantsEnum.MAN_UNDERWRITE_SUPPLY_PUSH_ZZ.getKey())) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord(ApisAutoTaskConstantsEnum.MAN_UNDERWRITE_SUPPLY_PUSH_ZZ.getValue(), this.maxPushTimes);
                log.warn("\u4eba\u5de5\u6838\u4fdd-\u8865\u5145\u8d44\u6599\u4f9b\u5e94\u5546\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> this.manUnderwriteSupplyService.supply(t));
                ReturnT returnT = SUCCESS;
                return returnT;
            }
            catch (Exception e) {
                log.error("\u4eba\u5de5\u6838\u4fdd-\u8865\u5145\u8d44\u6599\u4f9b\u5e94\u5546\u5b9a\u65f6\u4efb\u52a1\u51fa\u9519: ", (Throwable)e);
            }
            finally {
                this.commonTaskUtil.deleteByKey(ApisAutoTaskConstantsEnum.MAN_UNDERWRITE_SUPPLY_PUSH_ZZ.getKey());
            }
        }
        return FAIL;
    }
}

