/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.xxljob.executor.common.jobhandler;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiAnalysisTaskLogService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.apis.xxljob.executor.common.service.MxTransferNoticePushService;
import com.jdaz.sinosoftgz.apis.xxljob.executor.common.utils.CommonTaskUtil;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@JobHandler(value="taskMxBillsCheckCompensateHandler")
public class TaskMxBillsCheckCompensateHandler
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(TaskMxBillsCheckCompensateHandler.class);
    @Autowired
    private ApisBusiAnalysisTaskLogService apisBusiAnalysisTaskLogService;
    @Autowired
    CommonTaskUtil commonTaskUtil;
    @Autowired
    private MxTransferNoticePushService mxTransferNoticePushService;
    @Value(value="${analysis.task.max_push_times}")
    private Integer maxPushTimes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReturnT<String> execute(String s) throws Exception {
        if (this.commonTaskUtil.lock(ApisAutoTaskConstantsEnum.SG_BILLS_CHECK_BC.getKey())) {
            try {
                List taskList = this.apisBusiAnalysisTaskLogService.getNeedPushTaskRecord(ApisAutoTaskConstantsEnum.BILL_CHECK_DETAIL_UPLOAD.getValue(), this.maxPushTimes);
                log.warn("\u9541\u4fe1\u8f6c\u8d26\u901a\u77e5\u788e\u7ba1-\u5bf9\u8d26\uff08\u5931\u8d25\u8865\u507f\uff09\u5f00\u59cb\uff1a{}", (Object)taskList.size());
                taskList.forEach(t -> {
                    String[] dateStr = t.getRemark().split("-");
                    DateTime beginDate = DateUtil.parse((CharSequence)dateStr[0], (String)"yyyyMMddHHmmss");
                    DateTime endDate = DateUtil.parse((CharSequence)dateStr[1], (String)"yyyyMMddHHmmss");
                    this.mxTransferNoticePushService.billCheckDetailUpload((Date)beginDate, (Date)endDate, null, null, t);
                });
                ReturnT returnT = SUCCESS;
                return returnT;
            }
            catch (Exception e) {
                log.error("\u9541\u4fe1\u8f6c\u8d26\u901a\u77e5\u788e\u7ba1-\u5bf9\u8d26\uff08\u5931\u8d25\u8865\u507f\uff09: ", (Throwable)e);
            }
            finally {
                this.commonTaskUtil.deleteByKey(ApisAutoTaskConstantsEnum.SG_BILLS_CHECK_BC.getKey());
            }
        }
        return FAIL;
    }
}

