/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.xxljob.executor.common.jobhandler;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.apis.xxljob.executor.common.service.MxTransferNoticePushService;
import com.jdaz.sinosoftgz.apis.xxljob.executor.common.utils.CommonTaskUtil;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@JobHandler(value="taskMxBillsCheckHandler")
public class TaskMxBillsCheckHandler
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(TaskMxBillsCheckHandler.class);
    @Autowired
    CommonTaskUtil commonTaskUtil;
    @Autowired
    private MxTransferNoticePushService mxTransferNoticePushService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReturnT<String> execute(String s) throws Exception {
        if (this.commonTaskUtil.lock(ApisAutoTaskConstantsEnum.SG_BILLS_CHECK.getKey())) {
            try {
                Integer hour = DateUtil.hour((Date)new Date(), (boolean)true);
                String endDateStr = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd") + " " + hour + ":00:00";
                DateTime endDate = DateUtil.parse((CharSequence)endDateStr, (String)"yyyy-MM-dd HH:mm:ss");
                DateTime beginDate = DateUtil.offsetHour((Date)endDate, (int)-24);
                log.warn("\u9541\u4fe1\u8f6c\u8d26\u901a\u77e5\u788e\u7ba1-\u5bf9\u8d26\u4efb\u52a1\u5f00\u59cb,\u67e5\u8be2\u8d77\u59cb\u65f6\u95f4\uff1a{},\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)beginDate, (Object)endDate);
                this.mxTransferNoticePushService.billsCheck((Date)beginDate, (Date)endDate);
                ReturnT returnT = SUCCESS;
                return returnT;
            }
            catch (Exception e) {
                log.error("\u9541\u4fe1\u8f6c\u8d26\u901a\u77e5\u788e\u7ba1-\u5bf9\u8d26: ", (Throwable)e);
            }
            finally {
                this.commonTaskUtil.deleteByKey(ApisAutoTaskConstantsEnum.SG_BILLS_CHECK.getKey());
            }
        }
        return FAIL;
    }
}

