/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.xxljob.executor.common.jobhandler;

import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiAnalysisTaskLogService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.apis.xxljob.executor.common.service.MxClaimMaterialPushService;
import com.jdaz.sinosoftgz.apis.xxljob.executor.common.utils.CommonTaskUtil;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@JobHandler(value="taskMxClaimSupplementHandler")
public class TaskMxClaimSupplementHandler
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(TaskMxClaimSupplementHandler.class);
    @Autowired
    private ApisBusiAnalysisTaskLogService apisBusiAnalysisTaskLogService;
    @Autowired
    CommonTaskUtil commonTaskUtil;
    @Value(value="${analysis.task.max_push_times}")
    private Integer maxPushTimes;
    @Autowired
    private MxClaimMaterialPushService mxClaimMaterialPushService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReturnT<String> execute(String s) throws Exception {
        if (this.commonTaskUtil.lock(ApisAutoTaskConstantsEnum.MX_CLAIM_SUPPLEMENT.getKey())) {
            try {
                List taskList = this.apisBusiAnalysisTaskLogService.getNeedPushTaskRecord(ApisAutoTaskConstantsEnum.MX_CLAIM_SUPPLEMENT.getValue(), this.maxPushTimes);
                log.warn("\u788e\u7ba1\u7406\u8d54\u8d44\u6599\u8865\u4f20\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> this.mxClaimMaterialPushService.pushClaimMaterialTask(t));
                ReturnT returnT = SUCCESS;
                return returnT;
            }
            catch (Exception e) {
                log.error("\u788e\u7ba1\u7406\u8d54\u8d44\u6599\u8865\u4f20: ", (Throwable)e);
            }
            finally {
                this.commonTaskUtil.deleteByKey(ApisAutoTaskConstantsEnum.MX_CLAIM_SUPPLEMENT.getKey());
            }
        }
        return FAIL;
    }
}

