/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.xxljob.executor.common.jobhandler;

import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.apis.xxljob.executor.common.utils.CommonTaskUtil;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@JobHandler(value="taskPolicyInfoPushAgentHandler")
public class TaskPolicyInfoPushAgentHandler
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(TaskPolicyInfoPushAgentHandler.class);
    @Autowired
    private ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    CommonTaskUtil commonTaskUtil;
    @Value(value="${analysis.task.max_push_times}")
    private Integer maxPushTimes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReturnT<String> execute(String s) throws Exception {
        if (this.commonTaskUtil.lock(ApisAutoTaskConstantsEnum.PUSH_POLICY_INFO_TO_AGENT.getKey())) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord(ApisAutoTaskConstantsEnum.PUSH_POLICY_INFO_TO_AGENT.getValue(), this.maxPushTimes);
                log.warn("\u4fdd\u5355\u4fe1\u606f\u63a8\u9001\u6e20\u9053\u8865\u507f\u4efb\u52a1\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> this.commonTaskUtil.pushToAgent(t));
                ReturnT returnT = SUCCESS;
                return returnT;
            }
            catch (Exception e) {
                log.error("\u4fdd\u5355\u4fe1\u606f\u63a8\u9001\u6e20\u9053\u8865\u507f\u4efb\u52a1: ", (Throwable)e);
            }
            finally {
                this.commonTaskUtil.deleteByKey(ApisAutoTaskConstantsEnum.PUSH_POLICY_INFO_TO_AGENT.getKey());
            }
        }
        return FAIL;
    }
}

