/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.xxljob.executor.common.jobhandler;

import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiAnalysisTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.asynInsure.service.ApisBusiAsyncTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.apis.xxljob.executor.common.utils.CommonTaskUtil;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@JobHandler(value="taskPushFailWarnHandler")
public class TaskPushFailWarnHandler
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(TaskPushFailWarnHandler.class);
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    ApisBusiAnalysisTaskLogService apisBusiAnalysisTaskLogService;
    @Autowired
    ApisBusiAsyncTaskLogService apisBusiAsyncTaskLogService;
    @Autowired
    CommonTaskUtil commonTaskUtil;

    public ReturnT<String> execute(String param) {
        if (this.commonTaskUtil.lock(ApisAutoTaskConstantsEnum.TASK_FAIL_EMAIL_NOTIFY.getKey())) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedSendFailEmail();
                List analysisList = this.apisBusiAnalysisTaskLogService.getNeedSendFailEmail();
                List asyncTaskLogList = this.apisBusiAsyncTaskLogService.getNeedSendFailEmail();
                taskList.addAll(analysisList);
                taskList.addAll(asyncTaskLogList);
                log.warn("\u63a8\u9001\u4efb\u52a1\u8865\u507f\u540e\u4ecd\u5931\u8d25\u7684\u90ae\u4ef6\u544a\u8b66 \u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb== {}", (Object)taskList.size());
                this.commonTaskUtil.doTaskLogFailEmail(taskList);
                return SUCCESS;
            }
            catch (Exception e) {
                log.error("taskPushFailWarnHandler error: ", (Throwable)e);
            }
        }
        return FAIL;
    }
}

