/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.xxljob.executor.common.service;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.utils.BaseCodeConvertUtils;
import com.jdaz.sinosoftgz.apis.business.app.starter.utils.JDAZAesUtils;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.StanderPacket;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CommissionDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.SalesDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyListQueryResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.sale.request.CommissionQueryDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.sale.request.resp.AgentQueryResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.sale.request.resp.SaleResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.asynInsure.entity.ApisBusiAsyncChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.asynInsure.entity.ApisBusiAsyncTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.asynInsure.service.ApisBusiAsyncChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.asynInsure.service.ApisBusiAsyncTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelCode;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelUser;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelCodeService;
import com.jdaz.sinosoftgz.apis.commons.model.constant.ModelConstants;
import com.jdaz.sinosoftgz.apis.commons.service.constants.CommonConstant;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpRationMainService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.xxljob.executor.common.utils.CommonTaskUtil;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DdPolicyConfirmService {
    private static final Logger log = LoggerFactory.getLogger(DdPolicyConfirmService.class);
    @Autowired
    private ApisBusiAsyncTaskLogService apisBusiAsyncTaskLogService;
    @Autowired
    ApisBusiAsyncChannelOrderService apisBusiAsyncChannelOrderService;
    @Autowired
    CommonTaskUtil commonTaskUtil;
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    ApisPfpRationMainService apisPfpRationMainService;
    @Autowired
    BaseCodeConvertUtils baseCodeConvertUtils;
    @Autowired
    ApisChannelCodeService apisChannelCodeService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void policyConfirm(ApisBusiAsyncTaskLog taskLog) {
        if (ObjectUtil.isEmpty((Object)taskLog)) {
            return;
        }
        if (ObjectUtil.isEmpty((Object)taskLog.getPushTargetUrl())) {
            log.warn("\u4efb\u52a1businessKey={},\u6ca1\u6709\u914d\u7f6e\u63a8\u9001\u7684URL", (Object)taskLog.getBusinessKey());
        }
        boolean isUpdSuccess = false;
        try {
            taskLog.setPushStatus("2");
            taskLog.setPushStep(Integer.valueOf(taskLog.getPushStep() + 1));
            taskLog.setLastPushTime(LocalDateTime.now());
            isUpdSuccess = this.apisBusiAsyncTaskLogService.updateById((Object)taskLog);
            if (isUpdSuccess) {
                String pushContent = this.dataCompletion(taskLog.getPushContent());
                StanderPacket responsePacket = (StanderPacket)this.commonTaskUtil.convertAndSendForCallback(taskLog.getPushTargetUrl(), (Object)pushContent, StanderPacket.class);
                if (ObjectUtil.isNotEmpty((Object)responsePacket)) {
                    ApisChannelUser user = this.commonTaskUtil.getApisChannelUser(responsePacket.getUserCode());
                    String seed = JDAZAesUtils.des3EncodeCbc((String)user.getUserCode(), (String)user.getPwd());
                    String responseStr = JDAZAesUtils.decryptBase64((String)seed, (String)responsePacket.getContent());
                    PolicyListQueryResponse response = (PolicyListQueryResponse)JSON.parseObject((String)responseStr, PolicyListQueryResponse.class);
                    if (ObjectUtil.isNotEmpty((Object)response) && CommonConstant.FccbResponseCode.SUCCESS.intValue() == response.getResponseHead().getStatus()) {
                        taskLog.setPushStatus("1");
                        this.updateApisBusiAsyncChannelOrder(taskLog.getBusinessKey(), response);
                    } else {
                        taskLog.setPushStatus("4");
                    }
                    taskLog.setErrMsg(JSON.toJSONString((Object)response));
                } else {
                    taskLog.setPushStatus("4");
                    taskLog.setErrMsg("\u672a\u8fd4\u56de\u5185\u5bb9");
                }
                log.warn("\u5f02\u6b65\u56de\u8c03\u54cd\u5e94\uff1a{}", (Object)responsePacket);
            }
        }
        catch (Exception e) {
            taskLog.setPushStatus("4");
            taskLog.setErrMsg(ObjectUtil.isNotEmpty((Object)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT ? e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT) : e.getMessage());
            log.error("\u5f02\u6b65\u56de\u8c03\u901a\u77e5 error:", (Throwable)e);
        }
        finally {
            if (isUpdSuccess) {
                this.apisBusiAsyncTaskLogService.updateById((Object)taskLog);
            }
        }
    }

    private String dataCompletion(String pushContent) throws ApisBusinessException {
        QuotePriceServiceRequest quotePriceServiceRequest = (QuotePriceServiceRequest)JSON.parseObject((String)pushContent, QuotePriceServiceRequest.class);
        MainDTO mainDTO = quotePriceServiceRequest.getRequestBody().getQuotePrice().getMain();
        List saleResponseDTOList = this.commissionQuery(quotePriceServiceRequest.getRequestBody().getQuotePrice());
        SaleResponseDTO saleResponseDTO = (SaleResponseDTO)saleResponseDTOList.get(0);
        if (StringUtils.isEmpty((CharSequence)mainDTO.getHandlerCode())) {
            mainDTO.setHandlerCode(saleResponseDTO.getBdInfo().getBdCode());
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getHandlerName())) {
            mainDTO.setHandlerName(saleResponseDTO.getBdInfo().getBdName());
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getCenterCode())) {
            mainDTO.setCenterCode(saleResponseDTO.getBdInfo().getBdProfitCode());
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getCenterName())) {
            mainDTO.setCenterName(saleResponseDTO.getBdInfo().getBdProfitName());
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getBusinessNature())) {
            String businessNature = this.convertCode("businessNature", saleResponseDTO.getSubAgentType());
            mainDTO.setBusinessNature(businessNature);
        }
        this.dataCompletionSalesDTO(quotePriceServiceRequest, saleResponseDTOList);
        return JSON.toJSONString((Object)quotePriceServiceRequest);
    }

    public List<SaleResponseDTO> commissionQuery(QuotePriceDTO quotePriceDTO) throws ApisBusinessException {
        ArrayList<SaleResponseDTO> saleResponseDTOList = new ArrayList<SaleResponseDTO>();
        String bdCode = null;
        String obj = "";
        Map userMap = this.baseCodeConvertUtils.getCodeData("channel:user:" + quotePriceDTO.getMain().getOperateCode());
        if (userMap.get("handler_code") instanceof String) {
            obj = userMap.get("handler_code").toString();
        }
        if (StringUtils.isNotEmpty((CharSequence)quotePriceDTO.getMain().getHandlerCode())) {
            bdCode = quotePriceDTO.getMain().getHandlerCode();
        } else if (StringUtils.isNotEmpty((CharSequence)obj)) {
            bdCode = obj;
        }
        CommissionQueryDTO commissionQueryDTO = new CommissionQueryDTO();
        commissionQueryDTO.setAgentCode(quotePriceDTO.getSales().getAgentCode());
        List itemMainDTOList = quotePriceDTO.getCoverage().getItemList();
        if (StringUtils.isNotEmpty((CharSequence)bdCode)) {
            commissionQueryDTO.setBdCode(bdCode);
        }
        commissionQueryDTO.setPlanCode(((ItemMainDTO)itemMainDTOList.get(0)).getGoodsCode());
        commissionQueryDTO.setProductCode(((ItemMainDTO)itemMainDTOList.get(0)).getPlanCode());
        commissionQueryDTO.setRiskCode(quotePriceDTO.getMain().getRiskCode());
        AgentQueryResponseDTO commissionQueryResponseDTO = this.coreInsureApi.commissionQuery(commissionQueryDTO);
        if (ObjectUtil.isNotEmpty((Object)commissionQueryResponseDTO) && "0000".equals(commissionQueryResponseDTO.getHead().getAppCode()) && ObjectUtils.isNotEmpty((Object)commissionQueryResponseDTO.getData())) {
            List saleResponseDTOS = commissionQueryResponseDTO.getData();
            saleResponseDTOList.addAll(saleResponseDTOS);
            return saleResponseDTOList;
        }
        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10022.getValue(), ChannelErrorCodeEnum.ERR_C10022.getKey());
    }

    public void dataCompletionSalesDTO(QuotePriceServiceRequest quotePriceServiceRequest, List<SaleResponseDTO> saleResponseDTOList) {
        QuotePriceDTO quotePriceDTO = quotePriceServiceRequest.getRequestBody().getQuotePrice();
        SalesDTO salesDTO = quotePriceDTO.getSales();
        SaleResponseDTO saleResponseDTO = saleResponseDTOList.get(0);
        if (StringUtils.isEmpty((CharSequence)salesDTO.getAgentName()) && ObjectUtils.isNotEmpty((Object)saleResponseDTO)) {
            salesDTO.setAgentName(saleResponseDTO.getAgentName());
        }
        if (StringUtils.isEmpty((CharSequence)salesDTO.getAgreementNo()) && ObjectUtils.isNotEmpty((Object)saleResponseDTO)) {
            salesDTO.setAgreementNo(saleResponseDTO.getAgreementCode());
        }
        if (StringUtils.isEmpty((CharSequence)salesDTO.getAgreementName()) && ObjectUtils.isNotEmpty((Object)saleResponseDTO)) {
            salesDTO.setAgreementName(saleResponseDTO.getAgreementName());
        }
        if (StringUtils.isEmpty((CharSequence)salesDTO.getAgentType()) && ObjectUtils.isNotEmpty((Object)saleResponseDTO)) {
            salesDTO.setAgentType(saleResponseDTO.getAgentType());
        }
        if (StringUtils.isEmpty((CharSequence)salesDTO.getAgentDetailType()) && ObjectUtils.isNotEmpty((Object)saleResponseDTO)) {
            salesDTO.setAgentDetailType(saleResponseDTO.getSubAgentType());
        }
        if (StringUtils.isEmpty((CharSequence)salesDTO.getHandlerCode()) && ObjectUtils.isNotEmpty((Object)saleResponseDTO)) {
            salesDTO.setHandlerCode(saleResponseDTO.getBdInfo().getBdCode());
        }
        if (StringUtils.isEmpty((CharSequence)salesDTO.getHandlerName()) && ObjectUtils.isNotEmpty((Object)saleResponseDTO)) {
            salesDTO.setHandlerName(saleResponseDTO.getBdInfo().getBdName());
        }
        salesDTO.setHandlerTeamCode(saleResponseDTO.getBdInfo().getBdTeamCode());
        salesDTO.setHandlerTeamName(saleResponseDTO.getBdInfo().getBdTeamName());
        ArrayList<CommissionDTO> list = new ArrayList<CommissionDTO>();
        CommissionDTO commissionDTO = null;
        for (SaleResponseDTO dto : saleResponseDTOList) {
            commissionDTO = CommissionDTO.builder().build();
            commissionDTO.setRoleAgentCode(dto.getAgentCode());
            commissionDTO.setAgentFlag(dto.getAgentFlag());
            commissionDTO.setCostType(dto.getFeeType());
            commissionDTO.setCostRateUpper(Double.valueOf(dto.getAgreementLimitRate()));
            commissionDTO.setCostRate(Double.valueOf(dto.getCommRate()));
            list.add(commissionDTO);
        }
        salesDTO.setCommissionList(list);
    }

    private void updateApisBusiAsyncChannelOrder(String businessKey, PolicyListQueryResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"policy_ref", (Object)businessKey);
        ApisBusiAsyncChannelOrder apisBusiAsyncChannelOrder = (ApisBusiAsyncChannelOrder)this.apisBusiAsyncChannelOrderService.getOne((Wrapper)queryWrapper, false);
        if (ObjectUtil.isNotEmpty((Object)apisBusiAsyncChannelOrder)) {
            String proposalNo = response.getResponseBody().getMain().getProposalNo();
            apisBusiAsyncChannelOrder.setProposalNo(proposalNo);
            this.apisBusiAsyncChannelOrderService.updateById((Object)apisBusiAsyncChannelOrder);
        }
    }

    private String convertCode(String code, String channelValue) {
        ApisChannelCode apisChannelCode = new ApisChannelCode();
        apisChannelCode.setCode(code);
        apisChannelCode.setChannelValue(channelValue);
        apisChannelCode.setDeleted(Integer.valueOf(0));
        QueryWrapper queryWrapper = new QueryWrapper((Object)apisChannelCode);
        List apisChannelCodeResult = this.apisChannelCodeService.list((Wrapper)queryWrapper);
        if (ObjectUtils.isNotEmpty((Object)apisChannelCodeResult) && apisChannelCodeResult.size() > 0) {
            return ((ApisChannelCode)apisChannelCodeResult.get(0)).getValue();
        }
        return null;
    }
}

