/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.xxljob.executor.common.service;

import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.request.ClaimMediaCommitResult;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.request.ImgNode;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUwAttachment;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwAttachmentService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwInsuredService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwOrderService;
import com.jdaz.sinosoftgz.apis.commons.utils.OkHttpUtils;
import com.jdaz.sinosoftgz.apis.xxljob.executor.common.utils.ClaimMediaUploadUtil;
import com.sinosoft.image.client.dto.ImgBatchUploadMetaDTO;
import com.sinosoft.image.client.dto.ImgBatchUploadRequestDTO;
import com.sinosoft.image.client.dto.ImgBusiDTO;
import com.sinosoft.image.client.dto.RequestHeadDTO;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ManUnderwriteAttachmentUploadService {
    private static final Logger log = LoggerFactory.getLogger(ManUnderwriteAttachmentUploadService.class);
    @Autowired
    ApisBusiUwAttachmentService apisBusiUwAttachmentService;
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    ClaimMediaUploadUtil claimMediaUploadUtil;
    @Autowired
    ApisBusiUwOrderService apisBusiUwOrderService;
    @Autowired
    ApisBusiUwInsuredService apisBusiUwInsuredService;

    public void upLoadClaimAttachment(ApisBusiTaskLog taskLog) {
        String orderNo;
        if (ObjectUtil.isEmpty((Object)taskLog)) {
            log.error("\u63a8\u9001\u4efb\u52a1\u4e3a\u7a7a");
            return;
        }
        if (StringUtils.isBlank((CharSequence)taskLog.getBusinessKey())) {
            log.error("\u63a8\u9001\u4e1a\u52a1\u952ebusinessKey\u4e3a\u7a7a");
            return;
        }
        List attachments = this.apisBusiUwAttachmentService.listByUwId(taskLog.getBusinessKey());
        if (this.uploadToMedia(attachments = attachments.stream().filter(a -> a.getStatus().equals("1") || a.getStatus().equals("3")).collect(Collectors.toList()), orderNo = taskLog.getRemark())) {
            String orderStatus = this.apisBusiUwOrderService.getStatusByOrderNo(orderNo);
            if ("1".equals(orderStatus)) {
                this.apisBusiUwOrderService.updateStatus(orderNo, "2");
                this.apisBusiUwInsuredService.updateStatus(taskLog.getBusinessKey(), "2");
            } else if ("6".equals(orderStatus)) {
                this.apisBusiUwOrderService.updateStatus(orderNo, "7");
                this.apisBusiUwInsuredService.updateStatus(taskLog.getBusinessKey(), "7");
            }
            taskLog.setPushStatus("1");
        } else {
            taskLog.setPushStatus("4");
        }
        taskLog.setPushStep(Integer.valueOf(taskLog.getPushStep() + 1));
        taskLog.setLastPushTime(LocalDateTime.now());
        taskLog.setPushContent(JSON.toJSONString(attachments));
        this.apisBusiTaskLogService.updateById((Object)taskLog);
    }

    private boolean uploadToMedia(List<ApisBusiUwAttachment> attachments, String orderNo) {
        boolean success = true;
        if (ObjectUtils.isNotEmpty(attachments)) {
            for (ApisBusiUwAttachment attachment : attachments) {
                try {
                    log.warn("\u4eba\u5de5\u6838\u4fdd\u4e0a\u4f20\u5f71\u50cf\u7cfb\u7edf\u5f00\u59cb:{}", (Object)attachment);
                    ImgBatchUploadRequestDTO imgBatchUploadRequestDTO = new ImgBatchUploadRequestDTO();
                    RequestHeadDTO requestHeadDTO = new RequestHeadDTO();
                    requestHeadDTO.setSeqNo(UUID.randomUUID().toString().replace("-", ""));
                    requestHeadDTO.setRequestTime(new Date());
                    requestHeadDTO.setOptComCode("apis");
                    requestHeadDTO.setOptUserCode(attachment.getCreator());
                    requestHeadDTO.setOptUserName("apis");
                    imgBatchUploadRequestDTO.setHeadDto(requestHeadDTO);
                    ImgBusiDTO imgBusiDTO = new ImgBusiDTO();
                    imgBusiDTO.setAppCode("CL");
                    imgBusiDTO.setClassCode("CLA");
                    imgBusiDTO.setBusinessNo(orderNo);
                    imgBusiDTO.setBusiComCode("apis");
                    imgBatchUploadRequestDTO.setBusiDto(imgBusiDTO);
                    String fileName = attachment.getAttaName().contains(".") ? attachment.getAttaName() : attachment.getAttaName() + ClaimMediaUploadUtil.suffixOfUrl((String)attachment.getAttaPath());
                    String base64Str = OkHttpUtils.getBase64EncodeByUrl((String)attachment.getAttaPath());
                    log.warn("\u4eba\u5de5\u6838\u4fdd\u4e0b\u8f7d\u6587\u4ef6\uff0c\u6587\u4ef6\u7f16\u53f7: {}-{}", (Object)orderNo, (Object)fileName);
                    if (StringUtils.isEmpty((CharSequence)base64Str)) {
                        log.error("\u4eba\u5de5\u6838\u4fdd\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25,\u6587\u4ef6\u7f16\u53f7:  {}-{}", (Object)orderNo, (Object)fileName);
                        log.error("\u4eba\u5de5\u6838\u4fdd\u8d54\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25,url: {}", (Object)attachment.getAttaPath());
                        continue;
                    }
                    ImgBatchUploadMetaDTO imgBatchUploadMetaDTO = new ImgBatchUploadMetaDTO();
                    imgBatchUploadMetaDTO.setBase64FileContent(base64Str);
                    imgBatchUploadMetaDTO.setFileURL(attachment.getAttaPath());
                    imgBatchUploadMetaDTO.setCovered(false);
                    imgBatchUploadMetaDTO.setFileOrgName(fileName);
                    imgBatchUploadMetaDTO.setImgType("|999|");
                    imgBatchUploadMetaDTO.setImgTypeName("|\u5176\u4ed6|");
                    ArrayList<ImgBatchUploadMetaDTO> uploadMetaDTOList = new ArrayList<ImgBatchUploadMetaDTO>();
                    uploadMetaDTOList.add(imgBatchUploadMetaDTO);
                    imgBatchUploadRequestDTO.setUploadMetas(uploadMetaDTOList);
                    ClaimMediaCommitResult claimMediaCommitResult = this.claimMediaUploadUtil.imgBatchUpload(imgBatchUploadRequestDTO);
                    if (!ObjectUtils.isNotEmpty((Object)claimMediaCommitResult.getImgNodes())) continue;
                    attachment.setAttaName(fileName);
                    attachment.setAttaImgPath(((ImgNode)claimMediaCommitResult.getImgNodes().get(0)).getImgUrl());
                    attachment.setAttaSize(Integer.valueOf(((ImgNode)claimMediaCommitResult.getImgNodes().get(0)).getFileSize().intValue()));
                    if (attachment.getStatus().equals("1")) {
                        attachment.setStatus("2");
                        continue;
                    }
                    if (!attachment.getStatus().equals("3")) continue;
                    attachment.setStatus("4");
                }
                catch (Exception e) {
                    log.error("\u4eba\u5de5\u6838\u4fdd\u8ba2\u5355\u3010{}\u3011\u4e0a\u4f20\u3010{}\u3011\u8d44\u6599\u5931\u8d25:", new Object[]{orderNo, attachment.getAttaName(), e});
                    success = false;
                }
            }
            this.apisBusiUwAttachmentService.updateBatchById(attachments);
        }
        return success;
    }
}

