/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.xxljob.executor.common.service;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.XmlUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.zhizhen.AgentResultResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.constant.ModelConstants;
import com.jdaz.sinosoftgz.apis.commons.utils.OkHttpUtils;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ManUnderwriteResultService {
    private static final Logger log = LoggerFactory.getLogger(ManUnderwriteResultService.class);
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;

    public void pushAgent(ApisBusiTaskLog taskLog) {
        if (ObjectUtil.isEmpty((Object)taskLog)) {
            log.error("\u63a8\u9001\u4efb\u52a1\u4e3a\u7a7a");
            return;
        }
        if (StringUtils.isBlank((CharSequence)taskLog.getBusinessKey())) {
            log.error("\u63a8\u9001\u4e1a\u52a1\u952ebusinessKey\u4e3a\u7a7a");
            return;
        }
        if (StringUtils.isBlank((CharSequence)taskLog.getPushTargetUrl())) {
            log.error("\u672a\u80fd\u83b7\u53d6\u63a8\u9001Url");
            return;
        }
        taskLog.setPushStep(Integer.valueOf(taskLog.getPushStep() + 1));
        taskLog.setPushStatus("2");
        taskLog.setLastPushTime(LocalDateTime.now());
        try {
            this.convertAndPush(taskLog);
        }
        catch (Exception e) {
            log.error("\u4eba\u5de5\u6838\u4fdd\u6e20\u9053\u7ed3\u679c\u63a8\u9001\u5931\u8d25 error:", (Throwable)e);
            taskLog.setPushStatus("4");
            if (StringUtils.isNotBlank((CharSequence)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT) {
                taskLog.setErrMsg(e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT));
            } else {
                taskLog.setErrMsg(e.getMessage());
            }
        }
        finally {
            this.apisBusiTaskLogService.updateById((Object)taskLog);
        }
    }

    private void convertAndPush(ApisBusiTaskLog taskLog) {
        String responseXml = OkHttpUtils.postXml((String)taskLog.getPushTargetUrl(), (String)taskLog.getPushContent());
        log.warn("\u6e20\u9053\u7ed3\u679c\u901a\u77e5\u54cd\u5e94\u7ed3\u679c: {}", (Object)responseXml);
        if (ObjectUtils.isEmpty((Object)responseXml)) {
            taskLog.setPushStatus("4");
            taskLog.setErrMsg("\u4eba\u5de5\u6838\u4fdd\u7ed3\u679c\u63a8\u9001\u6e20\u9053\u672a\u8fd4\u56de\u5185\u5bb9");
        } else {
            Map resultMap = XmlUtil.xmlToMap((String)responseXml);
            String mapString = JSON.toJSONString((Object)resultMap);
            AgentResultResponse response = (AgentResultResponse)JSON.parseObject((String)mapString, AgentResultResponse.class);
            if (ChannelErrorCodeEnum.ERR_C10002.getKey().equals(response.getHead().getErrorCode())) {
                taskLog.setPushStatus("1");
            } else {
                taskLog.setPushStatus("4");
                log.error("\u4eba\u5de5\u6838\u4fdd\u7ed3\u679c\u63a8\u9001\u6e20\u9053,\u8fd4\u56de\u5185\u5bb9:{}", (Object)responseXml);
            }
            taskLog.setErrMsg(responseXml);
        }
    }
}

