/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.xxljob.executor.common.service;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.XmlUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.response.ZhizhenResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.utils.ManUnderwriteUtil;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.zhizhen.AgentResultResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.zhizhen.ManUnderwriteSubmitToZzRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.zhizhen.ManUnderwriteSubmitToZzResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.zhizhen.SubmitToZzAttachmentDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.zhizhen.SubmitToZzHealthNoticeDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.zhizhen.SubmitToZzInsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.zhizhen.SubmitToZzRiskDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.zhizhen.SubmitToZzRiskExtraAttriDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.zhizhen.SubmitToZzRiskExtraAttriDutyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.zhizhen.SubmitToZzRiskExtraDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUwInsured;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUwOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUwResult;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUwSupport;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwAttachmentService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwInsuredService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwKindService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwQuestionService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwResultService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwSupportService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelCode;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelUser;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelCodeService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelUserService;
import com.jdaz.sinosoftgz.apis.commons.model.constant.ModelConstants;
import com.jdaz.sinosoftgz.apis.commons.utils.OkHttpUtils;
import com.jdaz.sinosoftgz.apis.commons.utils.OtherUtils;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ZzErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.xxljob.executor.common.utils.CommonTaskUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ManUnderwriteSubmitService {
    private static final Logger log = LoggerFactory.getLogger(ManUnderwriteSubmitService.class);
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    ApisBusiUwOrderService apisBusiUwOrderService;
    @Autowired
    ApisBusiUwSupportService apisBusiUwSupportService;
    @Autowired
    ApisBusiUwInsuredService apisBusiUwInsuredService;
    @Autowired
    ApisBusiUwResultService apisBusiUwResultService;
    @Autowired
    ApisBusiUwQuestionService apisBusiUwQuestionService;
    @Autowired
    ApisBusiUwAttachmentService apisBusiUwAttachmentService;
    @Autowired
    ApisBusiUwKindService apisBusiUwKindService;
    @Autowired
    ApisChannelCodeService apisChannelCodeService;
    @Autowired
    ApisChannelUserService apisChannelUserService;
    @Autowired
    CommonTaskUtil commonTaskUtil;
    private static final Integer TWO = 2;
    private static final String LITTLE = "<";

    public void submit(ApisBusiTaskLog taskLog) {
        if (ObjectUtil.isEmpty((Object)taskLog)) {
            log.error("\u63a8\u9001\u4efb\u52a1\u4e3a\u7a7a");
            return;
        }
        if (StringUtils.isBlank((CharSequence)taskLog.getBusinessKey())) {
            log.error("\u63a8\u9001\u4e1a\u52a1\u952ebusinessKey\u4e3a\u7a7a");
            return;
        }
        taskLog.setPushStep(Integer.valueOf(taskLog.getPushStep() + 1));
        taskLog.setPushStatus("2");
        taskLog.setLastPushTime(LocalDateTime.now());
        try {
            this.convertAndPush(taskLog);
        }
        catch (Exception e) {
            log.error("\u4eba\u5de5\u6838\u4fdd\u63d0\u4ea4\u4f9b\u5e94\u5546\u63a8\u9001\u5931\u8d25 error:", (Throwable)e);
            taskLog.setPushStatus("4");
            if (StringUtils.isNotBlank((CharSequence)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT) {
                taskLog.setErrMsg(e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT));
            } else {
                taskLog.setErrMsg(e.getMessage());
            }
        }
        finally {
            this.apisBusiTaskLogService.updateById((Object)taskLog);
        }
    }

    private void convertAndPush(ApisBusiTaskLog taskLog) {
        String status;
        log.warn("\u5f00\u59cb\u6267\u884c\u4eba\u5de5\u6838\u4fdd\u63a8\u9001\u4f9b\u5e94\u5546\u4efb\u52a1\uff1a{}", (Object)JSON.toJSONString((Object)taskLog));
        String orderNo = taskLog.getBusinessKey();
        ApisBusiUwOrder order = this.apisBusiUwOrderService.getByOrderNo(orderNo);
        if (ObjectUtils.isEmpty((Object)order)) {
            taskLog.setPushStatus("5");
            taskLog.setErrMsg("\u8ba2\u5355\u53f7\u3010" + orderNo + "\u3011\u4e0d\u5b58\u5728\u5bf9\u5e94\u8ba2\u5355");
            return;
        }
        if (!"2".equals(order.getStatus()) && !"3".equals(order.getStatus())) {
            taskLog.setPushStatus("4");
            taskLog.setErrMsg("\u8ba2\u5355\u53f7\u3010" + orderNo + "\u3011\u8ba2\u5355\u72b6\u6001\u4e3a\u3010" + order.getStatus() + "\u3011\u4e0d\u80fd\u63a8\u9001\u4f9b\u5e94\u5546");
            return;
        }
        List originInsuredList = this.apisBusiUwInsuredService.listByOrderNo(order.getOrderNo());
        boolean isAnyNotUploaded = originInsuredList.stream().anyMatch(insured -> !"2".equals(insured.getStatus()) && !"3".equals(insured.getStatus()));
        if (isAnyNotUploaded) {
            taskLog.setPushStatus("4");
            taskLog.setErrMsg("\u8ba2\u5355\u53f7\u3010" + orderNo + "\u3011\u5b58\u5728\u88ab\u4fdd\u4eba\u672a\u4e0a\u4f20\u5f71\u50cf\uff0c\u4e0d\u80fd\u63a8\u9001\u4f9b\u5e94\u5546");
            return;
        }
        List shouldSubmitList = this.filterBmiInsured(originInsuredList, order);
        if (ObjectUtils.isEmpty((Object)shouldSubmitList)) {
            taskLog.setPushStatus("5");
            taskLog.setErrMsg("\u8ba2\u5355\u53f7\u3010" + orderNo + "\u3011\u88ab\u4fdd\u4ebaBMI\u5168\u90e8\u5408\u683c\uff0c\u65e0\u9700\u63a8\u9001\u4f9b\u5e94\u5546\u6838\u4fdd");
            return;
        }
        List insuredList = this.convertInsureds(shouldSubmitList);
        if (ObjectUtils.isEmpty((Object)insuredList)) {
            taskLog.setPushStatus("5");
            taskLog.setErrMsg("\u8ba2\u5355\u53f7\u3010" + orderNo + "\u3011\u4e0d\u5b58\u5728\u88ab\u4fdd\u4eba");
            return;
        }
        ManUnderwriteSubmitToZzRequest zzRequest = ManUnderwriteSubmitToZzRequest.builder().reqOrderNo(orderNo).insuredList(insuredList).build();
        ApisBusiUwSupport support = this.apisBusiUwSupportService.getEnableSupport(order.getSupportCode());
        String msg = ManUnderwriteUtil.checkSupport((ApisBusiUwSupport)support, (String)order.getSupportCode(), (String)"uw_submit_url");
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            taskLog.setPushStatus("5");
            taskLog.setErrMsg(msg);
            return;
        }
        support.setCurrentUrl(support.getUwSubmitUrl());
        taskLog.setPushTargetUrl(support.getUwSubmitUrl());
        ZhizhenResponse response = this.commonTaskUtil.convertAndSendZz(support, (Object)zzRequest, "1001", ManUnderwriteSubmitToZzResponse.class);
        if (ObjectUtils.isEmpty((Object)response) || ObjectUtils.isEmpty((Object)response.getState())) {
            taskLog.setPushStatus("4");
            taskLog.setErrMsg("\u4eba\u5de5\u6838\u4fdd\u63d0\u4ea4\u4f9b\u5e94\u5546\u63a8\u9001\u6e20\u9053\u672a\u8fd4\u56de\u5185\u5bb9");
            status = "3";
        } else {
            if (ZzErrorCodeEnum.STAT_SUCCESS.getKey().equals(response.getState()) && ZzErrorCodeEnum.BUS_STATE_SUCCESS.getKey().equals(((ManUnderwriteSubmitToZzResponse)response.getResult()).getBusinessState())) {
                taskLog.setPushStatus("1");
                status = "4";
            } else {
                taskLog.setPushStatus("4");
                status = "3";
                log.error("\u4eba\u5de5\u6838\u4fdd\u63d0\u4ea4\u4f9b\u5e94\u5546\u63a8\u9001\u6e20\u9053,\u8fd4\u56de\u5185\u5bb9:{}", (Object)JSON.toJSONString((Object)response));
            }
            taskLog.setErrMsg(JSON.toJSONString((Object)response));
        }
        if (StringUtils.isNotBlank((CharSequence)status)) {
            this.apisBusiUwOrderService.updateStatus(orderNo, status);
            this.apisBusiUwInsuredService.updateStatusByOrderNo(orderNo, status);
        }
    }

    private List<ApisBusiUwInsured> filterBmiInsured(List<ApisBusiUwInsured> insuredList, ApisBusiUwOrder order) {
        List bmiList = insuredList.stream().filter(insured -> {
            if (!"01".equals(insured.getIdType())) {
                return false;
            }
            BigDecimal bmi = insured.getWeight().divide(insured.getHeight().movePointLeft(TWO).pow(TWO), (int)TWO, 4);
            int age = IdcardUtil.getAgeByIdCard((String)insured.getIdNo());
            return bmi.compareTo(new BigDecimal(30)) < 0 && 18 <= age && age <= 35;
        }).collect(Collectors.toList());
        if (ObjectUtils.isNotEmpty(bmiList)) {
            List results = bmiList.stream().map(insured -> {
                ApisBusiUwResult result = new ApisBusiUwResult();
                result.setUwId(insured.getUwId());
                result.setUwRsCode("1");
                result.setUwRs("\u6838\u4fdd\u901a\u8fc7");
                result.setPsRs("\u6838\u4fdd\u901a\u8fc7");
                result.setAddFeeRate(new BigDecimal("0"));
                result.setUwExpireTime(LocalDateTime.now().plusDays(14L));
                result.setMain("1");
                result.setName(insured.getName());
                result.setRemark("BMI < 30 \u4e14\u5e74\u9f84\u572818-35\u5468\u5c81,\u4e0d\u9700\u63a8\u6838\u4fdd");
                ApisChannelCode code = this.apisChannelCodeService.getByValue("ZZ_ZJLX", insured.getIdType());
                result.setIdType(ObjectUtils.isEmpty((Object)code) ? null : code.getChannelValue());
                result.setIdNo(insured.getIdNo());
                return result;
            }).collect(Collectors.toList());
            this.apisBusiUwResultService.saveBatch(results);
            if (bmiList.size() == insuredList.size()) {
                this.convertAndPushResultChannel(bmiList, results, order);
            }
            return insuredList.stream().filter(insured -> !bmiList.stream().allMatch(bmi -> bmi.getIdNo().equals(insured.getIdNo()))).collect(Collectors.toList());
        }
        return insuredList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertAndPushResultChannel(List<ApisBusiUwInsured> bmiList, List<ApisBusiUwResult> results, ApisBusiUwOrder order) {
        this.apisBusiUwOrderService.updateStatus(order.getOrderNo(), "10");
        List updateList = bmiList.stream().map(insured -> insured.setStatus("10")).collect(Collectors.toList());
        this.apisBusiUwInsuredService.updateBatchAddInfoAndStatus(updateList);
        String xmlContent = this.convertXmlContent(results, order);
        ApisBusiTaskLog taskLog = new ApisBusiTaskLog();
        taskLog.setPushType(ApisAutoTaskConstantsEnum.MAN_UNDERWRITE_RESULT_PUSH_AGENT.getValue());
        taskLog.setBusinessKey(order.getOrderNo());
        taskLog.setPushContent(xmlContent);
        try {
            log.warn("\u6e20\u9053\u7ed3\u679c\u901a\u77e5\u8bf7\u6c42\u62a5\u6587: {}", (Object)xmlContent);
            if (StringUtils.isNotBlank((CharSequence)order.getNotifyUrl())) {
                taskLog.setPushTargetUrl(order.getNotifyUrl());
                taskLog.setPushStep(Integer.valueOf(1));
                taskLog.setLastPushTime(LocalDateTime.now());
                String responseXml = OkHttpUtils.postXml((String)order.getNotifyUrl(), (String)xmlContent);
                log.warn("\u6e20\u9053\u7ed3\u679c\u901a\u77e5\u54cd\u5e94\u7ed3\u679c: {}", (Object)responseXml);
                if (ObjectUtils.isEmpty((Object)responseXml)) {
                    taskLog.setPushStatus("4");
                    taskLog.setErrMsg("\u4eba\u5de5\u6838\u4fdd\u7ed3\u679c\u63a8\u9001\u6e20\u9053\u672a\u8fd4\u56de\u5185\u5bb9");
                } else if (!responseXml.startsWith(LITTLE)) {
                    taskLog.setPushStatus("4");
                    taskLog.setErrMsg("\u4eba\u5de5\u6838\u4fdd\u7ed3\u679c\u63a8\u9001\u6e20\u9053\u8fd4\u56de\u683c\u5f0f\u9519\u8bef:" + responseXml);
                } else {
                    Map resultMap = XmlUtil.xmlToMap((String)responseXml);
                    String mapString = JSON.toJSONString((Object)resultMap);
                    AgentResultResponse response = (AgentResultResponse)JSON.parseObject((String)mapString, AgentResultResponse.class);
                    if (ChannelErrorCodeEnum.ERR_C10002.getKey().equals(response.getHead().getErrorCode())) {
                        taskLog.setPushStatus("1");
                    } else {
                        taskLog.setPushStatus("4");
                        log.error("\u4eba\u5de5\u6838\u4fdd\u7ed3\u679c\u63a8\u9001\u6e20\u9053,\u8fd4\u56de\u5185\u5bb9:{}", (Object)responseXml);
                    }
                    taskLog.setErrMsg(responseXml);
                }
            } else {
                taskLog.setErrMsg("\u672a\u80fd\u83b7\u53d6\u63a8\u9001Url");
            }
        }
        catch (Exception e) {
            log.error("\u4eba\u5de5\u6838\u4fdd\u6e20\u9053\u7ed3\u679c\u63a8\u9001\u5931\u8d25 error:", (Throwable)e);
            taskLog.setPushStatus("4");
            if (StringUtils.isNotBlank((CharSequence)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT) {
                taskLog.setErrMsg(e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT));
            } else {
                taskLog.setErrMsg(e.getMessage());
            }
        }
        finally {
            this.apisBusiTaskLogService.saveTaskInfo(taskLog);
        }
    }

    private String convertXmlContent(List<ApisBusiUwResult> results, ApisBusiUwOrder order) {
        String requestId = UUID.randomUUID((boolean)true).toString().replaceAll("-", "");
        String userCode = order.getCreator();
        ApisChannelUser user = this.apisChannelUserService.getUserByUserCode(userCode);
        String password = user.getPwd();
        String agencyPolicyRef = order.getAgencyOrderNo();
        String insureStr = results.stream().filter(result -> "1".equals(result.getMain())).map(r -> {
            String uwResultList = results.stream().filter(item -> r.getUwId().equals(item.getUwId())).map(uwResult -> "                   <UwRsCode>" + uwResult.getUwRsCode() + "</UwRsCode>\n").collect(Collectors.joining());
            return "            <Insured>\n                <InsuredName>" + r.getName() + "</InsuredName>\n                <IdType>" + r.getIdType() + "</IdType>\n                <IdNumber>" + r.getIdNo() + "</IdNumber>\n                <InsuredUwId>" + r.getUwId() + "</InsuredUwId>\n                <PsRs>" + OtherUtils.nullToEmptyStr((String)r.getPsRs()) + "</PsRs>\n                <UwRsReason>" + OtherUtils.nullToEmptyStr((String)r.getUwRsReason()) + "</UwRsReason>\n                <ExceptReason>" + OtherUtils.nullToEmptyStr((String)r.getExceptReason()) + "</ExceptReason>\n                <LimitReason>" + OtherUtils.nullToEmptyStr((String)r.getLimitReason()) + "</LimitReason>\n                <AddFeeRate>" + r.getAddFeeRate() + "</AddFeeRate>\n                <UwExpireTime>" + LocalDateTimeUtil.format((LocalDateTime)r.getUwExpireTime(), (String)"yyyyMMddHHmmss") + "</UwExpireTime>\n                <UwResultList>\n" + uwResultList + "                </UwResultList>\n            </Insured>\n";
        }).collect(Collectors.joining());
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Packet type=\"REQUEST\" version=\"1.0\">\n    <Head>\n        <RequestID>" + requestId + "</RequestID>\n        <RequestType>UW4MRS</RequestType>\n        <User>" + userCode + "</User>\n        <Password>" + password + "</Password>\n    </Head>\n    <Body>\n        <Policy>\n            <AgencyPolicyRef>" + agencyPolicyRef + "</AgencyPolicyRef>\n        </Policy>\n        <InsuredList>\n" + insureStr + "        </InsuredList>\n    </Body>\n</Packet>";
    }

    private List<SubmitToZzInsuredDTO> convertInsureds(List<ApisBusiUwInsured> insuredList) {
        if (ObjectUtils.isEmpty(insuredList)) {
            return null;
        }
        List uwIdList = insuredList.stream().map(ApisBusiUwInsured::getUwId).collect(Collectors.toList());
        List questionList = this.apisBusiUwQuestionService.listBuUwIds(uwIdList);
        List attachmentList = this.apisBusiUwAttachmentService.listBuUwIds(uwIdList);
        List kindList = this.apisBusiUwKindService.listByUwIds(uwIdList);
        return insuredList.stream().map(insured -> {
            SubmitToZzInsuredDTO dto = new SubmitToZzInsuredDTO();
            dto.setName(insured.getName());
            ApisChannelCode code = this.apisChannelCodeService.getByValue("ZZ_ZJLX", insured.getIdType());
            dto.setIdType(ObjectUtils.isEmpty((Object)code) ? null : code.getChannelValue());
            dto.setIdNo(insured.getIdNo());
            dto.setHeight(insured.getHeight().movePointLeft(TWO));
            dto.setWeight(insured.getWeight());
            dto.setAddInfo(insured.getAddInfo());
            dto.setProfession(insured.getOccupationName());
            SubmitToZzRiskDTO riskDTO = new SubmitToZzRiskDTO();
            riskDTO.setRisk(insured.getRationName());
            riskDTO.setAmnt(insured.getAmount());
            riskDTO.setPrem(insured.getPremium());
            SubmitToZzRiskExtraDTO extraDTO = new SubmitToZzRiskExtraDTO();
            extraDTO.setBuskey("01");
            SubmitToZzRiskExtraAttriDTO attriDTO = new SubmitToZzRiskExtraAttriDTO();
            attriDTO.setIsIncludeExphos("y".equals(insured.getIncludeExpHosp()) ? "0" : "1");
            attriDTO.setDeductible(insured.getDeductibleHosp());
            List dutyList = kindList.stream().filter(kind -> kind.getUwId().equals(insured.getUwId())).map(k -> SubmitToZzRiskExtraAttriDutyDTO.builder().dutyName(k.getKindName()).dutyAmnt(k.getAmount()).build()).collect(Collectors.toList());
            attriDTO.setDutyList(dutyList);
            extraDTO.setAttri(attriDTO);
            riskDTO.setRiskExtra(extraDTO);
            dto.setRiskList((List)Lists.newArrayList((Object[])new SubmitToZzRiskDTO[]{riskDTO}));
            List noticeDTOList = questionList.stream().filter(question -> question.getUwId().equals(insured.getUwId())).map(q -> SubmitToZzHealthNoticeDTO.builder().question(q.getQuestion()).answer(q.getAnswer()).build()).collect(Collectors.toList());
            dto.setHealthNoticeList(noticeDTOList);
            List attachmentDTOList = attachmentList.stream().filter(attachment -> attachment.getUwId().equals(insured.getUwId()) && "2".equals(attachment.getStatus())).map(a -> {
                String base64Str = OkHttpUtils.getBase64EncodeByUrl((String)a.getAttaImgPath());
                return SubmitToZzAttachmentDTO.builder().name(a.getAttaName()).type(a.getAttaType()).data(base64Str).build();
            }).collect(Collectors.toList());
            dto.setAttachmentList(attachmentDTOList);
            return dto;
        }).collect(Collectors.toList());
    }
}

