/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.xxljob.executor.common.service;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.response.ZhizhenResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.utils.ManUnderwriteUtil;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.zhizhen.ManUnderwriteSupplyToZzRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.zhizhen.ManUnderwriteSupplyToZzResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.zhizhen.SubmitToZzAttachmentDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.zhizhen.SupplyToZzInsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUwInsured;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUwOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUwSupport;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwAttachmentService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwInsuredService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwSupportService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelCode;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelCodeService;
import com.jdaz.sinosoftgz.apis.commons.model.constant.ModelConstants;
import com.jdaz.sinosoftgz.apis.commons.utils.OkHttpUtils;
import com.jdaz.sinosoftgz.apis.constants.ZzErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.xxljob.executor.common.utils.CommonTaskUtil;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ManUnderwriteSupplyService {
    private static final Logger log = LoggerFactory.getLogger(ManUnderwriteSupplyService.class);
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    ApisBusiUwOrderService apisBusiUwOrderService;
    @Autowired
    ApisBusiUwInsuredService apisBusiUwInsuredService;
    @Autowired
    ApisBusiUwSupportService apisBusiUwSupportService;
    @Autowired
    CommonTaskUtil commonTaskUtil;
    @Autowired
    ApisChannelCodeService apisChannelCodeService;
    @Autowired
    ApisBusiUwAttachmentService apisBusiUwAttachmentService;

    public void supply(ApisBusiTaskLog taskLog) {
        if (ObjectUtil.isEmpty((Object)taskLog)) {
            log.error("\u63a8\u9001\u4efb\u52a1\u4e3a\u7a7a");
            return;
        }
        if (StringUtils.isBlank((CharSequence)taskLog.getBusinessKey())) {
            log.error("\u63a8\u9001\u4e1a\u52a1\u952ebusinessKey\u4e3a\u7a7a");
            return;
        }
        taskLog.setPushStep(Integer.valueOf(taskLog.getPushStep() + 1));
        taskLog.setPushStatus("2");
        taskLog.setLastPushTime(LocalDateTime.now());
        try {
            this.convertAndPush(taskLog);
        }
        catch (Exception e) {
            log.error("\u4eba\u5de5\u6838\u4fdd\u63d0\u4ea4\u4f9b\u5e94\u5546\u63a8\u9001\u5931\u8d25 error:", (Throwable)e);
            taskLog.setPushStatus("4");
            if (StringUtils.isNotBlank((CharSequence)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT) {
                taskLog.setErrMsg(e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT));
            } else {
                taskLog.setErrMsg(e.getMessage());
            }
        }
        finally {
            this.apisBusiTaskLogService.updateById((Object)taskLog);
        }
    }

    private void convertAndPush(ApisBusiTaskLog taskLog) {
        String status;
        log.warn("\u5f00\u59cb\u6267\u884c\u4eba\u5de5\u6838\u4fdd-\u8865\u5145\u8d44\u6599\u63a8\u9001\u4f9b\u5e94\u5546\u4efb\u52a1\uff1a{}", (Object)JSON.toJSONString((Object)taskLog));
        String orderNo = taskLog.getBusinessKey();
        ApisBusiUwOrder order = this.apisBusiUwOrderService.getByOrderNo(orderNo);
        if (ObjectUtils.isEmpty((Object)order)) {
            taskLog.setPushStatus("5");
            taskLog.setErrMsg("\u8ba2\u5355\u53f7\u3010" + orderNo + "\u3011\u4e0d\u5b58\u5728\u5bf9\u5e94\u8ba2\u5355");
            return;
        }
        if (!"7".equals(order.getStatus()) && !"8".equals(order.getStatus())) {
            taskLog.setPushStatus("4");
            taskLog.setErrMsg("\u8ba2\u5355\u53f7\u3010" + orderNo + "\u3011\u8ba2\u5355\u72b6\u6001\u4e3a\u3010" + order.getStatus() + "\u3011\u4e0d\u80fd\u63a8\u9001\u8865\u5145\u8d44\u6599\u5230\u4f9b\u5e94\u5546");
            return;
        }
        List originInsuredList = this.apisBusiUwInsuredService.listByOrderNo(order.getOrderNo());
        boolean isAnyNotUploaded = originInsuredList.stream().anyMatch(insured -> !"7".equals(insured.getStatus()) && !"8".equals(insured.getStatus()) && !"10".equals(insured.getStatus()));
        if (isAnyNotUploaded) {
            taskLog.setPushStatus("4");
            taskLog.setErrMsg("\u8ba2\u5355\u53f7\u3010" + orderNo + "\u3011\u5b58\u5728\u88ab\u4fdd\u4eba\u672a\u4e0a\u4f20\u5f71\u50cf\uff0c\u4e0d\u80fd\u63a8\u9001\u8865\u5145\u8d44\u6599\u5230\u4f9b\u5e94\u5546");
            return;
        }
        List insuredList = this.convertInsureds(originInsuredList);
        if (ObjectUtils.isEmpty((Object)insuredList)) {
            taskLog.setPushStatus("5");
            taskLog.setErrMsg("\u8ba2\u5355\u53f7\u3010" + orderNo + "\u3011\u4e0d\u5b58\u5728\u9700\u8981\u8865\u5145\u8d44\u6599\u7684\u88ab\u4fdd\u4eba");
            return;
        }
        ManUnderwriteSupplyToZzRequest zzRequest = ManUnderwriteSupplyToZzRequest.builder().reqOrderNo(orderNo).insuredList(insuredList).build();
        ApisBusiUwSupport support = this.apisBusiUwSupportService.getEnableSupport(order.getSupportCode());
        String msg = ManUnderwriteUtil.checkSupport((ApisBusiUwSupport)support, (String)order.getSupportCode(), (String)"uw_add_url");
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            taskLog.setPushStatus("5");
            taskLog.setErrMsg(msg);
            return;
        }
        support.setCurrentUrl(support.getUwAddUrl());
        taskLog.setPushTargetUrl(support.getUwAddUrl());
        ZhizhenResponse response = this.commonTaskUtil.convertAndSendZz(support, (Object)zzRequest, "1002", ManUnderwriteSupplyToZzResponse.class);
        if (ObjectUtils.isEmpty((Object)response) || ObjectUtils.isEmpty((Object)response.getState())) {
            taskLog.setPushStatus("4");
            taskLog.setErrMsg("\u4eba\u5de5\u6838\u4fdd-\u8865\u5145\u8d44\u6599\u63d0\u4ea4\u4f9b\u5e94\u5546\u63a8\u9001\u6e20\u9053\u672a\u8fd4\u56de\u5185\u5bb9");
            status = "8";
        } else {
            if (ZzErrorCodeEnum.STAT_SUCCESS.getKey().equals(response.getState()) && ZzErrorCodeEnum.BUS_STATE_SUCCESS.getKey().equals(((ManUnderwriteSupplyToZzResponse)response.getResult()).getBusinessState())) {
                taskLog.setPushStatus("1");
                status = "9";
            } else {
                taskLog.setPushStatus("4");
                status = "8";
                log.error("\u4eba\u5de5\u6838\u4fdd-\u8865\u5145\u8d44\u6599\u63d0\u4ea4\u4f9b\u5e94\u5546\u63a8\u9001\u6e20\u9053,\u8fd4\u56de\u5185\u5bb9:{}", (Object)JSON.toJSONString((Object)response));
            }
            taskLog.setErrMsg(JSON.toJSONString((Object)response));
        }
        if (StringUtils.isNotBlank((CharSequence)status)) {
            this.apisBusiUwOrderService.updateStatus(orderNo, status);
            this.apisBusiUwInsuredService.updateStatusByOrderNo(orderNo, status);
        }
    }

    private List<SupplyToZzInsuredDTO> convertInsureds(List<ApisBusiUwInsured> insuredList) {
        if (ObjectUtils.isEmpty(insuredList)) {
            return null;
        }
        List supplyInsuredList = insuredList.stream().filter(insured -> "7".equals(insured.getStatus())).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(supplyInsuredList)) {
            return null;
        }
        List uwIdList = supplyInsuredList.stream().map(ApisBusiUwInsured::getUwId).collect(Collectors.toList());
        List attachmentList = this.apisBusiUwAttachmentService.listBuUwIds(uwIdList);
        return supplyInsuredList.stream().map(insured -> {
            SupplyToZzInsuredDTO zzInsuredDTO = new SupplyToZzInsuredDTO();
            zzInsuredDTO.setName(insured.getName());
            ApisChannelCode code = this.apisChannelCodeService.getByValue("ZZ_ZJLX", insured.getIdType());
            zzInsuredDTO.setIdType(ObjectUtils.isEmpty((Object)code) ? null : code.getChannelValue());
            zzInsuredDTO.setIdNo(insured.getIdNo());
            zzInsuredDTO.setAddInfo(insured.getAddInfo());
            List attachmentDTOList = null;
            if (ObjectUtils.isNotEmpty((Object)attachmentList)) {
                attachmentDTOList = attachmentList.stream().filter(attachment -> attachment.getUwId().equals(insured.getUwId()) && "4".equals(attachment.getStatus())).map(a -> {
                    String base64Str = OkHttpUtils.getBase64EncodeByUrl((String)a.getAttaImgPath());
                    return SubmitToZzAttachmentDTO.builder().name(a.getAttaName()).type(a.getAttaType()).data(base64Str).build();
                }).collect(Collectors.toList());
            }
            zzInsuredDTO.setAttachmentList(attachmentDTOList);
            return zzInsuredDTO;
        }).collect(Collectors.toList());
    }
}

