/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.xxljob.executor.common.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.AnalysisConstants;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiAnalysisTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxClaimMedia;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxClaimRegist;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiAnalysisTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxAddInsuredVoucherService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxClaimMediaService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxClaimRegistService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxVoucherMedicineService;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.config.ThirdpClaimRegistConfigJsonVo;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.MxYkfClaimEndCaseClaim;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.MxYkfClaimEndCaseRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.MxYqClaimEndCasePaymentInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.MxYqClaimEndCaseRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.ThirdpClaimRegistBody;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.ThirdpClaimRegistClaimMain;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.ThirdpClaimRegistImageData;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.ThirdpClaimRegistMedicine;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.ThirdpClaimRegistPayee;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.ThirdpClaimRegistPayeeAml;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.ThirdpClaimRegistPayeeAmlCom;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.ThirdpClaimRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.ThirdpClaimRequestHead;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.ThirdpCustomerBeneficiaryInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.ThirdpCustomerCertifyInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.resp.ThirdpClaimResponse;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelCode;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelCodeService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.constant.ModelConstants;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorBisCodeEnum;
import com.jdaz.sinosoftgz.apis.xxljob.executor.common.service.MxClaimEndCasePushService;
import com.jdaz.sinosoftgz.apis.xxljob.executor.common.utils.ChannelUserConfigUtil;
import com.jdaz.sinosoftgz.apis.xxljob.executor.common.utils.ClaimMediaUploadUtil;
import com.jdaz.sinosoftgz.coreapi.common.service.HttpRequestService;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ThirdpClaimRegistPushService {
    private static final Logger log = LoggerFactory.getLogger(ThirdpClaimRegistPushService.class);
    @Autowired
    ApisBusiAnalysisTaskLogService apisBusiAnalysisTaskLogService;
    @Autowired
    ApisBusiMxAddInsuredVoucherService apisBusiMxAddInsuredVoucherService;
    @Autowired
    ApisBusiMxClaimRegistService apisBusiMxClaimRegistService;
    @Autowired
    ApisBusiMxClaimMediaService apisBusiMxClaimMediaService;
    @Autowired
    ApisBusiMxVoucherMedicineService apisBusiMxVoucherMedicineService;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    ApisChannelCodeService apisChannelCodeService;
    @Autowired
    HttpRequestService httpRequestService;
    @Autowired
    ClaimMediaUploadUtil claimMediaUploadUtil;
    @Autowired
    MxClaimEndCasePushService mxClaimEndCasePushService;
    @Autowired
    ChannelUserConfigUtil channelUserConfigUtil;
    @Value(value="${coreapi.thirdp.claimRegist.url}")
    String thirdpClaimRegistUrl;
    @Value(value="${analysis.task.max_push_times}")
    private Integer maxPushTimes;
    private static final Integer POINT = 2;
    private static ThirdpClaimRegistConfigJsonVo MX_CONFIG;
    private static ThirdpClaimRegistConfigJsonVo YQ_CONFIG;

    public void convertYkfAndPush(ApisBusiMxClaimRegist regist, List<ApisBusiMxClaimMedia> mediaList, ApisBusiAnalysisTaskLog taskLog) {
        try {
            mediaList = this.claimMediaUploadUtil.asyncUploadMxClaimMedia(regist, mediaList);
            ThirdpClaimRegistClaimMain main = this.convertMain(regist);
            List payees = this.convertYkfPayee(regist);
            List imageDatas = this.convertImageData(mediaList);
            List medicineList = this.convertMedicines(regist);
            ThirdpClaimRegistBody body = ThirdpClaimRegistBody.builder().claimMain(main).payees(payees).imageDatas(imageDatas).medicineList(medicineList).build();
            ThirdpClaimRequestHead head = ThirdpClaimRequestHead.builder().consumerSeqNo(UUID.randomUUID().toString()).consumerID(this.getMxConfig().getConsumerId()).transactionDate(new Date()).build();
            ThirdpClaimRequest thirdpClaimRequest = ThirdpClaimRequest.builder().head(head).body(body).build();
            this.pushThirdpClaimRegist(thirdpClaimRequest, taskLog, regist.getProjectCode());
        }
        catch (ApisBusinessException e) {
            log.error("\u836f\u5eb7\u4ed8-\u7406\u8d54\u62a5\u6848\u4fe1\u606f\u4e0a\u4f20\u788e\u7ba1\u5f02\u5e38\uff0cclaimApplyId:{}", (Object)regist.getClaimApplyId(), (Object)e);
            taskLog.setPushStatus("4");
            taskLog.setErrMsg(e.getMessage());
            this.apisBusiAnalysisTaskLogService.updateById((Object)taskLog);
        }
        catch (Exception e) {
            log.error("\u836f\u5eb7\u4ed8-\u7406\u8d54\u62a5\u6848\u4fe1\u606f\u4e0a\u4f20\u788e\u7ba1\u5f02\u5e38\uff0cclaimApplyId:{}", (Object)regist.getClaimApplyId(), (Object)e);
        }
    }

    private List<ThirdpClaimRegistMedicine> convertMedicines(ApisBusiMxClaimRegist regist) {
        if ("YKF".equals(regist.getProjectCode()) && this.channelUserConfigUtil.isNewYkfOfCategory1(regist.getOrderNo())) {
            List medicines = this.apisBusiMxVoucherMedicineService.listByRegist(regist.getMxReportNo(), "REGIST");
            if (ObjectUtils.isEmpty((Object)medicines)) {
                return null;
            }
            return medicines.stream().map(medicine -> {
                ThirdpClaimRegistMedicine registMedicine = new ThirdpClaimRegistMedicine();
                registMedicine.setStoreCode(medicine.getStoreCode());
                registMedicine.setStoreName(medicine.getStoreName());
                registMedicine.setMedicineCode(medicine.getMedicineCode());
                registMedicine.setMedicineName(medicine.getMedicineName());
                registMedicine.setMedicineFee(medicine.getMedicineFee().movePointLeft(POINT));
                registMedicine.setMedicineUnits(medicine.getMedicineUnits());
                return registMedicine;
            }).collect(Collectors.toList());
        }
        return null;
    }

    public void convertYqAndPush(ApisBusiMxClaimRegist regist, ApisBusiAnalysisTaskLog taskLog) {
        try {
            ThirdpClaimRegistClaimMain main = this.convertMain(regist);
            List payees = this.convertYqPayee(regist);
            ThirdpClaimRegistBody body = ThirdpClaimRegistBody.builder().claimMain(main).payees(payees).imageDatas((List)Lists.newArrayList()).build();
            ThirdpClaimRequestHead head = ThirdpClaimRequestHead.builder().consumerSeqNo(UUID.randomUUID().toString()).consumerID(this.getYqConfig().getConsumerId()).transactionDate(new Date()).build();
            ThirdpClaimRequest thirdpClaimRequest = ThirdpClaimRequest.builder().head(head).body(body).build();
            this.pushThirdpClaimRegist(thirdpClaimRequest, taskLog, regist.getProjectCode());
        }
        catch (Exception e) {
            log.error("\u836f\u4f01-\u7406\u8d54\u62a5\u6848\u4fe1\u606f\u4e0a\u4f20\u788e\u7ba1\u5f02\u5e38:", (Throwable)e);
        }
    }

    private List<ThirdpClaimRegistImageData> convertImageData(List<ApisBusiMxClaimMedia> mediaList) {
        if (ObjectUtils.isEmpty(mediaList)) {
            return null;
        }
        return mediaList.stream().map(media -> {
            ThirdpClaimRegistImageData imageData = new ThirdpClaimRegistImageData();
            imageData.setDataType(this.getMxConfig().getDataType());
            imageData.setDataUrl(media.getMediaUrl());
            imageData.setDataName(media.getMediaNo() + "." + media.getFileSuffix());
            return imageData;
        }).collect(Collectors.toList());
    }

    private List<ThirdpClaimRegistPayee> convertYkfPayee(ApisBusiMxClaimRegist regist) {
        ArrayList<ThirdpClaimRegistPayee> payees = new ArrayList<ThirdpClaimRegistPayee>();
        ThirdpClaimRegistPayee payee = new ThirdpClaimRegistPayee();
        payee.setCompensateType(this.getMxConfig().getPayee().getCompensateType());
        payee.setPayeeName(this.getMxConfig().getPayee().getPayeeName());
        payee.setPayeeAccount(this.getMxConfig().getPayee().getPayeeAccount());
        payee.setPayeeAmlType("2");
        payee.setBankCode(this.getMxConfig().getPayee().getBankCode());
        payee.setBankName(this.getMxConfig().getPayee().getBankName());
        payee.setPaymentMethod("02");
        payee.setPaymentType("1");
        payee.setClaimAmount(regist.getAppClaimAmount().movePointLeft(POINT).toString());
        payee.setLossAmount(regist.getAppClaimAmount().movePointLeft(POINT).toString());
        if (ObjectUtils.isNotEmpty((Object)regist.getAppClaimAmount()) && regist.getAppClaimAmount().movePointLeft(POINT).compareTo(AnalysisConstants.THIRPD_NEED_FXQ_MAX) > -1) {
            ThirdpClaimRegistPayeeAml insuredAml = this.fillInsuredFxq(regist);
            ArrayList<ThirdpClaimRegistPayeeAml> payeeAmlList = new ArrayList<ThirdpClaimRegistPayeeAml>();
            payeeAmlList.add(insuredAml);
            ThirdpClaimRegistPayeeAmlCom payeeAmlCom = this.fillPayeeComFxq();
            ArrayList<ThirdpClaimRegistPayeeAmlCom> payeeAmlComList = new ArrayList<ThirdpClaimRegistPayeeAmlCom>();
            payeeAmlComList.add(payeeAmlCom);
            payee.setPayeeAmlComList(payeeAmlComList);
            payee.setPayeeAmlList(payeeAmlList);
        }
        payees.add(payee);
        return payees;
    }

    private List<ThirdpClaimRegistPayee> convertYqComPayee(ApisBusiMxClaimRegist regist) {
        ArrayList<ThirdpClaimRegistPayee> payees = new ArrayList<ThirdpClaimRegistPayee>();
        ThirdpClaimRegistPayee payee = new ThirdpClaimRegistPayee();
        ThirdpClaimRegistConfigJsonVo yqConfig = this.getYqConfig();
        payee.setCompensateType(yqConfig.getPayee().getCompensateType());
        payee.setPayeeName(regist.getPayeeBankAccountName());
        payee.setPayeeAccount(regist.getAccountNo());
        payee.setPayeeAmlType("2");
        payee.setBankCode(this.apisChannelCodeService.getValueByCode("PRPDBANK", regist.getPayeeBankName()));
        payee.setBankName(regist.getPayeeBankName());
        payee.setPaymentMethod("02");
        payee.setPaymentType("0");
        payee.setClaimAmount(regist.getAppClaimAmount().movePointLeft(POINT).toString());
        payee.setLossAmount(regist.getAppClaimAmount().movePointLeft(POINT).toString());
        payee.setPayeeNumber(regist.getPayeePhone());
        payee.setPayeeIdentityType(regist.getPayeeIdType());
        payee.setPayeeIdentityNumber(regist.getPayeeIdNo());
        if (ObjectUtils.isNotEmpty((Object)regist.getAppClaimAmount()) && regist.getAppClaimAmount().movePointLeft(POINT).compareTo(AnalysisConstants.THIRPD_NEED_FXQ_MAX) > -1) {
            ThirdpClaimRegistPayeeAml insuredAml = this.fillInsuredFxq(regist);
            ArrayList<ThirdpClaimRegistPayeeAml> payeeAmlList = new ArrayList<ThirdpClaimRegistPayeeAml>();
            payeeAmlList.add(insuredAml);
            ThirdpClaimRegistPayeeAmlCom payeeAmlCom = this.fillYqPayeeComFxq();
            ArrayList<ThirdpClaimRegistPayeeAmlCom> payeeAmlComList = new ArrayList<ThirdpClaimRegistPayeeAmlCom>();
            payeeAmlComList.add(payeeAmlCom);
            payee.setPayeeAmlComList(payeeAmlComList);
            ThirdpClaimRegistPayeeAml payeeAml = new ThirdpClaimRegistPayeeAml();
            payeeAml.setInsuredName(regist.getPayeeBankAccountName());
            payeeAml.setInsuredSex("0");
            payeeAml.setInsuredNationality(yqConfig.getPayee().getInsuredFxqConfigJsonVo().getInsuredNationality());
            payeeAml.setInsuredOccupation(yqConfig.getPayee().getInsuredFxqConfigJsonVo().getInsuredOccupation());
            payeeAml.setInsuredAddressType(yqConfig.getPayee().getInsuredFxqConfigJsonVo().getInsuredAddressType());
            payeeAml.setInsuredAddress(yqConfig.getPayee().getInsuredFxqConfigJsonVo().getInsuredAddress());
            String insuredMobile = regist.getPayeePhone();
            if (StringUtils.isBlank((CharSequence)insuredMobile)) {
                insuredMobile = regist.getReportPhone();
            }
            payeeAml.setInsuredMobile(insuredMobile);
            String insuredCertifyType = this.getCodeValueElseDefault(regist.getPayeeIdType(), "mxClaimThirdpPayeeAmlCertifyType", "THIRDP_INSURED_FXQ_CERTIFY_TYPE");
            payeeAml.setInsuredCertifyType(insuredCertifyType);
            payeeAml.setInsuredCertifyNo(regist.getPayeeIdNo());
            String insuredCertifyValidDate = yqConfig.getPayee().getInsuredFxqConfigJsonVo().getInsuredCertifyValidDate();
            payeeAml.setInsuredCertifyValidDate((Date)DateUtil.parse((CharSequence)insuredCertifyValidDate, (String)"yyyy-MM-dd"));
            payeeAml.setInsuredRelationCode(yqConfig.getPayee().getInsuredFxqConfigJsonVo().getInsuredRelationCode());
            payeeAml.setInsuredRelationName(yqConfig.getPayee().getInsuredFxqConfigJsonVo().getInsuredRelationName());
            payeeAml.setInsuredRelationDetail(yqConfig.getPayee().getInsuredFxqConfigJsonVo().getInsuredRelationDetail());
            payeeAml.setPayeeRelationCode(yqConfig.getPayee().getInsuredFxqConfigJsonVo().getPayeeRelationCode());
            payeeAml.setPayeeRelationName(yqConfig.getPayee().getInsuredFxqConfigJsonVo().getPayeeRelationName());
            payeeAmlList.add(payeeAml);
            payee.setPayeeAmlList(payeeAmlList);
        }
        payees.add(payee);
        return payees;
    }

    private List<ThirdpClaimRegistPayee> convertYqPayee(ApisBusiMxClaimRegist regist) {
        ThirdpClaimRegistConfigJsonVo yqConfig = this.getYqConfig();
        if (StringUtils.isNotBlank((CharSequence)regist.getPayeeBankAccountName()) && regist.getPayeeBankAccountName().equals(yqConfig.getMxCompanyPayeeBankAccountName()) && regist.getPayeeIdType().equals(yqConfig.getMxCompanyPayeeIdType()) && regist.getPayeeIdNo().equals(yqConfig.getMxCompanyPayeeIdNo())) {
            List payees = this.convertYqComPayee(regist);
            return payees;
        }
        ArrayList<ThirdpClaimRegistPayee> payees = new ArrayList<ThirdpClaimRegistPayee>();
        ThirdpClaimRegistPayee payee = new ThirdpClaimRegistPayee();
        payee.setBankCode(this.apisChannelCodeService.getValueByCode("PRPDBANK", regist.getPayeeBankName()));
        payee.setBankName(regist.getPayeeBankName());
        payee.setPaymentMethod("02");
        payee.setPaymentType("0");
        payee.setClaimAmount(regist.getAppClaimAmount().movePointLeft(POINT).toString());
        payee.setLossAmount(regist.getAppClaimAmount().movePointLeft(POINT).toString());
        payee.setCompensateType(yqConfig.getPayee().getCompensateType());
        payee.setPayeeName(regist.getPayeeBankAccountName());
        payee.setPayeeAccount(regist.getAccountNo());
        payee.setPayeeAmlType("1");
        payee.setPayeeNumber(regist.getPayeePhone());
        payee.setPayeeIdentityType(regist.getPayeeIdType());
        payee.setPayeeIdentityNumber(regist.getPayeeIdNo());
        if (ObjectUtils.isNotEmpty((Object)regist.getAppClaimAmount()) && regist.getAppClaimAmount().movePointLeft(POINT).compareTo(AnalysisConstants.THIRPD_NEED_FXQ_MAX) > -1) {
            List payeeAmlList = this.fillYqFxq(regist);
            payee.setPayeeAmlList(payeeAmlList);
        }
        payees.add(payee);
        return payees;
    }

    private List<ThirdpClaimRegistPayeeAml> fillYqFxq(ApisBusiMxClaimRegist regist) {
        ArrayList<ThirdpClaimRegistPayeeAml> payeeAmlList = new ArrayList<ThirdpClaimRegistPayeeAml>();
        ThirdpClaimRegistPayeeAml insuredFxq = this.fillInsuredFxq(regist);
        ThirdpClaimRegistPayeeAml payeeFxq = regist.getPayeeBankAccountName().equals(regist.getInsuredName()) ? (ThirdpClaimRegistPayeeAml)BeanUtil.copyProperties((Object)insuredFxq, ThirdpClaimRegistPayeeAml.class, (String[])new String[0]) : this.fillPayeeFxq(regist);
        payeeAmlList.add(insuredFxq);
        payeeAmlList.add(payeeFxq);
        return payeeAmlList;
    }

    private ThirdpClaimRegistPayeeAmlCom fillPayeeComFxq() {
        ThirdpClaimRegistPayeeAmlCom payeeAmlCom = new ThirdpClaimRegistPayeeAmlCom();
        payeeAmlCom.setInsureComName(this.getMxConfig().getPayee().getComFxqQyfrConfigJsonVo().getInsureComName());
        payeeAmlCom.setInsureIndustry(this.getMxConfig().getPayee().getComFxqQyfrConfigJsonVo().getInsureIndustry());
        payeeAmlCom.setRegistCapitalAmount(new BigDecimal(this.getMxConfig().getPayee().getComFxqQyfrConfigJsonVo().getRegistCapitalAmount()));
        payeeAmlCom.setRegistCapitalCurrency(this.getMxConfig().getPayee().getComFxqQyfrConfigJsonVo().getRegistCapitalCurrency());
        payeeAmlCom.setInsureComAddress(this.getMxConfig().getPayee().getComFxqQyfrConfigJsonVo().getInsureComAddress());
        payeeAmlCom.setInsureComBussScope(this.getMxConfig().getPayee().getComFxqQyfrConfigJsonVo().getInsureComBussScope());
        payeeAmlCom.setInsureComBusinessCode(this.getMxConfig().getPayee().getComFxqQyfrConfigJsonVo().getInsureComBusinessCode());
        ArrayList<ThirdpCustomerCertifyInfo> ccustomerCertifyInfo = new ArrayList<ThirdpCustomerCertifyInfo>();
        String certifyOrPersonFlag = this.getMxConfig().getPayee().getComFxqQyfrConfigJsonVo().getCertifyOrPersonFlag();
        String personValidDate = this.getMxConfig().getPayee().getComFxqQyfrConfigJsonVo().getValidDate();
        String certifyType = this.getMxConfig().getPayee().getComFxqQyfrConfigJsonVo().getCertifyType();
        String certifName = this.getMxConfig().getPayee().getComFxqQyfrConfigJsonVo().getCertifName();
        String certifyNo = this.getMxConfig().getPayee().getComFxqQyfrConfigJsonVo().getCertifyNo();
        ThirdpCustomerCertifyInfo personInfoLegal = new ThirdpCustomerCertifyInfo();
        personInfoLegal.setCertifyOrPersonFlag(certifyOrPersonFlag);
        String certifyOrPersonTypeLegal = this.getMxConfig().getPayee().getComFxqQyfrConfigJsonVo().getCertifyOrPersonTypeLegal();
        personInfoLegal.setCertifyOrPersonType(certifyOrPersonTypeLegal);
        personInfoLegal.setCertifyType(certifyType);
        personInfoLegal.setCertifName(certifName);
        personInfoLegal.setCertifyNo(certifyNo);
        personInfoLegal.setValidDate((Date)DateUtil.parse((CharSequence)personValidDate, (String)"yyyy-MM-dd"));
        ThirdpCustomerCertifyInfo personInfoPrincipal = new ThirdpCustomerCertifyInfo();
        personInfoPrincipal.setCertifyOrPersonFlag(certifyOrPersonFlag);
        String certifyOrPersonTypePrincipal = this.getMxConfig().getPayee().getComFxqQyfrConfigJsonVo().getCertifyOrPersonTypePrincipal();
        personInfoPrincipal.setCertifyOrPersonType(certifyOrPersonTypePrincipal);
        personInfoPrincipal.setCertifyType(certifyType);
        personInfoPrincipal.setCertifName(certifName);
        personInfoPrincipal.setCertifyNo(certifyNo);
        personInfoPrincipal.setValidDate((Date)DateUtil.parse((CharSequence)personValidDate, (String)"yyyy-MM-dd"));
        ThirdpCustomerCertifyInfo personInfoBusiness = new ThirdpCustomerCertifyInfo();
        personInfoBusiness.setCertifyOrPersonFlag(certifyOrPersonFlag);
        String certifyOrPersonTypeBusiness = this.getMxConfig().getPayee().getComFxqQyfrConfigJsonVo().getCertifyOrPersonTypeBusiness();
        personInfoBusiness.setCertifyOrPersonType(certifyOrPersonTypeBusiness);
        personInfoBusiness.setCertifyType(certifyType);
        personInfoBusiness.setCertifName(certifName);
        personInfoBusiness.setCertifyNo(certifyNo);
        personInfoBusiness.setValidDate((Date)DateUtil.parse((CharSequence)personValidDate, (String)"yyyy-MM-dd"));
        ThirdpCustomerCertifyInfo certifyInfo = new ThirdpCustomerCertifyInfo();
        certifyInfo.setCertifyOrPersonFlag(this.getMxConfig().getPayee().getComFxqYyzzConfigJsonVo().getCertifyOrPersonFlag());
        certifyInfo.setCertifyOrPersonType(this.getMxConfig().getPayee().getComFxqYyzzConfigJsonVo().getCertifyOrPersonType());
        certifyInfo.setCertifyType(this.getMxConfig().getPayee().getComFxqYyzzConfigJsonVo().getCertifyType());
        certifyInfo.setCertifName(this.getMxConfig().getPayee().getComFxqYyzzConfigJsonVo().getCertifName());
        certifyInfo.setCertifyNo(this.getMxConfig().getPayee().getComFxqYyzzConfigJsonVo().getCertifyNo());
        String validDate = this.getMxConfig().getPayee().getComFxqYyzzConfigJsonVo().getValidDate();
        certifyInfo.setValidDate((Date)DateUtil.parse((CharSequence)validDate, (String)"yyyy-MM-dd"));
        ccustomerCertifyInfo.add(personInfoLegal);
        ccustomerCertifyInfo.add(personInfoPrincipal);
        ccustomerCertifyInfo.add(personInfoBusiness);
        ccustomerCertifyInfo.add(certifyInfo);
        payeeAmlCom.setCcustomerCertifyInfo(ccustomerCertifyInfo);
        ArrayList<ThirdpCustomerBeneficiaryInfo> ccustomerBeneficiaryInfo = new ArrayList<ThirdpCustomerBeneficiaryInfo>();
        ThirdpCustomerBeneficiaryInfo beneficiaryInfo = new ThirdpCustomerBeneficiaryInfo();
        beneficiaryInfo.setBeneficiaryName(this.getMxConfig().getPayee().getComFxqBeneficiaryConfigJsonVo().getBeneficiaryName());
        beneficiaryInfo.setBeneficiaryNationality(this.getMxConfig().getPayee().getComFxqBeneficiaryConfigJsonVo().getBeneficiaryNationality());
        beneficiaryInfo.setBeneficiaryOccupation(this.getMxConfig().getPayee().getComFxqBeneficiaryConfigJsonVo().getBeneficiaryOccupation());
        beneficiaryInfo.setBeneficiaryAddressType(this.getMxConfig().getPayee().getComFxqBeneficiaryConfigJsonVo().getBeneficiaryAddressType());
        beneficiaryInfo.setBeneficiaryAddress(this.getMxConfig().getPayee().getComFxqBeneficiaryConfigJsonVo().getBeneficiaryAddress());
        beneficiaryInfo.setBeneficiaryCertifyType(this.getMxConfig().getPayee().getComFxqBeneficiaryConfigJsonVo().getBeneficiaryCertifyType());
        beneficiaryInfo.setBeneficiaryCertifyNo(this.getMxConfig().getPayee().getComFxqBeneficiaryConfigJsonVo().getBeneficiaryCertifyNo());
        String beneficiaryCertifyValidDate = this.getMxConfig().getPayee().getComFxqBeneficiaryConfigJsonVo().getBeneficiaryCertifyValidDate();
        beneficiaryInfo.setBeneficiaryCertifyValidDate((Date)DateUtil.parse((CharSequence)beneficiaryCertifyValidDate, (String)"yyyy-MM-dd"));
        beneficiaryInfo.setInsuredRelationCode(this.getMxConfig().getPayee().getComFxqBeneficiaryConfigJsonVo().getInsuredRelationCode());
        beneficiaryInfo.setInsuredRelationName(this.getMxConfig().getPayee().getComFxqBeneficiaryConfigJsonVo().getInsuredRelationName());
        beneficiaryInfo.setInsuredRelationDetail(this.getMxConfig().getPayee().getComFxqBeneficiaryConfigJsonVo().getInsuredRelationDetail());
        beneficiaryInfo.setPayeeRelationCode(this.getMxConfig().getPayee().getComFxqBeneficiaryConfigJsonVo().getPayeeRelationCode());
        beneficiaryInfo.setPayeeRelationName(this.getMxConfig().getPayee().getComFxqBeneficiaryConfigJsonVo().getPayeeRelationName());
        ccustomerBeneficiaryInfo.add(beneficiaryInfo);
        payeeAmlCom.setCcustomerBeneficiaryInfo(ccustomerBeneficiaryInfo);
        return payeeAmlCom;
    }

    private ThirdpClaimRegistPayeeAmlCom fillYqPayeeComFxq() {
        ThirdpClaimRegistPayeeAmlCom payeeAmlCom = new ThirdpClaimRegistPayeeAmlCom();
        ThirdpClaimRegistConfigJsonVo yqConfig = this.getYqConfig();
        payeeAmlCom.setInsureComName(yqConfig.getPayee().getComFxqQyfrConfigJsonVo().getInsureComName());
        payeeAmlCom.setInsureIndustry(yqConfig.getPayee().getComFxqQyfrConfigJsonVo().getInsureIndustry());
        payeeAmlCom.setRegistCapitalAmount(new BigDecimal(yqConfig.getPayee().getComFxqQyfrConfigJsonVo().getRegistCapitalAmount()));
        payeeAmlCom.setRegistCapitalCurrency(yqConfig.getPayee().getComFxqQyfrConfigJsonVo().getRegistCapitalCurrency());
        payeeAmlCom.setInsureComAddress(yqConfig.getPayee().getComFxqQyfrConfigJsonVo().getInsureComAddress());
        payeeAmlCom.setInsureComBussScope(yqConfig.getPayee().getComFxqQyfrConfigJsonVo().getInsureComBussScope());
        payeeAmlCom.setInsureComBusinessCode(yqConfig.getPayee().getComFxqQyfrConfigJsonVo().getInsureComBusinessCode());
        ArrayList<ThirdpCustomerCertifyInfo> ccustomerCertifyInfo = new ArrayList<ThirdpCustomerCertifyInfo>();
        String certifyOrPersonFlag = yqConfig.getPayee().getComFxqQyfrConfigJsonVo().getCertifyOrPersonFlag();
        String personValidDate = yqConfig.getPayee().getComFxqQyfrConfigJsonVo().getValidDate();
        String certifyType = yqConfig.getPayee().getComFxqQyfrConfigJsonVo().getCertifyType();
        String certifName = yqConfig.getPayee().getComFxqQyfrConfigJsonVo().getCertifName();
        String certifyNo = yqConfig.getPayee().getComFxqQyfrConfigJsonVo().getCertifyNo();
        ThirdpCustomerCertifyInfo personInfoLegal = new ThirdpCustomerCertifyInfo();
        personInfoLegal.setCertifyOrPersonFlag(certifyOrPersonFlag);
        String certifyOrPersonTypeLegal = yqConfig.getPayee().getComFxqQyfrConfigJsonVo().getCertifyOrPersonTypeLegal();
        personInfoLegal.setCertifyOrPersonType(certifyOrPersonTypeLegal);
        personInfoLegal.setCertifyType(certifyType);
        personInfoLegal.setCertifName(certifName);
        personInfoLegal.setCertifyNo(certifyNo);
        personInfoLegal.setValidDate((Date)DateUtil.parse((CharSequence)personValidDate, (String)"yyyy-MM-dd"));
        ThirdpCustomerCertifyInfo personInfoPrincipal = new ThirdpCustomerCertifyInfo();
        personInfoPrincipal.setCertifyOrPersonFlag(certifyOrPersonFlag);
        String certifyOrPersonTypePrincipal = yqConfig.getPayee().getComFxqQyfrConfigJsonVo().getCertifyOrPersonTypePrincipal();
        personInfoPrincipal.setCertifyOrPersonType(certifyOrPersonTypePrincipal);
        personInfoPrincipal.setCertifyType(certifyType);
        personInfoPrincipal.setCertifName(certifName);
        personInfoPrincipal.setCertifyNo(certifyNo);
        personInfoPrincipal.setValidDate((Date)DateUtil.parse((CharSequence)personValidDate, (String)"yyyy-MM-dd"));
        ThirdpCustomerCertifyInfo personInfoBusiness = new ThirdpCustomerCertifyInfo();
        personInfoBusiness.setCertifyOrPersonFlag(certifyOrPersonFlag);
        String certifyOrPersonTypeBusiness = yqConfig.getPayee().getComFxqQyfrConfigJsonVo().getCertifyOrPersonTypeBusiness();
        personInfoBusiness.setCertifyOrPersonType(certifyOrPersonTypeBusiness);
        personInfoBusiness.setCertifyType(certifyType);
        personInfoBusiness.setCertifName(certifName);
        personInfoBusiness.setCertifyNo(certifyNo);
        personInfoBusiness.setValidDate((Date)DateUtil.parse((CharSequence)personValidDate, (String)"yyyy-MM-dd"));
        ThirdpCustomerCertifyInfo certifyInfo = new ThirdpCustomerCertifyInfo();
        certifyInfo.setCertifyOrPersonFlag(yqConfig.getPayee().getComFxqYyzzConfigJsonVo().getCertifyOrPersonFlag());
        certifyInfo.setCertifyOrPersonType(yqConfig.getPayee().getComFxqYyzzConfigJsonVo().getCertifyOrPersonType());
        certifyInfo.setCertifyType(yqConfig.getPayee().getComFxqYyzzConfigJsonVo().getCertifyType());
        certifyInfo.setCertifName(yqConfig.getPayee().getComFxqYyzzConfigJsonVo().getCertifName());
        certifyInfo.setCertifyNo(yqConfig.getPayee().getComFxqYyzzConfigJsonVo().getCertifyNo());
        String validDate = yqConfig.getPayee().getComFxqYyzzConfigJsonVo().getValidDate();
        certifyInfo.setValidDate((Date)DateUtil.parse((CharSequence)validDate, (String)"yyyy-MM-dd"));
        ccustomerCertifyInfo.add(personInfoLegal);
        ccustomerCertifyInfo.add(personInfoPrincipal);
        ccustomerCertifyInfo.add(personInfoBusiness);
        ccustomerCertifyInfo.add(certifyInfo);
        payeeAmlCom.setCcustomerCertifyInfo(ccustomerCertifyInfo);
        ArrayList<ThirdpCustomerBeneficiaryInfo> ccustomerBeneficiaryInfo = new ArrayList<ThirdpCustomerBeneficiaryInfo>();
        ThirdpCustomerBeneficiaryInfo beneficiaryInfo = new ThirdpCustomerBeneficiaryInfo();
        beneficiaryInfo.setBeneficiaryName(yqConfig.getPayee().getComFxqBeneficiaryConfigJsonVo().getBeneficiaryName());
        beneficiaryInfo.setBeneficiaryNationality(yqConfig.getPayee().getComFxqBeneficiaryConfigJsonVo().getBeneficiaryNationality());
        beneficiaryInfo.setBeneficiaryOccupation(yqConfig.getPayee().getComFxqBeneficiaryConfigJsonVo().getBeneficiaryOccupation());
        beneficiaryInfo.setBeneficiaryAddressType(yqConfig.getPayee().getComFxqBeneficiaryConfigJsonVo().getBeneficiaryAddressType());
        beneficiaryInfo.setBeneficiaryAddress(yqConfig.getPayee().getComFxqBeneficiaryConfigJsonVo().getBeneficiaryAddress());
        beneficiaryInfo.setBeneficiaryCertifyType(yqConfig.getPayee().getComFxqBeneficiaryConfigJsonVo().getBeneficiaryCertifyType());
        beneficiaryInfo.setBeneficiaryCertifyNo(yqConfig.getPayee().getComFxqBeneficiaryConfigJsonVo().getBeneficiaryCertifyNo());
        String beneficiaryCertifyValidDate = yqConfig.getPayee().getComFxqBeneficiaryConfigJsonVo().getBeneficiaryCertifyValidDate();
        beneficiaryInfo.setBeneficiaryCertifyValidDate((Date)DateUtil.parse((CharSequence)beneficiaryCertifyValidDate, (String)"yyyy-MM-dd"));
        beneficiaryInfo.setInsuredRelationCode(yqConfig.getPayee().getComFxqBeneficiaryConfigJsonVo().getInsuredRelationCode());
        beneficiaryInfo.setInsuredRelationName(yqConfig.getPayee().getComFxqBeneficiaryConfigJsonVo().getInsuredRelationName());
        beneficiaryInfo.setInsuredRelationDetail(yqConfig.getPayee().getComFxqBeneficiaryConfigJsonVo().getInsuredRelationDetail());
        beneficiaryInfo.setPayeeRelationCode(yqConfig.getPayee().getComFxqBeneficiaryConfigJsonVo().getPayeeRelationCode());
        beneficiaryInfo.setPayeeRelationName(yqConfig.getPayee().getComFxqBeneficiaryConfigJsonVo().getPayeeRelationName());
        ccustomerBeneficiaryInfo.add(beneficiaryInfo);
        payeeAmlCom.setCcustomerBeneficiaryInfo(ccustomerBeneficiaryInfo);
        return payeeAmlCom;
    }

    private ThirdpClaimRegistPayeeAml fillInsuredFxq(ApisBusiMxClaimRegist regist) {
        ThirdpClaimRegistPayeeAml payeeAml = new ThirdpClaimRegistPayeeAml();
        ThirdpClaimRegistConfigJsonVo config = null;
        if ("YKF".equals(regist.getProjectCode())) {
            config = this.getMxConfig();
            Map insured = this.apisBusiMxAddInsuredVoucherService.getInsuredInfo(regist.getContractNo(), regist.getMxPolicyNo(), regist.getOrderNo());
            log.warn("\u53cd\u6d17\u94b1-\u88ab\u4fdd\u4eba\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)insured));
            if (ObjectUtils.isNotEmpty((Object)insured)) {
                payeeAml.setInsuredName((String)insured.get("insured_name"));
                String sex = this.getSexElseDefault((String)insured.get("gender"), (String)insured.get("credential_no"));
                payeeAml.setInsuredSex(sex);
                String insuredCertifyType = this.getCodeValueElseDefault((String)insured.get("credential_type"), "mxClaimThirdpPayeeAmlCertifyType", "THIRDP_INSURED_FXQ_CERTIFY_TYPE");
                payeeAml.setInsuredCertifyType(insuredCertifyType);
                payeeAml.setInsuredCertifyNo((String)insured.get("credential_no"));
                payeeAml.setInsuredMobile(regist.getReportPhone());
            }
        } else if ("YQ".equals(regist.getProjectCode())) {
            config = this.getYqConfig();
            Map insured = this.apisBusiMxAddInsuredVoucherService.getInsuredInfoToYq(regist.getContractNo(), regist.getPolicyNo(), regist.getMxPolicyNo());
            log.warn("\u53cd\u6d17\u94b1-\u88ab\u4fdd\u4eba\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)insured));
            payeeAml.setInsuredName(regist.getInsuredName());
            String insuredCertifyType = this.getCodeValueElseDefault(regist.getInsuredIdType(), "mxClaimThirdpPayeeAmlCertifyType", "THIRDP_INSURED_FXQ_CERTIFY_TYPE");
            payeeAml.setInsuredCertifyType(insuredCertifyType);
            payeeAml.setInsuredCertifyNo(regist.getInsuredIdNo());
            payeeAml.setInsuredMobile(regist.getReportPhone());
            if (ObjectUtils.isNotEmpty((Object)insured)) {
                String sex = this.getSexElseDefault((String)insured.get("gender"), (String)insured.get("credential_no"));
                payeeAml.setInsuredSex(sex);
            }
        }
        payeeAml.setInsuredNationality(config.getPayee().getInsuredFxqConfigJsonVo().getInsuredNationality());
        payeeAml.setInsuredOccupation(config.getPayee().getInsuredFxqConfigJsonVo().getInsuredOccupation());
        payeeAml.setInsuredAddressType(config.getPayee().getInsuredFxqConfigJsonVo().getInsuredAddressType());
        payeeAml.setInsuredAddress(config.getPayee().getInsuredFxqConfigJsonVo().getInsuredAddress());
        String insuredCertifyValidDate = config.getPayee().getInsuredFxqConfigJsonVo().getInsuredCertifyValidDate();
        payeeAml.setInsuredCertifyValidDate((Date)DateUtil.parse((CharSequence)insuredCertifyValidDate, (String)"yyyy-MM-dd"));
        payeeAml.setInsuredRelationCode(config.getPayee().getInsuredFxqConfigJsonVo().getInsuredRelationCode());
        payeeAml.setInsuredRelationName(config.getPayee().getInsuredFxqConfigJsonVo().getInsuredRelationName());
        payeeAml.setInsuredRelationDetail(config.getPayee().getInsuredFxqConfigJsonVo().getInsuredRelationDetail());
        payeeAml.setPayeeRelationCode(config.getPayee().getInsuredFxqConfigJsonVo().getPayeeRelationCode());
        payeeAml.setPayeeRelationName(config.getPayee().getInsuredFxqConfigJsonVo().getPayeeRelationName());
        return payeeAml;
    }

    private ThirdpClaimRegistPayeeAml fillPayeeFxq(ApisBusiMxClaimRegist regist) {
        ThirdpClaimRegistPayeeAml payeeAml = new ThirdpClaimRegistPayeeAml();
        if ("01".equals(regist.getPayeeIdType())) {
            payeeAml.setInsuredSex(this.getSexByCardNo(regist.getPayeeIdNo()));
        } else {
            payeeAml.setInsuredSex("9");
        }
        ThirdpClaimRegistConfigJsonVo config = null;
        if ("YKF".equals(regist.getProjectCode())) {
            config = this.getMxConfig();
        } else if ("YQ".equals(regist.getProjectCode())) {
            config = this.getYqConfig();
        }
        payeeAml.setInsuredName(regist.getPayeeBankAccountName());
        payeeAml.setInsuredNationality(config.getPayee().getPayeeFxqConfigJsonVo().getInsuredNationality());
        payeeAml.setInsuredOccupation(config.getPayee().getPayeeFxqConfigJsonVo().getInsuredOccupation());
        payeeAml.setInsuredAddressType(config.getPayee().getPayeeFxqConfigJsonVo().getInsuredAddressType());
        payeeAml.setInsuredAddress(config.getPayee().getPayeeFxqConfigJsonVo().getInsuredAddress());
        String insuredMobile = regist.getPayeePhone();
        if (StringUtils.isBlank((CharSequence)insuredMobile)) {
            insuredMobile = regist.getReportPhone();
        }
        payeeAml.setInsuredMobile(insuredMobile);
        ApisChannelCode channelCode = this.apisChannelCodeService.getByChannelValue("mxClaimThirdpPayeeAmlCertifyType", regist.getPayeeIdType());
        payeeAml.setInsuredCertifyType(ObjectUtils.isNotEmpty((Object)channelCode) ? channelCode.getValue() : "");
        payeeAml.setInsuredCertifyNo(regist.getPayeeIdNo());
        String insuredCertifyValidDate = config.getPayee().getPayeeFxqConfigJsonVo().getInsuredCertifyValidDate();
        payeeAml.setInsuredCertifyValidDate((Date)DateUtil.parse((CharSequence)insuredCertifyValidDate, (String)"yyyy-MM-dd"));
        payeeAml.setInsuredRelationCode(config.getPayee().getPayeeFxqConfigJsonVo().getInsuredRelationCode());
        payeeAml.setInsuredRelationName(config.getPayee().getPayeeFxqConfigJsonVo().getInsuredRelationName());
        payeeAml.setInsuredRelationDetail(config.getPayee().getPayeeFxqConfigJsonVo().getInsuredRelationDetail());
        payeeAml.setPayeeRelationCode(config.getPayee().getPayeeFxqConfigJsonVo().getPayeeRelationCode());
        payeeAml.setPayeeRelationName(config.getPayee().getPayeeFxqConfigJsonVo().getPayeeRelationName());
        return payeeAml;
    }

    private String getSexElseDefault(String sexValue, String insuredIdNo) {
        if (StringUtils.isNotBlank((CharSequence)sexValue)) {
            ApisChannelCode genderCode = this.apisChannelCodeService.getByChannelValue("mxClaimThirdpPayeeAmlSex", sexValue);
            if (ObjectUtils.isNotEmpty((Object)genderCode)) {
                return genderCode.getValue();
            }
            return this.getSexByCardNo(insuredIdNo);
        }
        return this.getSexByCardNo(insuredIdNo);
    }

    private String getSexByCardNo(String cardNo) {
        int baseNum = 2;
        String sex = StringUtils.isNotBlank((CharSequence)cardNo) ? (Integer.parseInt(cardNo.substring(cardNo.length() - baseNum, cardNo.length() - 1)) % baseNum == 0 ? "2" : "1") : "9";
        return sex;
    }

    private String getCodeValueElseDefault(String channelValue, String code, String defaultConfigCode) {
        if (StringUtils.isNotBlank((CharSequence)channelValue)) {
            ApisChannelCode genderCode = this.apisChannelCodeService.getByChannelValue(code, channelValue);
            if (ObjectUtils.isNotEmpty((Object)genderCode)) {
                return genderCode.getValue();
            }
            return this.apisChannelConfigsService.getConfigValue(defaultConfigCode);
        }
        return this.apisChannelConfigsService.getConfigValue(defaultConfigCode);
    }

    private ThirdpClaimRegistClaimMain convertMain(ApisBusiMxClaimRegist regist) throws ApisBusinessException {
        if (ObjectUtils.isEmpty((Object)regist)) {
            throw new ApisBusinessException("\u4e0a\u4f20\u788e\u7ba1\u7406\u8d54\u62a5\u6848\u5bf9\u5e94\u7684\u7acb\u6848\u4fe1\u606f\u4e3a\u7a7a", ErrorBisCodeEnum.ERR_B00002.getKey());
        }
        ThirdpClaimRegistConfigJsonVo config = null;
        if ("YKF".equals(regist.getProjectCode())) {
            config = this.getMxConfig();
        } else if ("YQ".equals(regist.getProjectCode())) {
            config = this.getYqConfig();
        }
        ThirdpClaimRegistClaimMain main = new ThirdpClaimRegistClaimMain();
        main.setClaimApplyId(regist.getClaimApplyId());
        main.setRequestType(config.getRequestType());
        main.setChannelPolicyNo(regist.getMxPolicyNo());
        main.setProposalOrder(regist.getPk());
        main.setApplyClaimAmount(regist.getAppClaimAmount().movePointLeft(POINT));
        main.setClaimTime(Date.from(regist.getReportTime().atZone(ZoneId.systemDefault()).toInstant()));
        main.setRegistTime(Date.from(regist.getReportTime().atZone(ZoneId.systemDefault()).toInstant()));
        main.setRegistType(config.getRegistType());
        main.setDamageTime(Date.from(regist.getDamageTime().atZone(ZoneId.systemDefault()).toInstant()));
        main.setLossType(config.getLossType());
        main.setLossAmount(regist.getAppClaimAmount().movePointLeft(POINT));
        main.setCaseDescription(regist.getCaseDetils());
        main.setAuditStatus(config.getAuditStatus());
        main.setClaimAmount(regist.getAppClaimAmount().movePointLeft(POINT));
        main.setChannelClaimApplyTime(Date.from(regist.getReportTime().atZone(ZoneId.systemDefault()).toInstant()));
        main.setChannelClaimCreateTime(regist.getCreateTime());
        if ("YKF".equals(regist.getProjectCode())) {
            Map insuredNameAndPhone;
            main.setChannelOrder(regist.getOrderNo());
            main.setDamageAddress(regist.getAccidentAddress());
            String mxProductCode = this.apisBusiMxAddInsuredVoucherService.getMxProductCodeByOrderNo(regist.getOrderNo(), "YKF");
            main.setChannelCode(this.channelUserConfigUtil.getChannelCode(mxProductCode));
            LocalDateTime policyEffectiveTime = this.apisBusiMxAddInsuredVoucherService.getPolicyEffectiveTime(regist.getContractNo(), regist.getMxPolicyNo(), regist.getOrderNo());
            if (ObjectUtils.isNotEmpty((Object)policyEffectiveTime)) {
                main.setPolicyEffectiveTime(Date.from(policyEffectiveTime.atZone(ZoneId.systemDefault()).toInstant()));
            }
            main.setRegistName(ObjectUtils.isNotEmpty((Object)(insuredNameAndPhone = this.apisBusiMxAddInsuredVoucherService.getInsuredInfo(regist.getContractNo(), regist.getMxPolicyNo(), regist.getOrderNo()))) ? (String)insuredNameAndPhone.get("insured_name") : "");
            main.setRegistPhone(regist.getReportPhone());
            main.setRegistRemark(regist.getContext());
        } else if ("YQ".equals(regist.getProjectCode())) {
            main.setChannelOrder(regist.getMxPolicyNo());
            main.setDamageAddress(config.getDamageAddress());
            main.setChannelCode(this.channelUserConfigUtil.getYqChannelCode(regist.getContractNo()));
            LocalDateTime policyEffectiveTime = this.apisBusiMxAddInsuredVoucherService.getPolicyEffectiveTimeToYq(regist.getContractNo(), regist.getPolicyNo(), regist.getMxPolicyNo());
            if (ObjectUtils.isNotEmpty((Object)policyEffectiveTime)) {
                main.setPolicyEffectiveTime(Date.from(policyEffectiveTime.atZone(ZoneId.systemDefault()).toInstant()));
            }
            main.setRegistName(regist.getReportName());
            main.setRegistPhone(regist.getReportPhone());
            main.setRegistRemark(regist.getCaseDetils());
        }
        return main;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApisBusiAnalysisTaskLog pushThirdpClaimRegist(ThirdpClaimRequest thirdpClaimRequest, ApisBusiAnalysisTaskLog taskLog, String projectCode) {
        try {
            if (StringUtils.isBlank((CharSequence)this.thirdpClaimRegistUrl)) {
                if (ObjectUtil.isNotEmpty((Object)taskLog)) {
                    taskLog.setPushStatus("5");
                    taskLog.setErrMsg("\u672a\u914d\u7f6e\u788e\u7ba1\u7406\u8d54\u7acb\u6848\u63a8\u9001url");
                    this.apisBusiAnalysisTaskLogService.updateById((Object)taskLog);
                }
                ApisBusiAnalysisTaskLog apisBusiAnalysisTaskLog = taskLog;
                return apisBusiAnalysisTaskLog;
            }
            if (ObjectUtil.isEmpty((Object)taskLog)) {
                taskLog = new ApisBusiAnalysisTaskLog();
                if ("YKF".equals(projectCode)) {
                    taskLog.setPushType(ApisAutoTaskConstantsEnum.CLAIM_REGIST_TO_THIRDP.getValue());
                } else if ("YQ".equals(projectCode)) {
                    taskLog.setPushType(ApisAutoTaskConstantsEnum.CLAIM_REGIST_TO_THIRDP_YQ.getValue());
                }
                taskLog.setBusinessKey(thirdpClaimRequest.getBody().getClaimMain().getClaimApplyId());
                taskLog.setPushStep(Integer.valueOf(1));
            } else {
                taskLog.setPushStep(Integer.valueOf(taskLog.getPushStep() + 1));
            }
            taskLog.setPushStatus("2");
            taskLog.setLastPushTime(LocalDateTime.now());
            taskLog.setPushTargetUrl(this.thirdpClaimRegistUrl);
            taskLog.setPushContent(JSON.toJSONString((Object)thirdpClaimRequest));
            log.warn("\u788e\u7ba1\u7406\u8d54\u7acb\u6848\u63a8\u9001request\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)thirdpClaimRequest));
            ThirdpClaimResponse response = null;
            if ("YKF".equals(projectCode)) {
                response = (ThirdpClaimResponse)this.httpRequestService.convertAndSendForAgent(this.thirdpClaimRegistUrl, (Object)thirdpClaimRequest, ThirdpClaimResponse.class, ApisAutoTaskConstantsEnum.CLAIM_REGIST_TO_THIRDP.getValue());
            } else if ("YQ".equals(projectCode)) {
                response = (ThirdpClaimResponse)this.httpRequestService.convertAndSendForAgent(this.thirdpClaimRegistUrl, (Object)thirdpClaimRequest, ThirdpClaimResponse.class, ApisAutoTaskConstantsEnum.CLAIM_REGIST_TO_THIRDP_YQ.getValue());
            }
            log.warn("\u788e\u7ba1\u7406\u8d54\u7acb\u6848\u63a8\u9001response\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString(response));
            if (ObjectUtils.isEmpty((Object)response) || ObjectUtils.isEmpty((Object)response.getHead()) || ObjectUtils.isEmpty((Object)response.getHead().getStatus())) {
                taskLog.setPushStatus("4");
                taskLog.setErrMsg("\u788e\u7ba1\u7406\u8d54\u7acb\u6848\u63a8\u9001\u672a\u8fd4\u56de\u5185\u5bb9");
            } else {
                if (AnalysisConstants.THIRDP_CLAIM_RESPONSE_STATUS.SUCCESS.equals(response.getHead().getStatus())) {
                    taskLog.setPushStatus("1");
                } else if (AnalysisConstants.THIRDP_CLAIM_RESPONSE_ERR_TYPE.REJECT.equals(response.getHead().getErrType())) {
                    taskLog.setPushStatus("1");
                    this.pushEndCaaseToMx(thirdpClaimRequest);
                } else {
                    taskLog.setPushStatus("4");
                }
                taskLog.setErrMsg(JSON.toJSONString((Object)response));
            }
        }
        catch (Exception e) {
            log.error("\u788e\u7ba1\u7406\u8d54\u7acb\u6848\u63a8\u9001\u5931\u8d25 error:", (Throwable)e);
            taskLog.setPushStatus("4");
            if (StringUtils.isNotBlank((CharSequence)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT) {
                taskLog.setErrMsg(e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT));
            } else {
                taskLog.setErrMsg(e.getMessage());
            }
        }
        finally {
            if (ObjectUtils.isEmpty((Object)taskLog.getId())) {
                this.apisBusiAnalysisTaskLogService.saveTaskInfo(taskLog);
            } else {
                this.apisBusiAnalysisTaskLogService.updateById((Object)taskLog);
            }
        }
        return taskLog;
    }

    public void pushThirdpClaimRegistTask(ApisBusiAnalysisTaskLog taskLog) {
        if (ObjectUtil.isEmpty((Object)taskLog)) {
            log.error("\u63a8\u9001\u4efb\u52a1\u4e3a\u7a7a");
            return;
        }
        if ("0".equals(taskLog.getPushStatus())) {
            if (StringUtils.isBlank((CharSequence)taskLog.getBusinessKey())) {
                log.error("\u63a8\u9001\u4e1a\u52a1\u952ebusinessKey\u4e3a\u7a7a");
                return;
            }
            ApisBusiMxClaimRegist regist = this.apisBusiMxClaimRegistService.getByClaimApplyId(taskLog.getBusinessKey());
            List mediaList = this.apisBusiMxClaimMediaService.getByMxReportNo(regist.getMxReportNo());
            if ("YKF".equals(regist.getProjectCode())) {
                this.convertYkfAndPush(regist, mediaList, taskLog);
            } else if ("YQ".equals(regist.getProjectCode())) {
                this.convertYqAndPush(regist, taskLog);
            }
        } else {
            ThirdpClaimRequest thirdpClaimRequest;
            if (ObjectUtil.isEmpty((Object)taskLog.getPushContent())) {
                log.error("\u4efb\u52a1businessKey={}, \u6ca1\u6709\u8981\u63a8\u9001\u7684\u8bf7\u6c42\u4fe1\u606f", (Object)taskLog.getBusinessKey());
                return;
            }
            try {
                thirdpClaimRequest = (ThirdpClaimRequest)JSON.parseObject((String)taskLog.getPushContent(), ThirdpClaimRequest.class);
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u65e5\u5fd7\u63a8\u9001\u5185\u5bb9\u5e8f\u5217\u5316\u5931\u8d25,", (Throwable)e);
                return;
            }
            if ("3".equals(taskLog.getRemark())) {
                this.pushEndCaaseToMx(thirdpClaimRequest);
                taskLog.setPushStatus("4");
                this.apisBusiAnalysisTaskLogService.updateById((Object)taskLog);
            } else {
                ApisBusiMxClaimRegist regist = this.apisBusiMxClaimRegistService.getByClaimApplyId(taskLog.getBusinessKey());
                ApisBusiAnalysisTaskLog apisBusiAnalysisTaskLog = this.pushThirdpClaimRegist(thirdpClaimRequest, taskLog, regist.getProjectCode());
            }
        }
    }

    public void pushEndCaaseToMx(ThirdpClaimRequest thirdpClaimRequest) {
        String claimApplyId = thirdpClaimRequest.getBody().getClaimMain().getClaimApplyId();
        ApisBusiMxClaimRegist regist = this.apisBusiMxClaimRegistService.getByClaimApplyId(claimApplyId);
        if ("YKF".equals(regist.getProjectCode())) {
            MxYkfClaimEndCaseRequest endCaseRequest = new MxYkfClaimEndCaseRequest();
            endCaseRequest.setContractNo(regist.getContractNo());
            endCaseRequest.setPaymentAmount(Integer.valueOf(0));
            ArrayList<MxYkfClaimEndCaseClaim> claimList = new ArrayList<MxYkfClaimEndCaseClaim>();
            MxYkfClaimEndCaseClaim claim = (MxYkfClaimEndCaseClaim)BeanUtil.copyProperties((Object)regist, MxYkfClaimEndCaseClaim.class, (String[])new String[0]);
            claim.setClaimType(AnalysisConstants.MX_YKF_CLAIM_TYPE.REJECT);
            claimList.add(claim);
            endCaseRequest.setClaimList(claimList);
            this.mxClaimEndCasePushService.pushYkfClaimEndCase(endCaseRequest, regist.getClaimApplyId(), null);
        } else if ("YQ".equals(regist.getProjectCode())) {
            MxYqClaimEndCaseRequest endCaseRequest = (MxYqClaimEndCaseRequest)BeanUtil.copyProperties((Object)regist, MxYqClaimEndCaseRequest.class, (String[])new String[0]);
            endCaseRequest.setReportNo(regist.getRegistNo());
            endCaseRequest.setClaimStatus(AnalysisConstants.MX_YQ_CLAIM_STATUS.REJECT);
            endCaseRequest.setPaymentInfo(new MxYqClaimEndCasePaymentInfo());
            endCaseRequest.setProjectCode(this.channelUserConfigUtil.getClaimProjectCodeByContractNo(regist.getContractNo(), regist.getPolicyNo(), regist.getMxPolicyNo()));
            endCaseRequest.setContractNo(regist.getContractNo());
            this.mxClaimEndCasePushService.pushYqClaimEndCase(endCaseRequest, regist.getClaimApplyId(), regist, null);
        }
    }

    public Boolean compensateThirdpClaimRegistTask() {
        List registList = this.apisBusiMxClaimRegistService.listDiffNotPushTrirdp();
        if (ObjectUtils.isEmpty((Object)registList)) {
            log.warn("\u6ca1\u6709\u7acb\u6848\u4fdd\u5b58\u6210\u529f\u4f46\u662f\u6ca1\u6709\u63a8\u9001\u788e\u7ba1\u7684\u6570\u636e");
            return true;
        }
        ArrayList<ApisBusiAnalysisTaskLog> taskLogs = new ArrayList<ApisBusiAnalysisTaskLog>();
        for (ApisBusiMxClaimRegist regist : registList) {
            ApisBusiAnalysisTaskLog taskLog = new ApisBusiAnalysisTaskLog();
            taskLog.setPushType(ApisAutoTaskConstantsEnum.CLAIM_REGIST_TO_THIRDP.getValue());
            taskLog.setBusinessKey(regist.getClaimApplyId());
            taskLog.setPushStatus("0");
            taskLog.setPushStep(Integer.valueOf(0));
            taskLogs.add(taskLog);
        }
        return this.apisBusiAnalysisTaskLogService.saveBatch(taskLogs);
    }

    private ThirdpClaimRegistConfigJsonVo getMxConfig() {
        if (ObjectUtils.isEmpty((Object)MX_CONFIG)) {
            String configJson = this.apisChannelConfigsService.getConfigValue("MX_CONFIG_JSON");
            MX_CONFIG = (ThirdpClaimRegistConfigJsonVo)JSON.parseObject((String)configJson, ThirdpClaimRegistConfigJsonVo.class);
        }
        return MX_CONFIG;
    }

    private ThirdpClaimRegistConfigJsonVo getYqConfig() {
        if (ObjectUtils.isEmpty((Object)YQ_CONFIG)) {
            String configJson = this.apisChannelConfigsService.getConfigValue("YQ_CONFIG_JSON");
            YQ_CONFIG = (ThirdpClaimRegistConfigJsonVo)JSON.parseObject((String)configJson, ThirdpClaimRegistConfigJsonVo.class);
        }
        return YQ_CONFIG;
    }
}

