/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.xxljob.executor.common.service;

import cn.hutool.core.lang.UUID;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.request.ClaimMediaCommitResult;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.request.ImgNode;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUploadAttachment;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUploadAttachmentService;
import com.jdaz.sinosoftgz.apis.commons.utils.OkHttpUtils;
import com.jdaz.sinosoftgz.apis.xxljob.executor.common.utils.ClaimMediaUploadUtil;
import com.sinosoft.image.client.dto.ImgBatchUploadMetaDTO;
import com.sinosoft.image.client.dto.ImgBatchUploadRequestDTO;
import com.sinosoft.image.client.dto.ImgBusiDTO;
import com.sinosoft.image.client.dto.RequestHeadDTO;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class YlClaimAttachmentUploadService {
    private static final Logger log = LoggerFactory.getLogger(YlClaimAttachmentUploadService.class);
    @Autowired
    ApisBusiUploadAttachmentService apisBusiUploadAttachmentService;
    @Autowired
    ClaimMediaUploadUtil claimMediaUploadUtil;
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;

    public void upLoadClaimAttachment(ApisBusiTaskLog taskLog) {
        List attachments = this.apisBusiUploadAttachmentService.listByClaimBusinessNo(taskLog.getBusinessKey());
        if (this.uploadToMedia(attachments).booleanValue()) {
            taskLog.setPushStatus("1");
        } else {
            taskLog.setPushStatus("4");
        }
        taskLog.setPushStep(Integer.valueOf(taskLog.getPushStep() + 1));
        taskLog.setLastPushTime(LocalDateTime.now());
        taskLog.setPushContent(JSON.toJSONString((Object)attachments));
        this.apisBusiTaskLogService.updateById((Object)taskLog);
    }

    private Boolean uploadToMedia(List<ApisBusiUploadAttachment> attachments) {
        boolean success = true;
        if (ObjectUtils.isNotEmpty(attachments)) {
            for (ApisBusiUploadAttachment attachment : attachments) {
                try {
                    log.warn("\u836f\u8054\u4e0a\u4f20\u5f71\u50cf\u7cfb\u7edf\u5f00\u59cb:{}", (Object)attachment);
                    ImgBatchUploadRequestDTO imgBatchUploadRequestDTO = new ImgBatchUploadRequestDTO();
                    RequestHeadDTO requestHeadDTO = new RequestHeadDTO();
                    requestHeadDTO.setSeqNo(UUID.randomUUID().toString().replace("-", ""));
                    requestHeadDTO.setRequestTime(new Date());
                    requestHeadDTO.setOptComCode("apis");
                    requestHeadDTO.setOptUserCode(attachment.getCreator());
                    requestHeadDTO.setOptUserName("apis");
                    imgBatchUploadRequestDTO.setHeadDto(requestHeadDTO);
                    ImgBusiDTO imgBusiDTO = new ImgBusiDTO();
                    imgBusiDTO.setAppCode("CL");
                    imgBusiDTO.setClassCode("CLA");
                    imgBusiDTO.setBusinessNo(attachment.getBusinessNo());
                    imgBusiDTO.setBusiComCode("apis");
                    imgBatchUploadRequestDTO.setBusiDto(imgBusiDTO);
                    String fileName = attachment.getAttaName().contains(".") ? attachment.getAttaName() : attachment.getAttaName() + this.suffixOfUrl(attachment.getAttaThirdPath());
                    String base64Str = OkHttpUtils.getBase64EncodeByUrl((String)attachment.getAttaThirdPath());
                    log.warn("\u9541\u4fe1\u7406\u8d54\u4e0b\u8f7d\u6587\u4ef6\uff0c\u6587\u4ef6\u7f16\u53f7: {}-{}", (Object)attachment.getBusinessNo(), (Object)fileName);
                    if (StringUtils.isEmpty((CharSequence)base64Str)) {
                        log.error("\u9541\u4fe1\u7406\u8d54\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25,\u6587\u4ef6\u7f16\u53f7:  {}-{}", (Object)attachment.getBusinessNo(), (Object)fileName);
                        log.error("\u9541\u4fe1\u7406\u8d54\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25,url: {}", (Object)attachment.getAttaThirdPath());
                        continue;
                    }
                    ImgBatchUploadMetaDTO imgBatchUploadMetaDTO = new ImgBatchUploadMetaDTO();
                    imgBatchUploadMetaDTO.setBase64FileContent(base64Str);
                    imgBatchUploadMetaDTO.setFileURL(attachment.getAttaThirdPath());
                    imgBatchUploadMetaDTO.setCovered(false);
                    imgBatchUploadMetaDTO.setFileOrgName(fileName);
                    imgBatchUploadMetaDTO.setImgType("|999|");
                    imgBatchUploadMetaDTO.setImgTypeName("|\u5176\u4ed6|");
                    ArrayList<ImgBatchUploadMetaDTO> uploadMetaDTOList = new ArrayList<ImgBatchUploadMetaDTO>();
                    uploadMetaDTOList.add(imgBatchUploadMetaDTO);
                    imgBatchUploadRequestDTO.setUploadMetas(uploadMetaDTOList);
                    ClaimMediaCommitResult claimMediaCommitResult = this.claimMediaUploadUtil.imgBatchUpload(imgBatchUploadRequestDTO);
                    if (!ObjectUtils.isNotEmpty((Object)claimMediaCommitResult.getImgNodes())) continue;
                    attachment.setAttaName(fileName);
                    attachment.setAttaImgPath(((ImgNode)claimMediaCommitResult.getImgNodes().get(0)).getImgUrl());
                    attachment.setRemark(((ImgNode)claimMediaCommitResult.getImgNodes().get(0)).getImgId());
                    attachment.setStatus("3");
                }
                catch (ApisBusinessException e) {
                    log.error("\u836f\u8054-\u7406\u8d54\u62a5\u6848\u53f7\u3010{}\u3011\u4e0a\u4f20\u3010{}\u3011\u8d44\u6599\u5931\u8d25:", new Object[]{attachment.getBusinessNo(), attachment.getAttaName(), e});
                    attachment.setStatus("4");
                    success = false;
                }
            }
            this.apisBusiUploadAttachmentService.updateBatchById(attachments);
        }
        return success;
    }

    private String suffixOfUrl(String url) {
        String point = ".";
        String question = "?";
        if (!url.contains(".")) {
            return null;
        }
        String suffix = url;
        if (url.contains("?")) {
            suffix = url.substring(0, url.lastIndexOf("?"));
        }
        return suffix.substring(url.lastIndexOf("."));
    }
}

