/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.xxljob.executor.common.service;

import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.request.ClaimMediaCommitResult;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgBatchUploadRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgBatchUploadServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgMetaDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUploadAttachment;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUploadAttachmentService;
import com.jdaz.sinosoftgz.apis.commons.model.constant.ModelConstants;
import com.jdaz.sinosoftgz.apis.commons.utils.OkHttpUtils;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.apis.xxljob.executor.common.utils.InsureMediaUploadUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class YlInsureAttachmentUploadService {
    private static final Logger log = LoggerFactory.getLogger(YlInsureAttachmentUploadService.class);
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    ApisBusiUploadAttachmentService apisBusiUploadAttachmentService;
    @Autowired
    InsureMediaUploadUtil insureMediaUploadUtil;
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;

    public void uploadAttachments(ApisBusiTaskLog taskLog) {
        String orderNo = "";
        ArrayList<ImgMetaDTO> imageList = new ArrayList<ImgMetaDTO>();
        List attachmentList = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"proposal_no", (Object)taskLog.getBusinessKey());
        ApisBusiChannelOrder order = (ApisBusiChannelOrder)this.apisBusiChannelOrderService.getOne((Wrapper)queryWrapper, false);
        if (ObjectUtil.isEmpty((Object)order)) {
            log.error("\u836f\u8054\u8865\u507f\u4e0a\u4f20\u5f71\u50cf\u6587\u4ef6\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8ba2\u5355\u8bb0\u5f55\uff0c\u6295\u4fdd\u5355\u53f7\uff1a{}", (Object)taskLog.getBusinessKey());
            return;
        }
        orderNo = order.getOrderNo();
        attachmentList = this.apisBusiUploadAttachmentService.getByBusinessNo(taskLog.getBusinessKey(), "I");
        if (ObjectUtil.isNotEmpty(attachmentList)) {
            for (ApisBusiUploadAttachment attachment : attachmentList) {
                ImgMetaDTO imgMetaDto = ImgMetaDTO.builder().build();
                imgMetaDto.setFileUrl(attachment.getAttaThirdPath());
                imgMetaDto.setFileOrgName(attachment.getAttaName());
                imageList.add(imgMetaDto);
            }
        } else {
            log.error("\u836f\u8054\u8865\u507f\u4e0a\u4f20\u5f71\u50cf\u6587\u4ef6\uff0c\u6587\u4ef6\u4e0a\u4f20\u8868\u6ca1\u6709\u627e\u5230\u8bb0\u5f55\uff0c\u4e1a\u52a1\u53f7\uff1a{}", (Object)taskLog.getBusinessKey());
            return;
        }
        ImgBatchUploadRequestDTO imgBatchUploadRequestDto = ImgBatchUploadRequestDTO.builder().linkNo(taskLog.getBusinessKey()).orderNo(orderNo).imgList(imageList).build();
        ImgBatchUploadServiceRequest imgBatchUploadServiceRequest = ImgBatchUploadServiceRequest.builder().requestBody(imgBatchUploadRequestDto).requestHead(RequestHeadDTO.initRequestHead()).build();
        StanderRequest request = StanderRequest.builder().imgBatchUploadServiceRequest(imgBatchUploadServiceRequest).build();
        this.doUploadAttachments(request, taskLog, attachmentList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUploadAttachments(StanderRequest request, ApisBusiTaskLog taskLog, List<ApisBusiUploadAttachment> attachmentList) {
        log.warn("\u5f02\u6b65\u4e0a\u4f20\u836f\u8054\u6295\u4fdd\u8d44\u6599");
        String flag = "3";
        try {
            ImgBatchUploadServiceRequest imgBatchUploadServiceRequest = request.getImgBatchUploadServiceRequest();
            if (ObjectUtil.isEmpty((Object)imgBatchUploadServiceRequest.getRequestBody()) || ObjectUtil.isEmpty((Object)imgBatchUploadServiceRequest.getRequestBody().getLinkNo()) || ObjectUtil.isEmpty((Object)imgBatchUploadServiceRequest.getRequestBody().getOrderNo())) {
                log.error("\u5f02\u6b65\u4e0a\u4f20\u836f\u8054\u6295\u4fdd\u8d44\u6599\u5f02\u5e38-\u300b\u53c2\u6570\u5f02\u5e38");
                throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N50001.getValue(), ErrorNullValueCodeEnum.ERR_N50001.getKey());
            }
            ImgMetaDTO imgMetaDto = (ImgMetaDTO)imgBatchUploadServiceRequest.getRequestBody().getImgList().get(0);
            String base64Str = OkHttpUtils.getBase64EncodeByUrl((String)imgMetaDto.getFileUrl());
            if (StringUtils.isEmpty((CharSequence)base64Str)) {
                log.error("\u4e0b\u8f7d\u836f\u8054\u6295\u4fdd\u8d44\u6599\u5931\u8d25,url:" + imgMetaDto.getFileUrl());
                flag = "4";
            } else {
                imgMetaDto.setFileContentWithBase64Encode(base64Str);
                imgMetaDto.setFileOrgName(UUID.randomUUID().toString() + System.currentTimeMillis() + ".csv");
                ClaimMediaCommitResult response = this.insureMediaUploadUtil.imgBatchUpload(request);
                if (ObjectUtil.isNotEmpty((Object)response) && ModelConstants.INT_VALUE_NO.intValue() == response.getHeadDto().getStatus()) {
                    taskLog.setPushStatus("1");
                } else {
                    taskLog.setPushStatus("4");
                    flag = "4";
                }
                taskLog.setErrMsg(JSON.toJSONString((Object)response));
                taskLog.setLastPushTime(LocalDateTime.now());
            }
        }
        catch (Exception e) {
            flag = "4";
            log.error("\u4e0b\u8f7d\u836f\u8054\u6295\u4fdd\u8d44\u6599\u5931\u8d25: ", (Throwable)e);
        }
        finally {
            String finalFlag = flag;
            attachmentList.forEach(t -> t.setStatus(finalFlag));
            this.apisBusiUploadAttachmentService.saveOrUpdateBatch(attachmentList);
            this.apisBusiTaskLogService.saveOrUpdate((Object)taskLog);
        }
    }
}

