/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.xxljob.executor.common.utils;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.BusinessConstants;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.request.ZhizhenReqHead;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.request.ZhizhenRequest;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.response.MeiXinResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.response.ZhizhenResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.utils.DesUtils;
import com.jdaz.sinosoftgz.apis.business.app.starter.utils.JDAZAesUtils;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiAnalysisTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiAnalysisTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxSubInsuredVoucherService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxSubSuminsuredOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.MxCallbackPolicyStatusRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.ThirdpAgencyInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.ThirdpHead;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.ThirdpRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.UploadRiskData;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.resp.ThirdpResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.resp.UploadRiskResData;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.StanderPacket;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiEmailSendLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUwSupport;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiWarnRule;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiEmailSendLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiWarnRuleService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelCode;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelUser;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelCodeService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelUserService;
import com.jdaz.sinosoftgz.apis.commons.model.constant.ModelConstants;
import com.jdaz.sinosoftgz.apis.commons.service.constants.CommonConstant;
import com.jdaz.sinosoftgz.apis.constants.AnalysisErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.apis.xxljob.executor.common.utils.AesUtils;
import com.jdaz.sinosoftgz.apis.xxljob.executor.common.utils.CommonTaskUtil;
import com.jdaz.sinosoftgz.apis.xxljob.executor.common.utils.MailUtil;
import com.jdaz.sinosoftgz.apis.xxljob.executor.common.utils.MxHttpPushUtil;
import com.jdaz.sinosoftgz.coreapi.common.service.HttpRequestService;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class CommonTaskUtil {
    private static final Logger log = LoggerFactory.getLogger(CommonTaskUtil.class);
    @Autowired
    ApisBusiWarnRuleService apisBusiWarnRuleService;
    @Autowired
    ApisChannelCodeService apisChannelCodeService;
    @Autowired
    ApisBusiEmailSendLogService emailSendLogService;
    @Autowired
    MailUtil mailUtil;
    @Autowired
    StringRedisTemplate redisTemplate;
    @Autowired
    private ApisBusiAnalysisTaskLogService apisBusiAnalysisTaskLogService;
    @Autowired
    private ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    private ApisBusiMxSubInsuredVoucherService apisBusiMxSubInsuredVoucherService;
    private ApisBusiMxSubSuminsuredOrderService apisBusiMxSubSuminsuredOrderService;
    @Autowired
    HttpRequestService httpRequestService;
    @Autowired
    private MxHttpPushUtil mxHttpPushUtil;
    @Autowired
    ApisChannelUserService apisChannelUserService;
    @Value(value="${coreapi.thirdp.aesKey}")
    private String aesKey;
    private static final String EMAIL_REPLACE = "###";
    private static final String EMAIL_HTML_TABLE_TR_TD = "<tr><td>";
    private static final String EMAIL_HTML_TABLE_TD_TD = "</td><td>";
    private static final String EMAIL_HTML_TABLE_TD_TR = "</td></tr>";
    public static final MediaType JSON_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    static OkHttpClient client = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).build();
    private static final Predicate<ApisBusiAnalysisTaskLog> PUSH_TARGET_URL_NOT_BLANK_PREDICATE = taskLog -> ObjectUtil.isNotEmpty((Object)taskLog) && StrUtil.isNotBlank((CharSequence)taskLog.getPushTargetUrl());
    private static final Predicate<ApisBusiAnalysisTaskLog> PUSH_CONTENT_NOT_BLANK_PREDICATE = taskLog -> ObjectUtil.isNotEmpty((Object)taskLog) && StrUtil.isNotBlank((CharSequence)taskLog.getPushContent());

    public boolean lock(String key) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)key, 10L, TimeUnit.MINUTES);
    }

    public void deleteByKey(String key) {
        this.redisTemplate.delete((Object)key);
    }

    public void doTaskLogFailEmail(List<ApisBusiTaskLog> apisBusiTaskLogs) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"rule_code", (Object)"taskLogFailEmail");
        ApisBusiWarnRule rules = (ApisBusiWarnRule)this.apisBusiWarnRuleService.getOne((Wrapper)queryWrapper);
        StringBuilder content = new StringBuilder();
        HashMap<String, String> map = new HashMap<String, String>(16);
        ApisChannelCode apisChannelCode = new ApisChannelCode();
        apisChannelCode.setCode("TaskType");
        apisChannelCode.setDeleted(Integer.valueOf(0));
        apisChannelCode.setValidFlag(Boolean.valueOf(true));
        QueryWrapper queryWrapperConfig = new QueryWrapper((Object)apisChannelCode);
        List list = this.apisChannelCodeService.list((Wrapper)queryWrapperConfig);
        if (ObjectUtil.isNotEmpty((Object)list)) {
            for (ApisChannelCode code : list) {
                map.put(code.getValue(), code.getValueDesc());
            }
        }
        apisBusiTaskLogs.forEach(apisBusiTaskLog -> {
            content.append(EMAIL_HTML_TABLE_TR_TD);
            content.append(StringUtils.isNotBlank((CharSequence)((CharSequence)map.get(apisBusiTaskLog.getPushType()))) ? (String)map.get(apisBusiTaskLog.getPushType()) : apisBusiTaskLog.getPushType());
            content.append(EMAIL_HTML_TABLE_TD_TD);
            content.append(apisBusiTaskLog.getPushStep());
            content.append(EMAIL_HTML_TABLE_TD_TR);
        });
        String contentText = rules.getEmailContentTpl().replaceAll(EMAIL_REPLACE, content.toString());
        ApisBusiEmailSendLog sendLog = new ApisBusiEmailSendLog(rules.getEmailSubjectTpl(), contentText, rules.getEmailToList(), rules.getEmailCcList());
        sendLog.setSendStatus("1");
        sendLog.setSendStep(BusinessConstants.DAY_ADD_NUM);
        this.emailSendLogService.save((Object)sendLog);
        log.warn("\u544a\u8b66\u53d1\u9001\u90ae\u4ef6\uff0c{}", (Object)JSON.toJSONString((Object)sendLog));
        this.mailUtil.sendEmailHtml(rules.getEmailSubjectTpl(), contentText, rules.getEmailToList(), rules.getEmailCcList());
        log.warn("\u63a8\u9001\u4efb\u52a1\u8865\u507f\u540e\u4ecd\u5931\u8d25\u7684\u90ae\u4ef6\u544a\u8b66\u4efb\u52a1\u7ed3\u675f");
    }

    public void uploadMxOrderDataToInsureRisk(ApisBusiAnalysisTaskLog busiAnalysisTaskLog) {
        this.uploadMxOrderDataToInsureRiskCore(busiAnalysisTaskLog, null);
    }

    public void uploadMxOrderDataToInsureRiskCore(ApisBusiAnalysisTaskLog busiAnalysisTaskLog, BiConsumer<UploadRiskData, ApisBusiAnalysisTaskLog> successConsumer) {
        this.commonDoTask(busiAnalysisTaskLog, PUSH_TARGET_URL_NOT_BLANK_PREDICATE.and(PUSH_CONTENT_NOT_BLANK_PREDICATE), taskLog -> {
            ThirdpRequest thirdpRequest = (ThirdpRequest)JSON.parseObject((String)taskLog.getPushContent(), ThirdpRequest.class);
            UploadRiskData uploadRiskData = null;
            if (ObjectUtil.isNotEmpty((Object)thirdpRequest.getData())) {
                uploadRiskData = (UploadRiskData)JSON.parseObject((String)thirdpRequest.getData().toString(), UploadRiskData.class);
            }
            ThirdpResponse response = this.convertAndSend(taskLog.getPushTargetUrl(), thirdpRequest.getAgency(), (Object)uploadRiskData, thirdpRequest.getHead().getServiceName(), UploadRiskResData.class);
            boolean result = true;
            if (ObjectUtils.isEmpty((Object)response) || ObjectUtils.isEmpty((Object)response.getData())) {
                taskLog.setPushStatus("4");
                taskLog.setErrMsg("\u9541\u4fe1-\u521b\u5efa\u56e2\u5355\u2014\u4e0a\u4f20\u788e\u7ba1\u672a\u8fd4\u56de\u5185\u5bb9");
                result = false;
            } else {
                if ("0000".equals(((UploadRiskResData)response.getData()).getErrorCode())) {
                    taskLog.setPushStatus("1");
                } else {
                    taskLog.setPushStatus("4");
                    result = false;
                }
                taskLog.setErrMsg(JSON.toJSONString((Object)response));
                if (null != successConsumer) {
                    successConsumer.accept(uploadRiskData, taskLog);
                }
            }
            return result;
        });
    }

    public void commonDoTask(ApisBusiAnalysisTaskLog busiTaskLog, Predicate<ApisBusiAnalysisTaskLog> predicate, TaskBusinessFunction taskBusinessFunction) {
        if (ObjectUtil.isEmpty((Object)busiTaskLog)) {
            return;
        }
        boolean isValid = true;
        if (ObjectUtil.isNotEmpty(predicate)) {
            isValid = predicate.test(busiTaskLog);
        }
        if (!isValid) {
            busiTaskLog.setPushStatus("5");
            this.apisBusiAnalysisTaskLogService.updateById((Object)busiTaskLog);
            return;
        }
        boolean isUpdSuccess = false;
        try {
            busiTaskLog.setPushStatus("2");
            busiTaskLog.setPushStep(Integer.valueOf(busiTaskLog.getPushStep() + 1));
            busiTaskLog.setLastPushTime(LocalDateTime.now());
            isUpdSuccess = this.apisBusiAnalysisTaskLogService.updateById((Object)busiTaskLog);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0taskLog\u4efb\u52a1\u72b6\u6001\u51fa\u9519\uff1a", (Throwable)e);
        }
        if (isUpdSuccess) {
            try {
                boolean isSuccess = taskBusinessFunction.doTask(busiTaskLog);
                if (isSuccess) {
                    busiTaskLog.setPushStatus("1");
                } else {
                    busiTaskLog.setPushStatus("4");
                }
            }
            catch (Exception e) {
                log.error("\u4efb\u52a1\u7c7b\u578b={}\uff0c\u4efb\u52a1businessKey={}\u6267\u884c\u51fa\u9519:", new Object[]{busiTaskLog.getPushType(), busiTaskLog.getBusinessKey(), e});
                busiTaskLog.setPushStatus("4");
                busiTaskLog.setErrMsg(ObjectUtil.isNotEmpty((Object)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT ? e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT) : e.getMessage());
            }
            this.apisBusiAnalysisTaskLogService.updateById((Object)busiTaskLog);
        }
    }

    public <T> ThirdpResponse<T> convertAndSend(String pushUrl, ThirdpAgencyInfo agencyInfo, Object requestData, String serviceName, Class<T> clazz) throws Exception {
        ThirdpHead head = ThirdpHead.builder().serviceName(serviceName).sendTimestamp(Long.valueOf(System.currentTimeMillis())).uuid(UUID.fastUUID().toString().replaceAll("-", "")).uploadId("upload" + UUID.fastUUID().toString().replaceAll("-", "")).build();
        String sourceBody = JSON.toJSONString((Object)ThirdpRequest.builder().head(head).agency(agencyInfo).data(requestData).build());
        log.warn("\u52a0\u5bc6\u524d\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)sourceBody);
        String encodeBody = this.aesEncryptBody(sourceBody);
        String responseStr = this.httpRequestService.convertAndSendForThirdp(pushUrl, encodeBody, ThirdpResponse.class, serviceName);
        ThirdpResponse response = null;
        if (ObjectUtil.isNotEmpty((Object)responseStr)) {
            responseStr = this.aesDecryptBody(responseStr);
            log.warn("\u89e3\u5bc6\u540e\u8fd4\u56de\u62a5\u6587\uff1a{}", (Object)responseStr);
            ThirdpResponse resp = (ThirdpResponse)JSON.parseObject((String)responseStr, ThirdpResponse.class);
            response = new ThirdpResponse();
            response.setHead(resp.getHead());
            if (ObjectUtil.isNotEmpty((Object)resp.getData())) {
                Object uploadRiskResData = JSON.parseObject((String)resp.getData().toString(), clazz);
                response.setData(uploadRiskResData);
            }
        }
        return response;
    }

    public String aesEncryptBody(String body) {
        if (ObjectUtil.isNotEmpty((Object)this.aesKey)) {
            String encryptStr;
            try {
                encryptStr = AesUtils.encrypt((String)body, (String)this.aesKey);
            }
            catch (Exception e) {
                log.error("\u788e\u7ba1\u52a0\u5bc6\u5f02\u5e38\uff1a", (Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
            return encryptStr;
        }
        return body;
    }

    public String aesDecryptBody(String body) {
        if (ObjectUtil.isNotEmpty((Object)this.aesKey)) {
            String encryptStr;
            try {
                encryptStr = AesUtils.decrypt((String)body, (String)this.aesKey);
            }
            catch (Exception e) {
                log.error("\u788e\u7ba1\u89e3\u5bc6\u5f02\u5e38\uff1a", (Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
            return encryptStr;
        }
        return body;
    }

    public void mxStatusChgcallback(ApisBusiAnalysisTaskLog busiAnalysisTaskLog) {
        this.commonDoTask(busiAnalysisTaskLog, PUSH_TARGET_URL_NOT_BLANK_PREDICATE.and(PUSH_CONTENT_NOT_BLANK_PREDICATE), taskLog -> {
            MxCallbackPolicyStatusRequest request = (MxCallbackPolicyStatusRequest)JSON.parseObject((String)taskLog.getPushContent(), MxCallbackPolicyStatusRequest.class);
            MeiXinResponse response = this.mxHttpPushUtil.convertAndSendYkf(taskLog.getPushTargetUrl(), (Object)request, ApisAutoTaskConstantsEnum.MX_SUB_STATUS_CHG_CALLBACK.getValue());
            boolean result = true;
            if (ObjectUtils.isEmpty((Object)response)) {
                taskLog.setPushStatus("4");
                taskLog.setErrMsg("\u7ed3\u679c\u56de\u8c03\u901a\u77e5\u2014\u9541\u4fe1\u7aef\u672a\u8fd4\u56de\u5185\u5bb9");
                result = false;
            } else {
                if (AnalysisErrorCodeEnum.ERR_B000000.getKey().equals(response.getResultCode())) {
                    taskLog.setPushStatus("1");
                } else {
                    taskLog.setPushStatus("4");
                    result = false;
                }
                taskLog.setErrMsg(JSON.toJSONString((Object)response));
            }
            return result;
        });
    }

    public <T> ZhizhenResponse<T> convertAndSendZz(ApisBusiUwSupport support, Object requestData, String businessType, Class<T> clazz) {
        ZhizhenReqHead head = new ZhizhenReqHead();
        head.setAccount(support.getAccount());
        head.setReqTime(LocalDateTimeUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmss"));
        head.setKey(SecureUtil.md5((String)(support.getAccount() + support.getPassword() + head.getReqTime())));
        head.setBusinessType(businessType);
        head.setVersion("v1");
        String sourceBody = JSON.toJSONString((Object)requestData);
        log.warn("\u8bf7\u6c42\u5934\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)head));
        log.warn("\u52a0\u5bc6\u524d\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)sourceBody);
        DesUtils utils = new DesUtils(support.getSecret());
        String encodeBody = utils.encrypt(sourceBody);
        ZhizhenRequest request = new ZhizhenRequest();
        request.setHead(head);
        request.setBody((Object)encodeBody);
        ZhizhenResponse response = (ZhizhenResponse)this.httpRequestService.convertAndSendForAgent(support.getCurrentUrl(), (Object)request, ZhizhenResponse.class, businessType);
        if (ObjectUtil.isNotEmpty((Object)response.getResult())) {
            Object uploadRiskResData = JSON.parseObject((String)response.getResult().toString(), clazz);
            response.setResult(uploadRiskResData);
        }
        return response;
    }

    public void pushToAgent(ApisBusiTaskLog busiTaskLog) {
        if (ObjectUtil.isEmpty((Object)busiTaskLog)) {
            return;
        }
        if (ObjectUtil.isEmpty((Object)busiTaskLog.getPushTargetUrl())) {
            log.warn("\u4efb\u52a1businessKey={},\u6ca1\u6709\u914d\u7f6e\u63a8\u9001\u7684URL", (Object)busiTaskLog.getBusinessKey());
        }
        boolean isUpdSuccess = false;
        try {
            busiTaskLog.setPushStatus("2");
            busiTaskLog.setPushStep(Integer.valueOf(busiTaskLog.getPushStep() + 1));
            busiTaskLog.setLastPushTime(LocalDateTime.now());
            isUpdSuccess = this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
            if (isUpdSuccess) {
                StanderPacket responsePacket = (StanderPacket)this.convertAndSendForCallback(busiTaskLog.getPushTargetUrl(), (Object)busiTaskLog.getPushContent(), StanderPacket.class);
                if (ObjectUtil.isNotEmpty((Object)responsePacket)) {
                    ApisChannelUser user = this.getApisChannelUser(responsePacket.getUserCode());
                    String seed = JDAZAesUtils.des3EncodeCbc((String)user.getUserCode(), (String)user.getPwd());
                    String responseStr = JDAZAesUtils.decryptBase64((String)seed, (String)responsePacket.getContent());
                    ResponseHeadDTO responseHead = (ResponseHeadDTO)JSON.parseObject((String)responseStr, ResponseHeadDTO.class);
                    if (ObjectUtil.isNotEmpty((Object)responseHead) && CommonConstant.FccbResponseCode.SUCCESS.intValue() == responseHead.getStatus()) {
                        busiTaskLog.setPushStatus("1");
                    } else {
                        busiTaskLog.setPushStatus("4");
                    }
                    busiTaskLog.setErrMsg(JSON.toJSONString((Object)responseHead));
                } else {
                    busiTaskLog.setPushStatus("4");
                    busiTaskLog.setErrMsg("\u672a\u8fd4\u56de\u5185\u5bb9");
                }
                log.warn("\u5f02\u6b65\u56de\u8c03\u54cd\u5e94\uff1a{}", (Object)responsePacket);
            }
        }
        catch (Exception e) {
            busiTaskLog.setPushStatus("4");
            busiTaskLog.setErrMsg(ObjectUtil.isNotEmpty((Object)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT ? e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT) : e.getMessage());
            log.error("\u5f02\u6b65\u56de\u8c03\u901a\u77e5 error:", (Throwable)e);
        }
        if (isUpdSuccess) {
            this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
        }
    }

    public <T> T convertAndSendForCallback(String url, Object body, Class<T> respType) {
        Date startDate = new Date();
        try {
            Object resp;
            String requestBodyStr = body instanceof String ? (String)body : JSON.toJSONString((Object)body);
            RequestBody requestBody = RequestBody.create((MediaType)JSON_TYPE, (String)requestBodyStr);
            Request request = new Request.Builder().url(url).post(requestBody).build();
            log.warn("\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)requestBodyStr);
            Call call = client.newCall(request);
            Response response = call.execute();
            if (respType == Response.class) {
                resp = response;
            } else {
                String responseBodyStr = response.body().string();
                log.warn("\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)responseBodyStr);
                resp = JSON.parseObject((String)responseBodyStr, respType);
            }
            Response response2 = resp;
            return (T)response2;
        }
        catch (Exception e) {
            log.error("=============call api error :{}", (Object)url);
            throw new RuntimeException(e);
        }
        finally {
            log.warn("\u63a8\u9001\u7528\u65f6:{}", (Object)(System.currentTimeMillis() - startDate.getTime()));
        }
    }

    public ApisChannelUser getApisChannelUser(String operatorCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_code", (Object)operatorCode);
        queryWrapper.eq((Object)"deleted", (Object)ApisChannelUser.DELETE_FLAG_FALSE);
        ApisChannelUser apisChannelUser = (ApisChannelUser)this.apisChannelUserService.getOne((Wrapper)queryWrapper, false);
        if (ObjectUtil.isNotEmpty((Object)apisChannelUser)) {
            return apisChannelUser;
        }
        return null;
    }
}

