/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.xxljob.executor.common.utils;

import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.request.ClaimMediaCommitResult;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgMetaDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ImgBatchUploadServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiReqmsgLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiGuaranteeMaterialService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiReqmsgLogService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorBisCodeEnum;
import com.jdaz.sinosoftgz.coreapi.common.configs.CoreApiProperties;
import com.jdaz.sinosoftgz.coreapi.common.configs.CoreApiServProperties;
import com.jdaz.sinosoftgz.coreapi.common.factory.CoreDtoConverterFactory;
import com.jdaz.sinosoftgz.coreapi.common.handler.CoreDtoConverter;
import com.jdaz.sinosoftgz.coreapi.h5img.MediaUploadApi;
import com.sinosoft.image.client.dto.ImgBatchUploadMetaDTO;
import com.sinosoft.image.client.dto.ImgBatchUploadRequestDTO;
import com.sinosoft.image.client.dto.ImgBusiDTO;
import com.sinosoft.image.client.dto.RequestHeadDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InsureMediaUploadUtil {
    private Logger log = LoggerFactory.getLogger(InsureMediaUploadUtil.class);
    @Autowired
    MediaUploadApi mediaUploadApi;
    @Autowired
    CoreApiProperties coreApiProperties;
    @Autowired
    ApisBusiReqmsgLogService apisBusiReqmsgLogService;
    @Autowired
    CoreDtoConverterFactory coreDtoConverterFactory;
    @Autowired
    ApisBusiGuaranteeMaterialService apisBusiGuaranteeMaterialService;
    private final String SER_PROPERTIES_BATCH_UPLOAD_FILE = "batchUploadFile";

    public ClaimMediaCommitResult imgBatchUpload(StanderRequest request) throws ApisBusinessException {
        long time = System.currentTimeMillis();
        Optional properties = this.coreApiProperties.getServProperties("batchUploadFile");
        if (!properties.isPresent()) {
            this.log.warn(ErrorBisCodeEnum.ERR_B80001.getValue());
            throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B80001.getValue(), ErrorBisCodeEnum.ERR_B80001.getKey());
        }
        ImgBatchUploadRequestDTO imgBatchUploadRequestDTO = this.imgBatchUploadRequestBeforeProcess(request, properties);
        ClaimMediaCommitResult responseDTO = this.mediaUploadApi.batchUpload(((CoreApiServProperties)properties.get()).getUrl(), imgBatchUploadRequestDTO, null);
        if (ObjectUtil.isEmpty((Object)responseDTO) || ObjectUtil.isEmpty((Object)responseDTO.getHeadDto())) {
            throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B80002.getValue(), ErrorBisCodeEnum.ERR_B80002.getKey());
        }
        if (responseDTO.getHeadDto().getStatus() < 0) {
            this.log.warn("\u5f71\u50cf\u7cfb\u7edf\u8c03\u7528\u5931\u8d25\uff1a{}", (Object)responseDTO.getHeadDto().getErrorMessage());
            throw new ApisBusinessException("\u5f71\u50cf\u7cfb\u7edf\u8c03\u7528\u5931\u8d25\uff1a" + responseDTO.getHeadDto().getErrorMessage(), responseDTO.getHeadDto().getErrorCode());
        }
        ImgBatchUploadServiceResponse imgBatchUploadResponse = ImgBatchUploadServiceResponse.builder().build();
        imgBatchUploadResponse.setImgNodes(responseDTO.getImgNodes());
        this.log.warn("\u5f71\u50cf\u7cfb\u7edf\u8c03\u7528\u54cd\u5e94\u62a5\u6587\u6210\u529f\u6570: {}", (Object)responseDTO.getSize());
        this.insertImgBatchUploadLog(request, responseDTO);
        return responseDTO;
    }

    private ImgBatchUploadRequestDTO imgBatchUploadRequestBeforeProcess(StanderRequest request, Optional<CoreApiServProperties> properties) {
        ImgBatchUploadRequestDTO imgBatchUploadRequestDTO = new ImgBatchUploadRequestDTO();
        RequestHeadDTO requestHeadDTO = new RequestHeadDTO();
        requestHeadDTO.setSeqNo(UUID.randomUUID().toString().replace("-", ""));
        requestHeadDTO.setRequestTime(new Date());
        requestHeadDTO.setOptComCode("apis");
        requestHeadDTO.setOptUserCode("apis");
        requestHeadDTO.setOptUserName("apis");
        imgBatchUploadRequestDTO.setHeadDto(requestHeadDTO);
        ImgBusiDTO imgBusiDTO = new ImgBusiDTO();
        imgBusiDTO.setAppCode("UW");
        imgBusiDTO.setClassCode("UWA");
        imgBusiDTO.setBusinessNo(request.getImgBatchUploadServiceRequest().getRequestBody().getLinkNo());
        imgBusiDTO.setBusiComCode("apis");
        imgBusiDTO.setLinkNo(request.getImgBatchUploadServiceRequest().getRequestBody().getLinkNo());
        imgBatchUploadRequestDTO.setBusiDto(imgBusiDTO);
        List imgBatchUploadMetaDTOS = this.compensateImgBatchUploadMeta(request);
        imgBatchUploadRequestDTO.setUploadMetas(imgBatchUploadMetaDTOS);
        requestHeadDTO.setConsumerID(properties.get().getUser());
        requestHeadDTO.setConsumerPWD(properties.get().getUserPwd());
        return imgBatchUploadRequestDTO;
    }

    public List<ImgBatchUploadMetaDTO> compensateImgBatchUploadMeta(StanderRequest request) {
        ArrayList<ImgBatchUploadMetaDTO> uploadMetaDTOList = new ArrayList<ImgBatchUploadMetaDTO>();
        try {
            this.log.warn("\u8fdb\u5165\u7ec4\u88c5\u56fe\u7247\u65b9\u6cd5");
            List imgMetaList = request.getImgBatchUploadServiceRequest().getRequestBody().getImgList();
            for (ImgMetaDTO imgMeta : imgMetaList) {
                int i = 0;
                this.log.warn("\u8fdb\u5165\u5faa\u73af:{}", (Object)i++);
                ImgBatchUploadMetaDTO imgBatchUploadMetaDTO = new ImgBatchUploadMetaDTO();
                imgBatchUploadMetaDTO.setBase64FileContent(imgMeta.getFileContentWithBase64Encode());
                imgBatchUploadMetaDTO.setFileURL(imgMeta.getFileUrl());
                if (ObjectUtil.isEmpty((Object)imgMeta.getIsCovered())) {
                    imgBatchUploadMetaDTO.setCovered(false);
                } else {
                    imgBatchUploadMetaDTO.setCovered(imgMeta.getIsCovered().booleanValue());
                }
                if (ObjectUtil.isEmpty((Object)imgMeta.getFileOrgName())) {
                    if (ObjectUtil.isNotEmpty((Object)imgMeta.getFileName()) && ObjectUtil.isNotEmpty((Object)imgMeta.getExtendName())) {
                        imgBatchUploadMetaDTO.setFileOrgName(imgMeta.getFileName() + "." + imgMeta.getExtendName());
                    }
                } else {
                    imgBatchUploadMetaDTO.setFileOrgName(imgMeta.getFileOrgName());
                }
                if (ObjectUtil.isEmpty((Object)imgMeta.getImgType())) {
                    imgBatchUploadMetaDTO.setImgType("|UWA_A|UWA_A99|");
                } else {
                    imgBatchUploadMetaDTO.setImgType(imgMeta.getImgType());
                }
                if (ObjectUtil.isEmpty((Object)imgMeta.getImgTypeName())) {
                    imgBatchUploadMetaDTO.setImgTypeName("|\u6295\u4fdd\u8d44\u6599|\u5176\u4ed6\u6295\u4fdd\u8d44\u6599|");
                } else {
                    imgBatchUploadMetaDTO.setImgTypeName(imgMeta.getImgTypeName());
                }
                uploadMetaDTOList.add(imgBatchUploadMetaDTO);
            }
        }
        catch (Exception e) {
            this.log.error("\u5f02\u5e38", (Throwable)e);
        }
        return uploadMetaDTOList;
    }

    public void insertImgBatchUploadLog(StanderRequest request, ClaimMediaCommitResult responseDTO) throws ApisBusinessException {
        String orderNo = request.getImgBatchUploadServiceRequest().getRequestBody().getOrderNo();
        try {
            CoreDtoConverter converter = this.coreDtoConverterFactory.get("JSON");
            String api = "imgBatchUpload";
            String bodyStr = converter.toPacketStr((Object)responseDTO);
            ApisBusiReqmsgLog apisBusiReqmsgLog = new ApisBusiReqmsgLog();
            apisBusiReqmsgLog.setApiCode(api);
            apisBusiReqmsgLog.setLogContent(bodyStr);
            apisBusiReqmsgLog.setLogType("2");
            apisBusiReqmsgLog.setOrderNo(orderNo);
            apisBusiReqmsgLog.setCreator(request.getHeader().getUserCode());
            this.apisBusiReqmsgLogService.save((Object)apisBusiReqmsgLog);
        }
        catch (Exception e) {
            this.log.error("\u8bb0\u5f55\u5f71\u50cf\u4e0a\u4f20\u62a5\u6587\u65f6\u51fa\u9519\uff0c\u8ba2\u5355\u53f7\uff1a{}", (Object)orderNo, (Object)e);
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10006.getValue(), ChannelErrorCodeEnum.ERR_C10006.getKey());
        }
    }
}

