/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.xxljob.executor.common.utils;

import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;

@Component
public class MailUtil {
    private static final Logger log = LoggerFactory.getLogger(MailUtil.class);
    @Autowired
    private JavaMailSender mailSender;
    @Value(value="${email.form}")
    private String form;

    public boolean sendEmailHtml(String subject, String content, String emailTo, String emailCc) {
        try {
            MimeMessage mimeMessage = this.mailSender.createMimeMessage();
            MimeMessageHelper messageHelper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
            messageHelper.setFrom(this.form);
            log.warn("\u53d1\u4ef6\u4eba\uff1a{}", (Object)this.form);
            String[] to = emailTo.split(";");
            messageHelper.setTo(to);
            if (StringUtils.isNotEmpty((CharSequence)emailCc)) {
                String[] cc = emailCc.split(";");
                messageHelper.setCc(cc);
            }
            messageHelper.setSubject(subject);
            messageHelper.setText(content, true);
            this.mailSender.send(mimeMessage);
        }
        catch (Exception e) {
            log.warn("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff0c\u6807\u9898\uff1a{}\uff0c\u6b63\u6587\uff1a{}\u3002\u9519\u8bef\u4fe1\u606f\uff1a", new Object[]{subject, content, e});
            return false;
        }
        return true;
    }
}

