/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.publicapiapp.executor;

import cn.hutool.core.util.ObjectUtil;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.jdaz.sinosoftgz.apis.business.app.publicapiapp.factory.CallableFactory;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CommonsExecutorRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CommonsExecutorResponseDTO;
import com.jdaz.sinosoftgz.apis.constants.ErrorBisCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PublicExecutorUtil {
    private static final Logger log = LoggerFactory.getLogger(PublicExecutorUtil.class);
    private static final ExecutorService EXEC = new ThreadPoolExecutor(100, 100, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("public-app-common-pool-%d").build());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> Map<Object, CommonsExecutorResponseDTO> callApiByCallableFactory(List<CommonsExecutorRequestDTO> requestList, CallableFactory factory) throws ApisBusinessException {
        if (requestList.size() == 0 || ObjectUtil.isEmpty((Object)factory)) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N15001.getValue(), ErrorNullValueCodeEnum.ERR_N15001.getKey());
        }
        for (CommonsExecutorRequestDTO request : requestList) {
            if (request.getRequest() != null) continue;
            throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B110001.getValue(), ErrorBisCodeEnum.ERR_B110001.getKey());
        }
        LinkedHashMap futureMap = new LinkedHashMap();
        LinkedHashMap<Object, CommonsExecutorResponseDTO> resMap = new LinkedHashMap<Object, CommonsExecutorResponseDTO>();
        for (CommonsExecutorRequestDTO request : requestList) {
            if (request.getRequest() instanceof Map) {
                ((Map)request.getRequest()).put("requestTime", LocalDateTime.now());
            }
            futureMap.put(request.getRequest(), EXEC.submit(factory.getCallable(request.getOptType(), request.getUrl(), request.getRequest(), (Object)request.getResponse())));
        }
        Iterator iter = futureMap.entrySet().iterator();
        while (iter.hasNext()) {
            CommonsExecutorResponseDTO response = new CommonsExecutorResponseDTO();
            Map.Entry entry = iter.next();
            Object key = entry.getKey();
            try {
                response.code(Integer.valueOf(0)).data(((Future)entry.getValue()).get());
                if (!(key instanceof Map)) continue;
                ((Map)key).put("responseTime", LocalDateTime.now());
            }
            catch (Exception e) {
                log.error("Future\u963b\u585e\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.toString());
                response.code(Integer.valueOf(-1)).msg(e.toString());
                if (!(key instanceof Map)) continue;
                ((Map)key).put("responseTime", LocalDateTime.now());
            }
            finally {
                resMap.put(key, response);
            }
        }
        return resMap;
    }
}

