/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.publicapiapp.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.jdaz.sinosoftgz.apis.business.app.publicapiapp.executor.PublicExecutorUtil;
import com.jdaz.sinosoftgz.apis.business.app.publicapiapp.factory.CallableFactory;
import com.jdaz.sinosoftgz.apis.business.app.publicapiapp.factory.impl.RealNameVerificationCallableFactory;
import com.jdaz.sinosoftgz.apis.business.app.publicapiapp.service.RealNameVerificationService;
import com.jdaz.sinosoftgz.apis.business.app.publicapiapp.service.impl.RealNameVerificationServiceImpl;
import com.jdaz.sinosoftgz.apis.business.app.publicapiapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.ThirdPartyBody;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.ThirdPartyHead;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.ThirdPartyRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.ThirdPartyResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CommonsExecutorRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.thirdParty.AgentInfoDto;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.thirdParty.IdentityInfoDto;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CommonsExecutorResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiRealNameVerificationCacheData;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiRealNameVerificationReqLog;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.PublicCommonConst;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class RealNameVerificationServiceImpl
implements RealNameVerificationService {
    private static Logger log = LoggerFactory.getLogger(RealNameVerificationServiceImpl.class);
    @Value(value="${realNameVerification.businessId}")
    private String businessId;
    @Value(value="${realNameVerification.secretKey}")
    private String secretKey;
    @Value(value="${realNameVerification.gatxz.businessId}")
    private String gatxzBusinessId;
    @Value(value="${realNameVerification.gatxz.secretKey}")
    private String gatxzSecretKey;
    @Value(value="${realNameVerification.twtxz.businessId}")
    private String twtxzBusinessId;
    @Value(value="${realNameVerification.twtxz.secretKey}")
    private String twtxzSecretKey;
    @Value(value="${realNameVerification.jlz.businessId}")
    private String jlzBusinessId;
    @Value(value="${realNameVerification.jlz.secretKey}")
    private String jlzSecretKey;
    @Autowired
    private PublicExecutorUtil publicExecutorUtil;
    @Autowired
    private DataCompletionUtil dataCompletionUtil;
    @Autowired
    private RealNameVerificationCallableFactory callableFactory;
    private Set<String> allowToVerifySet = new /* Unavailable Anonymous Inner Class!! */;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThirdPartyResponse realNameVerify(ThirdPartyRequest request, String loginUser) throws ApisBusinessException {
        if (ObjectUtil.isEmpty((Object)loginUser)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10629.getValue(), ChannelErrorCodeEnum.ERR_C10629.getKey());
        }
        this.dataCompletionUtil.validRequest(request);
        String requestId = request.getHead().getRequestId();
        String agencyCode = null;
        String user = null;
        if (ObjectUtil.isNotEmpty((Object)request.getBody().getAgency())) {
            agencyCode = request.getBody().getAgency().getAgencyCode();
            user = request.getBody().getAgency().getUser();
        }
        List checkedIdInfoList = request.getBody().getIdInfoList().stream().filter(p -> null != p && this.allowToVerifySet.contains(p.getIdType())).distinct().collect(Collectors.toList());
        List noIdCardInfoList = request.getBody().getIdInfoList().stream().filter(p -> null != p && !this.allowToVerifySet.contains(p.getIdType())).distinct().collect(Collectors.toList());
        ArrayList<ApisBusiRealNameVerificationReqLog> saveReqLog = new ArrayList<ApisBusiRealNameVerificationReqLog>();
        ThirdPartyResponse response = null;
        try {
            Map realNameResInfoMap;
            List invalidIdCardList;
            int errorCount = 0;
            ArrayList<IdentityInfoDto> responseBodyIdInfoList = new ArrayList<IdentityInfoDto>();
            if (ObjectUtil.isNotEmpty(noIdCardInfoList)) {
                log.warn("\u975e\u8eab\u4efd\u8bc1\u4fe1\u606f\u7684\u5b9e\u540d\u9a8c\u8bc1\u4fe1\u606f\u5171{}\u6761\uff1a{}", (Object)noIdCardInfoList.size(), (Object)JSONObject.toJSONString(noIdCardInfoList));
                for (Object infoDto : noIdCardInfoList) {
                    IdentityInfoDto idInfo = this.dataCompletionUtil.generateRealNameVerificationResInfoDTO((IdentityInfoDto)infoDto, ChannelErrorCodeEnum.ERR_C10627.getKey(), ChannelErrorCodeEnum.ERR_C10627.getValue());
                    responseBodyIdInfoList.add(idInfo);
                    saveReqLog.add(this.dataCompletionUtil.generateRealNameVerificationReqLogDTO(idInfo, null, "err_res", HitType.NoIdCardType.msg, HitType.NoIdCardType.code, requestId, user, agencyCode, loginUser, null, null));
                    ++errorCount;
                }
            }
            if (ObjectUtil.isNotEmpty(invalidIdCardList = checkedIdInfoList.stream().filter(p -> "1".equals(p.getIdType()) && !IdcardUtil.isValidCard((String)p.getIdNo())).collect(Collectors.toList()))) {
                log.warn("\u65e0\u6548\u8eab\u4efd\u8bc1\u53f7\u7684\u5b9e\u540d\u9a8c\u8bc1\u4fe1\u606f\u5171{}\u6761\uff1a{}", (Object)invalidIdCardList.size(), (Object)JSONObject.toJSONString(invalidIdCardList));
                for (Object infoDto : invalidIdCardList) {
                    IdentityInfoDto identityInfoDto = this.dataCompletionUtil.generateRealNameVerificationResInfoDTO((IdentityInfoDto)infoDto, ChannelErrorCodeEnum.ERR_C10630.getKey(), ChannelErrorCodeEnum.ERR_C10630.getValue());
                    responseBodyIdInfoList.add(identityInfoDto);
                    saveReqLog.add(this.dataCompletionUtil.generateRealNameVerificationReqLogDTO(identityInfoDto, null, "err_res", HitType.InValidIdCard.msg, HitType.InValidIdCard.code, requestId, user, agencyCode, loginUser, null, null));
                    ++errorCount;
                }
                checkedIdInfoList.removeIf(p -> !IdcardUtil.isValidCard((String)p.getIdNo()));
            }
            if (ObjectUtil.isNotEmpty((Object)(realNameResInfoMap = this.dataCompletionUtil.queryRealNameVerification(checkedIdInfoList)))) {
                log.warn("\u4ece\u6570\u636e\u5e93\u91cc\u67e5\u8be2\u5230\u7684\u5b9e\u540d\u8ba4\u8bc1\u4fe1\u606f\u5171{}\u6761\uff1a{}", (Object)realNameResInfoMap.size(), (Object)JSONObject.toJSONString((Object)realNameResInfoMap));
                for (Map.Entry entry : realNameResInfoMap.entrySet()) {
                    saveReqLog.add(this.dataCompletionUtil.generateRealNameVerificationReqLogDTO((IdentityInfoDto)entry.getKey(), (ApisBusiRealNameVerificationCacheData)entry.getValue(), HitType.HitDataBaseCache.code, requestId, user, agencyCode, loginUser));
                    responseBodyIdInfoList.add(this.dataCompletionUtil.generateRealNameVerificationResInfoDTO((IdentityInfoDto)entry.getKey()));
                    if (!ChannelErrorCodeEnum.ERR_C10621.getKey().equals(((IdentityInfoDto)entry.getKey()).getRsCode())) {
                        ++errorCount;
                    }
                    checkedIdInfoList.remove(entry.getKey());
                }
            }
            this.dataCompletionUtil.realNameVerificationCloseFilter(requestId, user, agencyCode, loginUser, checkedIdInfoList, responseBodyIdInfoList, saveReqLog);
            if (ObjectUtil.isNotEmpty(checkedIdInfoList)) {
                Map map;
                ArrayList requestDTOList = new ArrayList();
                errorCount += this.addRealNameVerifyApisReqAndRuturnErrorCount(requestId, user, agencyCode, loginUser, checkedIdInfoList, requestDTOList, responseBodyIdInfoList, saveReqLog);
                log.warn("\u8c03\u7528\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u63a5\u53e3\u5171{}\u6761\uff1b", (Object)requestDTOList.size());
                if (ObjectUtil.isNotEmpty(requestDTOList) && ObjectUtil.isNotEmpty((Object)(map = this.publicExecutorUtil.callApiByCallableFactory(requestDTOList, (CallableFactory)this.callableFactory)))) {
                    ArrayList verifySuccessList = new ArrayList();
                    try {
                        Integer configAge = this.dataCompletionUtil.getRealNameVerificationValidAgeRange();
                        for (Map.Entry entry : map.entrySet()) {
                            Object obj = entry.getKey();
                            Map requestDTO = null;
                            if (obj instanceof Map) {
                                requestDTO = (Map)obj;
                            }
                            if (((CommonsExecutorResponseDTO)entry.getValue()).getCode() == 0 && ObjectUtil.isNotEmpty((Object)((CommonsExecutorResponseDTO)entry.getValue()).getData())) {
                                obj = ((CommonsExecutorResponseDTO)entry.getValue()).getData();
                                Map ret = null;
                                if (obj instanceof Map) {
                                    ret = (Map)obj;
                                }
                                log.warn("\u8fd4\u56de\u62a5\u6587\uff1a{}", (Object)ret);
                                if (this.verifyResIdInfoDTO(requestDTO, ret, requestId, user, agencyCode, loginUser, responseBodyIdInfoList, verifySuccessList, saveReqLog, configAge)) continue;
                                ++errorCount;
                                continue;
                            }
                            log.error("\u5e76\u53d1\u8c03\u7528\u5f02\u5e38\uff1a" + ((CommonsExecutorResponseDTO)entry.getValue()).getMsg());
                            ++errorCount;
                            obj = requestDTO.get("param");
                            Map tmpMap = null;
                            if (obj instanceof Map) {
                                tmpMap = (Map)obj;
                            }
                            String name = null;
                            String idCard = null;
                            String birthday = null;
                            String validityOfCertificate = null;
                            if (ObjectUtil.isNotEmpty((Object)tmpMap)) {
                                name = this.castToString(tmpMap.get("name"));
                                idCard = this.castToString(tmpMap.get("idCard"));
                                birthday = this.castToString(tmpMap.get("birthday"));
                                validityOfCertificate = this.castToString(tmpMap.get("validityOfCertificate"));
                            }
                            IdentityInfoDto idInfo = IdentityInfoDto.builder().name(name).idType(this.castToString(requestDTO.get("idType"))).idNo(idCard).birthday(birthday).validityOfCertificate(validityOfCertificate).rsCode(ChannelErrorCodeEnum.ERR_C10625.getKey()).rsMsg(ChannelErrorCodeEnum.ERR_C10625.getValue()).build();
                            responseBodyIdInfoList.add(idInfo);
                            saveReqLog.add(this.dataCompletionUtil.generateRealNameVerificationReqLogDTO(idInfo, null, "err_res", HitType.RequestError.msg, HitType.RequestError.code, requestId, user, agencyCode, loginUser, this.castToLocalDateTime(requestDTO.get("requestTime")), this.castToLocalDateTime(requestDTO.get("responseTime"))));
                        }
                    }
                    finally {
                        if (ObjectUtil.isNotEmpty(verifySuccessList)) {
                            this.dataCompletionUtil.saveRealNameVerificationRes(verifySuccessList);
                        }
                    }
                }
            }
            response = errorCount == 0 ? this.generateResponse(request, ChannelErrorCodeEnum.ERR_C10631.getKey(), ChannelErrorCodeEnum.ERR_C10631.getValue(), responseBodyIdInfoList) : this.generateResponse(request, ChannelErrorCodeEnum.ERR_C10632.getKey(), ChannelErrorCodeEnum.ERR_C10632.getValue(), responseBodyIdInfoList);
        }
        finally {
            this.dataCompletionUtil.saveRealNameVerificationReqLog(saveReqLog);
        }
        return response;
    }

    private ThirdPartyResponse generateResponse(ThirdPartyRequest request, String errorCode, String errorMsg, List<IdentityInfoDto> idInfoList) {
        boolean isHeadNotEmpty = ObjectUtil.isNotEmpty((Object)request) && ObjectUtil.isNotEmpty((Object)request.getHead());
        ThirdPartyHead headDTO = ThirdPartyHead.builder().requestId(isHeadNotEmpty ? request.getHead().getRequestId() : null).serviceName(isHeadNotEmpty ? request.getHead().getServiceName() : null).errorCode(errorCode).errorMessage(errorMsg).build();
        ThirdPartyBody bodyDTO = ThirdPartyBody.builder().idInfoList(ObjectUtil.isNotEmpty(idInfoList) ? idInfoList : null).build();
        if (ObjectUtil.isNotEmpty((Object)request) && ObjectUtil.isNotEmpty((Object)request.getBody()) && ObjectUtil.isNotEmpty((Object)request.getBody().getAgency())) {
            AgentInfoDto agentInfoDto = AgentInfoDto.builder().user(request.getBody().getAgency().getUser()).agencyCode(request.getBody().getAgency().getAgencyCode()).build();
            bodyDTO.setAgency(agentInfoDto);
        }
        return ThirdPartyResponse.builder().head(headDTO).body(bodyDTO).build();
    }

    private boolean verifyResIdInfoDTO(Map requestDTO, Map obj, String requestId, String user, String agencyCode, String loginUser, List<IdentityInfoDto> responseDTOList, List<Map> verifySuccessList, List<ApisBusiRealNameVerificationReqLog> reqLogList, Integer configAge) throws ApisBusinessException {
        Map resMap = obj;
        Object code = resMap.get("code");
        Object msg = resMap.get("msg");
        Map data = null;
        try {
            data = (Map)DataCompletionUtil.castToClass(Map.class, resMap.get("data"), (boolean)false);
        }
        catch (Exception e) {
            log.error("\u8fd4\u56deMap\u91cc\u7684data\u53c2\u6570\u8f6c\u6362\u51fa\u9519\uff1a{}", resMap.get("data"));
        }
        String idCard = null;
        String name = null;
        String birthday = null;
        String validityOfCertificate = null;
        Object verifyRs = null;
        if (ObjectUtil.isNotEmpty((Object)data)) {
            verifyRs = "1".equals(requestDTO.get("idType")) ? data.get("verifyRs") : data.get("resultCode");
        }
        Object castObj = requestDTO.get("param");
        Map tmpMap = null;
        if (castObj instanceof Map) {
            tmpMap = (Map)castObj;
        }
        if (ObjectUtil.isNotEmpty(tmpMap)) {
            name = this.castToString(tmpMap.get("name"));
            idCard = this.castToString(tmpMap.get("idCard"));
            birthday = this.castToString(tmpMap.get("birthday"));
            validityOfCertificate = this.castToString(tmpMap.get("validityOfCertificate"));
        }
        IdentityInfoDto idInfoDTO = IdentityInfoDto.builder().idNo(idCard).name(name).idType(this.castToString(requestDTO.get("idType"))).birthday(birthday).validityOfCertificate(validityOfCertificate).build();
        boolean isPass = this.getErrorCodeMsgByVerifyRs(verifyRs, code, idInfoDTO, configAge);
        String hitType = HitType.RequestSuccess.code;
        if ("SU200".equals(code) && ("NAME_SAME".equals(verifyRs) || ResultCode.NAME_SAME.code.equals(verifyRs))) {
            resMap.put("idType", requestDTO.get("idType"));
            resMap.put("rsCode", idInfoDTO.getRsCode());
            resMap.put("rsMsg", idInfoDTO.getRsMsg());
            verifySuccessList.add(resMap);
        } else if ("SU200".equals(code) && isPass) {
            hitType = HitType.VerifyNoPassButgeInValidRange.code;
            if (null == msg) {
                msg = "";
            }
            msg = msg + String.format(HitType.VerifyNoPassButgeInValidRange.msg, configAge);
        }
        reqLogList.add(this.dataCompletionUtil.generateRealNameVerificationReqLogDTO(idInfoDTO, this.castToString(verifyRs), this.castToString(code), this.castToString(msg), hitType, requestId, user, agencyCode, loginUser, this.castToLocalDateTime(requestDTO.get("requestTime")), this.castToLocalDateTime(requestDTO.get("responseTime"))));
        responseDTOList.add(idInfoDTO);
        return isPass;
    }

    private String castToString(Object value) {
        return (String)DataCompletionUtil.castToClass(String.class, (Object)value);
    }

    private LocalDateTime castToLocalDateTime(Object value) {
        return (LocalDateTime)DataCompletionUtil.castToClass(LocalDateTime.class, (Object)value);
    }

    private boolean getErrorCodeMsgByVerifyRs(Object verifyRs, Object code, IdentityInfoDto idInfoDTO, Integer configAge) throws ApisBusinessException {
        boolean isPass = false;
        if ("SU200".equals(code)) {
            if ("NAME_SAME".equals(verifyRs) || ResultCode.NAME_SAME.code.equals(verifyRs)) {
                idInfoDTO.setRsCode(ChannelErrorCodeEnum.ERR_C10621.getKey());
                idInfoDTO.setRsMsg(ChannelErrorCodeEnum.ERR_C10621.getValue());
                isPass = true;
            } else {
                try {
                    if ("1".equals(idInfoDTO.getIdType()) && ObjectUtil.isNotEmpty((Object)configAge)) {
                        DateTime birthDate = IdcardUtil.getBirthDate((String)idInfoDTO.getIdNo());
                        Calendar calendar = birthDate.toCalendar();
                        calendar.add(1, configAge);
                        long nowTime = System.currentTimeMillis();
                        if (birthDate.getTime() <= nowTime && calendar.getTimeInMillis() > nowTime) {
                            log.warn("\u5b9e\u540d\u8ba4\u8bc1\u4eba\u5458\u4fe1\u606f\u3010{}-{}\u3011\u6570\u79d1\u63a5\u53e3\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff0c\u4f46\u4eba\u5458\u5e74\u9f84\u4e0d\u8d85\u8fc7\u914d\u7f6e\u7684\u5e74\u9f84\uff1a{}\uff0c\u6545\u5f53\u4f5c\u9a8c\u8bc1\u901a\u8fc7\uff0c\u4f46\u4e0d\u4fdd\u5b58\u5230\u5b9e\u540d\u8ba4\u8bc1\u6570\u636e\u5e93\u7f13\u5b58\u4e2d\u3002", new Object[]{idInfoDTO.getName(), idInfoDTO.getIdNo(), configAge});
                            idInfoDTO.setRsCode(ChannelErrorCodeEnum.ERR_C10621.getKey());
                            idInfoDTO.setRsMsg(ChannelErrorCodeEnum.ERR_C10621.getValue());
                            isPass = true;
                        }
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                if (!isPass) {
                    if ("1".equals(idInfoDTO.getIdType())) {
                        if ("ID_NOT_EXIST".equals(verifyRs)) {
                            idInfoDTO.setRsCode(ChannelErrorCodeEnum.ERR_C10623.getKey());
                            idInfoDTO.setRsMsg(ChannelErrorCodeEnum.ERR_C10623.getValue());
                        } else if ("NAME_NOT_SAME".equals(verifyRs)) {
                            idInfoDTO.setRsCode(ChannelErrorCodeEnum.ERR_C10624.getKey());
                            idInfoDTO.setRsMsg(ChannelErrorCodeEnum.ERR_C10624.getValue());
                        } else {
                            idInfoDTO.setRsCode(ChannelErrorCodeEnum.ERR_C10622.getKey());
                            idInfoDTO.setRsMsg(ChannelErrorCodeEnum.ERR_C10622.getValue());
                        }
                    } else if (ResultCode.VALIDITY_NOT_SAME.code.equals(verifyRs)) {
                        idInfoDTO.setRsCode(ChannelErrorCodeEnum.ERR_C10674.getKey());
                        idInfoDTO.setRsMsg(ChannelErrorCodeEnum.ERR_C10674.getValue());
                    } else if (ResultCode.BIRTHDAY_NOT_SAME.code.equals(verifyRs)) {
                        idInfoDTO.setRsCode(ChannelErrorCodeEnum.ERR_C10673.getKey());
                        idInfoDTO.setRsMsg(ChannelErrorCodeEnum.ERR_C10673.getValue());
                    } else if (ResultCode.NAME_NOT_SAME.code.equals(verifyRs)) {
                        idInfoDTO.setRsCode(ChannelErrorCodeEnum.ERR_C10624_1.getKey());
                        idInfoDTO.setRsMsg(ChannelErrorCodeEnum.ERR_C10624_1.getValue());
                    } else if (ResultCode.ID_NOT_EXIST.code.equals(verifyRs)) {
                        idInfoDTO.setRsCode(ChannelErrorCodeEnum.ERR_C10623_1.getKey());
                        idInfoDTO.setRsMsg(ChannelErrorCodeEnum.ERR_C10623_1.getValue());
                    } else {
                        idInfoDTO.setRsCode(ChannelErrorCodeEnum.ERR_C10622.getKey());
                        idInfoDTO.setRsMsg(ChannelErrorCodeEnum.ERR_C10622.getValue());
                    }
                }
            }
        } else {
            log.warn("\u8c03\u7528\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u63a5\u53e3API\u51fa\u9519\uff1acode={}, ", code);
            if ("EP001".equals(code)) {
                idInfoDTO.setRsCode(ChannelErrorCodeEnum.ERR_C10623.getKey());
                idInfoDTO.setRsMsg(ChannelErrorCodeEnum.ERR_C10623.getValue());
            } else {
                idInfoDTO.setRsCode(ChannelErrorCodeEnum.ERR_C10625.getKey());
                idInfoDTO.setRsMsg(ChannelErrorCodeEnum.ERR_C10625.getValue());
            }
        }
        return isPass;
    }

    private String[] getBusinessIdAndSecretKeyByIdType(String idType) {
        String[] ss = new String[2];
        if ("1".equals(idType)) {
            ss[0] = this.businessId;
            ss[1] = this.secretKey;
        } else if (PublicCommonConst.IdentifyTypeEnum.RETURN_HOME_CERTIFICATE.value.equals(idType)) {
            ss[0] = this.gatxzBusinessId;
            ss[1] = this.gatxzSecretKey;
        } else if (PublicCommonConst.IdentifyTypeEnum.TAIWAN_COMPATRIOT_CERTIFICATE.value.equals(idType)) {
            ss[0] = this.twtxzBusinessId;
            ss[1] = this.twtxzSecretKey;
        } else if (PublicCommonConst.IdentifyTypeEnum.RESIDENCE_PERMIT.value.equals(idType)) {
            ss[0] = this.jlzBusinessId;
            ss[1] = this.jlzSecretKey;
        }
        return ss;
    }

    private int addRealNameVerifyApisReqAndRuturnErrorCount(String requestId, String user, String agencyCode, String loginUser, List<IdentityInfoDto> checkedIdInfoList, List<CommonsExecutorRequestDTO> requestDTOList, List<IdentityInfoDto> responseBodyIdInfoList, List<ApisBusiRealNameVerificationReqLog> saveReqLog) {
        int errorCount = 0;
        for (IdentityInfoDto identityInfoDto : checkedIdInfoList) {
            String[] busiKeyArr = this.getBusinessIdAndSecretKeyByIdType(identityInfoDto.getIdType());
            boolean isValid = this.dataCompletionUtil.addRealNameVerifyApisReq(busiKeyArr[0], busiKeyArr[1], requestId, user, agencyCode, loginUser, identityInfoDto, requestDTOList, responseBodyIdInfoList, saveReqLog);
            if (isValid) continue;
            ++errorCount;
        }
        return errorCount;
    }
}

