/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.publicapiapp.utils;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jd.jrdp.exts.server.util.SignatureUtil;
import com.jdaz.sinosoftgz.apis.business.app.publicapiapp.service.impl.RealNameVerificationServiceImpl;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.ThirdPartyRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CommonsExecutorRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.thirdParty.IdentityInfoDto;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiRealNameVerificationCacheData;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiRealNameVerificationReqLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRealNameVerificationCacheDataService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRealNameVerificationReqLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.PublicCommonConst;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class DataCompletionUtil {
    private static final Logger log = LoggerFactory.getLogger(DataCompletionUtil.class);
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    ApisBusiRealNameVerificationReqLogService apisBusiRealNameVerificationReqLogService;
    @Autowired
    ApisBusiRealNameVerificationCacheDataService apisBusiRealNameVerificationCacheDataService;

    public void validRequest(ThirdPartyRequest request) throws ApisBusinessException {
        if (ObjectUtil.isEmpty((Object)request) || ObjectUtil.isEmpty((Object)request.getBody()) || ObjectUtil.isEmpty((Object)request.getBody().getIdInfoList())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10620.getValue(), ChannelErrorCodeEnum.ERR_C10620.getKey());
        }
        if (10 < request.getBody().getIdInfoList().size()) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10628.getValue().replace("##", "10"), ChannelErrorCodeEnum.ERR_C10628.getKey());
        }
        for (IdentityInfoDto idInfo : request.getBody().getIdInfoList()) {
            if (StrUtil.isEmpty((CharSequence)idInfo.getName())) {
                throw new ApisBusinessException("\u4eba\u5458\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", ChannelErrorCodeEnum.ERR_C10467.getKey());
            }
            if (StrUtil.isEmpty((CharSequence)idInfo.getIdNo())) {
                throw new ApisBusinessException("\u4eba\u5458\u8bc1\u4ef6\u53f7\u4e0d\u80fd\u4e3a\u7a7a", ChannelErrorCodeEnum.ERR_C10467.getKey());
            }
            if (PublicCommonConst.IdentifyTypeEnum.RETURN_HOME_CERTIFICATE.value.equals(idInfo.getIdType()) || PublicCommonConst.IdentifyTypeEnum.TAIWAN_COMPATRIOT_CERTIFICATE.value.equals(idInfo.getIdType()) || PublicCommonConst.IdentifyTypeEnum.RESIDENCE_PERMIT.value.equals(idInfo.getIdType())) {
                if (StrUtil.isBlank((CharSequence)idInfo.getBirthday())) {
                    throw new ApisBusinessException("\u4eba\u5458\u3010" + idInfo.getName() + "-" + idInfo.getIdNo() + "\u3011\u7684\u51fa\u751f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", ChannelErrorCodeEnum.ERR_C10467.getKey());
                }
                if (StrUtil.isBlank((CharSequence)idInfo.getValidityOfCertificate())) {
                    throw new ApisBusinessException("\u4eba\u5458\u3010" + idInfo.getName() + "-" + idInfo.getIdNo() + "\u3011\u7684\u8bc1\u4ef6\u6709\u6548\u671f\u4e0d\u80fd\u4e3a\u7a7a", ChannelErrorCodeEnum.ERR_C10467.getKey());
                }
                if (!this.validYmdFormat(idInfo.getBirthday())) {
                    throw new ApisBusinessException("\u4eba\u5458\u3010" + idInfo.getName() + "-" + idInfo.getIdNo() + "\u3011\u7684" + ChannelErrorCodeEnum.ERR_C10009.getValue().replaceFirst("##", "birthday").replaceFirst("##", "yyyyMMdd"), ChannelErrorCodeEnum.ERR_C10009.getKey());
                }
                if (this.validYmdFormat(idInfo.getValidityOfCertificate())) continue;
                throw new ApisBusinessException("\u4eba\u5458\u3010" + idInfo.getName() + "-" + idInfo.getIdNo() + "\u3011\u7684" + ChannelErrorCodeEnum.ERR_C10009.getValue().replaceFirst("##", "validityOfCertificate").replaceFirst("##", "yyyyMMdd"), ChannelErrorCodeEnum.ERR_C10009.getKey());
            }
            if (!"1".equals(idInfo.getIdType())) continue;
            idInfo.setBirthday(null);
            idInfo.setValidityOfCertificate(null);
        }
        if (ObjectUtil.isEmpty((Object)request.getHead()) || ObjectUtil.isEmpty((Object)request.getHead().getRequestId())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "requestId"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
    }

    private boolean validYmdFormat(String str) {
        try {
            DateTime date = DateUtil.parse((CharSequence)str);
            if (str.equals(DateUtil.format((Date)date, (String)"yyyyMMdd"))) {
                return true;
            }
        }
        catch (Exception e) {
            log.error("\u65e5\u671f\u683c\u5f0f\u6709\u8bef\uff1a{}", (Object)str);
        }
        return false;
    }

    public int addRealNameVerifyApisReqAndRuturnErrorCount(String businessId, String secretKey, String requestId, String user, String agencyCode, String loginUser, List<IdentityInfoDto> requestList, List<CommonsExecutorRequestDTO> requestDTOList, List<IdentityInfoDto> responseBodyIdInfoList, List<ApisBusiRealNameVerificationReqLog> reqLogList) {
        int errorCount = 0;
        for (IdentityInfoDto idInfo : requestList) {
            if (this.addRealNameVerifyApisReq(businessId, secretKey, requestId, user, agencyCode, loginUser, idInfo, requestDTOList, responseBodyIdInfoList, reqLogList)) continue;
            ++errorCount;
        }
        return errorCount;
    }

    public boolean addRealNameVerifyApisReq(String businessId, String secretKey, String requestId, String user, String agencyCode, String loginUser, IdentityInfoDto idInfo, List<CommonsExecutorRequestDTO> requestDTOList, List<IdentityInfoDto> responseBodyIdInfoList, List<ApisBusiRealNameVerificationReqLog> reqLogList) {
        boolean ret = true;
        CommonsExecutorRequestDTO requestDTO = new CommonsExecutorRequestDTO();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("reqSerialNo", UUID.randomUUID().toString());
        paramMap.put("businessId", businessId);
        paramMap.put("idType", idInfo.getIdType());
        HashMap<String, String> tmpMap = new HashMap<String, String>();
        tmpMap.put("idCard", idInfo.getIdNo());
        tmpMap.put("name", idInfo.getName());
        if (StrUtil.isNotBlank((CharSequence)idInfo.getBirthday())) {
            tmpMap.put("birthday", idInfo.getBirthday());
        }
        if (StrUtil.isNotBlank((CharSequence)idInfo.getValidityOfCertificate())) {
            tmpMap.put("validityOfCertificate", idInfo.getValidityOfCertificate());
        }
        if (!"1".equals(idInfo.getIdType())) {
            paramMap.put("isQueryCache", "cacheFirst");
            paramMap.put("dataSourceIdentifier", "MPS_HMT_");
        }
        paramMap.put("param", tmpMap);
        boolean isOptTypeEmpty = false;
        String optType = (String)PublicCommonConst.identifyOptTypeMap.get(idInfo.getIdType());
        if (StrUtil.isBlank((CharSequence)optType)) {
            isOptTypeEmpty = true;
        }
        requestDTO.setOptType(optType);
        boolean isError = false;
        if (!isOptTypeEmpty) {
            try {
                paramMap.put("signature", SignatureUtil.generateSignature((long)System.currentTimeMillis(), (String)businessId, (String)secretKey));
            }
            catch (Exception e) {
                log.error("\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u63a5\u53e3\uff1a\u751f\u6210\u7b7e\u540d\u51fa\u9519\uff01");
                isError = true;
            }
        }
        if (isOptTypeEmpty) {
            IdentityInfoDto errorIdInfo = this.generateRealNameVerificationResInfoDTO(idInfo, ChannelErrorCodeEnum.ERR_C10625.getKey(), ChannelErrorCodeEnum.ERR_C10625.getValue());
            responseBodyIdInfoList.add(errorIdInfo);
            reqLogList.add(this.generateRealNameVerificationReqLogDTO(errorIdInfo, null, "err_opt_type", RealNameVerificationServiceImpl.HitType.OptTypeError.msg, RealNameVerificationServiceImpl.HitType.OptTypeError.code, requestId, user, agencyCode, loginUser, null, null));
            ret = false;
        } else if (isError) {
            IdentityInfoDto errorIdInfo = this.generateRealNameVerificationResInfoDTO(idInfo, ChannelErrorCodeEnum.ERR_C10625.getKey(), ChannelErrorCodeEnum.ERR_C10625.getValue());
            responseBodyIdInfoList.add(errorIdInfo);
            reqLogList.add(this.generateRealNameVerificationReqLogDTO(errorIdInfo, null, "err_sign", RealNameVerificationServiceImpl.HitType.SignatureError.msg, RealNameVerificationServiceImpl.HitType.SignatureError.code, requestId, user, agencyCode, loginUser, null, null));
            ret = false;
        } else {
            requestDTO.setRequest(paramMap);
            requestDTO.setResponse(Map.class);
            requestDTOList.add(requestDTO);
        }
        return ret;
    }

    public IdentityInfoDto generateRealNameVerificationResInfoDTO(IdentityInfoDto identityInfoDto) {
        return this.generateRealNameVerificationResInfoDTO(identityInfoDto, identityInfoDto.getRsCode(), identityInfoDto.getRsMsg());
    }

    public IdentityInfoDto generateRealNameVerificationResInfoDTO(IdentityInfoDto idInfo, String rsCode, String rsMsg) {
        return IdentityInfoDto.builder().name(idInfo.getName()).idType(idInfo.getIdType()).idNo(idInfo.getIdNo()).birthday(idInfo.getBirthday()).validityOfCertificate(idInfo.getValidityOfCertificate()).rsCode(rsCode).rsMsg(rsMsg).build();
    }

    public ApisBusiRealNameVerificationReqLog generateRealNameVerificationReqLogDTO(IdentityInfoDto idInfo, ApisBusiRealNameVerificationCacheData cacheData, String hitType, String requestId, String user, String agencyCode, String loginUser) {
        ApisBusiRealNameVerificationReqLog reqLog = new ApisBusiRealNameVerificationReqLog().setIdCard(idInfo.getIdNo()).setIdType(idInfo.getIdType()).setName(idInfo.getName()).setHitType(hitType).setErrMsg(cacheData.getMsg()).setRsCode(idInfo.getRsCode()).setRsMsg(idInfo.getRsMsg()).setCode(cacheData.getCode()).setVerifyRs(cacheData.getVerifyRs()).setBusinessKey(requestId).setUserCode(user).setChannelCode(agencyCode).setLoginUser(loginUser).setBirthday(idInfo.getBirthday()).setValidityOfCertificate(idInfo.getValidityOfCertificate());
        return reqLog;
    }

    public ApisBusiRealNameVerificationReqLog generateRealNameVerificationReqLogDTO(IdentityInfoDto idInfoDTO, String verifyRs, String code, String msg, String hitType, String requestId, String user, String agencyCode, String loginUser, LocalDateTime requestTime, LocalDateTime responseTime) {
        ApisBusiRealNameVerificationReqLog reqLog = new ApisBusiRealNameVerificationReqLog().setIdCard(idInfoDTO.getIdNo()).setIdType(idInfoDTO.getIdType()).setName(idInfoDTO.getName()).setHitType(hitType).setErrMsg(msg).setRsCode(idInfoDTO.getRsCode()).setRsMsg(idInfoDTO.getRsMsg()).setCode(code).setVerifyRs(verifyRs).setBusinessKey(requestId).setUserCode(user).setChannelCode(agencyCode).setLoginUser(loginUser).setRequestTime(requestTime).setResponseTime(responseTime).setBirthday(idInfoDTO.getBirthday()).setValidityOfCertificate(idInfoDTO.getValidityOfCertificate());
        return reqLog;
    }

    public boolean isRealNameVerificationClose(String configCode) {
        if (StrUtil.isBlank((CharSequence)configCode)) {
            return true;
        }
        ApisChannelConfigs apisChannelConfigs = new ApisChannelConfigs();
        apisChannelConfigs.setConfigCode(configCode);
        ApisChannelConfigs configs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigs);
        if (configs == null) {
            return false;
        }
        return "1".equals(configs.getConfigValue());
    }

    public void realNameVerificationCloseFilter(String requestId, String user, String agencyCode, String loginUser, List<IdentityInfoDto> identityInfoDtoList, List<IdentityInfoDto> responseBodyIdInfoList, List<ApisBusiRealNameVerificationReqLog> saveReqLog) {
        if (ObjectUtil.isEmpty(identityInfoDtoList)) {
            return;
        }
        HashMap<String, Boolean> cacheMap = new HashMap<String, Boolean>();
        ArrayList<IdentityInfoDto> delIdentityInfoList = new ArrayList<IdentityInfoDto>();
        for (IdentityInfoDto identityInfoDto : identityInfoDtoList) {
            Boolean isClose = (Boolean)cacheMap.get(identityInfoDto.getIdType());
            if (null == isClose) {
                isClose = this.isRealNameVerificationClose((String)PublicCommonConst.realNameVerifyCloseMap.get(identityInfoDto.getIdType()));
                cacheMap.put(identityInfoDto.getIdType(), isClose);
            }
            if (!isClose.booleanValue()) continue;
            IdentityInfoDto resIdInfo = this.generateRealNameVerificationResInfoDTO(identityInfoDto, ChannelErrorCodeEnum.ERR_C10621.getKey(), ChannelErrorCodeEnum.ERR_C10621.getValue());
            responseBodyIdInfoList.add(resIdInfo);
            saveReqLog.add(this.generateRealNameVerificationReqLogDTO(resIdInfo, null, "err_close", RealNameVerificationServiceImpl.HitType.ShuKeNoUsable.msg, RealNameVerificationServiceImpl.HitType.ShuKeNoUsable.code, requestId, user, agencyCode, loginUser, null, null));
            delIdentityInfoList.add(identityInfoDto);
        }
        if (ObjectUtil.isNotEmpty(delIdentityInfoList)) {
            log.warn("\u5173\u95ed\u9a8c\u8bc1\u5f00\u5173\uff0c\u65e0\u9700\u9a8c\u8bc1\u7684\u5b9e\u540d\u9a8c\u8bc1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(delIdentityInfoList));
            identityInfoDtoList.removeAll(delIdentityInfoList);
        }
    }

    public Integer getRealNameVerificationValidAgeRange() {
        ApisChannelConfigs apisChannelConfigs = new ApisChannelConfigs();
        apisChannelConfigs.setConfigCode("real_name_verify_max_age");
        ApisChannelConfigs configs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigs);
        Integer maxAge = null;
        try {
            if (null != configs && null != configs.getConfigValue() && (maxAge = Integer.valueOf(NumberUtil.parseNumber((String)configs.getConfigValue()).intValue())) < 0) {
                maxAge = null;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return maxAge;
    }

    public Map<IdentityInfoDto, ApisBusiRealNameVerificationCacheData> queryRealNameVerification(List<IdentityInfoDto> idInfoList) {
        HashMap<IdentityInfoDto, ApisBusiRealNameVerificationCacheData> ret = new HashMap<IdentityInfoDto, ApisBusiRealNameVerificationCacheData>();
        if (ObjectUtil.isNotEmpty(idInfoList)) {
            for (IdentityInfoDto idInfo : idInfoList) {
                ApisBusiRealNameVerificationCacheData sameCacheData;
                QueryWrapper queryWrapper;
                if ("1".equals(idInfo.getIdType())) {
                    queryWrapper = new QueryWrapper();
                    queryWrapper.eq((Object)"id_card", (Object)idInfo.getIdNo());
                    queryWrapper.eq((Object)"id_type", (Object)idInfo.getIdType());
                    queryWrapper.eq((Object)"verify_rs", (Object)"NAME_SAME");
                    queryWrapper.apply("start_date <= NOW() and (end_date is null or end_date >= NOW())", new Object[0]);
                    sameCacheData = (ApisBusiRealNameVerificationCacheData)this.apisBusiRealNameVerificationCacheDataService.getOne((Wrapper)queryWrapper, false);
                    if (!ObjectUtil.isNotEmpty((Object)sameCacheData)) continue;
                    if (!idInfo.getName().equalsIgnoreCase(sameCacheData.getName())) {
                        idInfo.setRsCode(ChannelErrorCodeEnum.ERR_C10624.getKey());
                        idInfo.setRsMsg(ChannelErrorCodeEnum.ERR_C10624.getValue());
                    } else {
                        idInfo.setRsCode(sameCacheData.getRsCode());
                        idInfo.setRsMsg(sameCacheData.getRsMsg());
                    }
                    ret.put(idInfo, sameCacheData);
                    continue;
                }
                queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"id_card", (Object)idInfo.getIdNo());
                queryWrapper.eq((Object)"id_type", (Object)idInfo.getIdType());
                queryWrapper.eq((Object)"verify_rs", (Object)"01");
                queryWrapper.apply("start_date <= NOW() and (end_date is null or end_date >= NOW())", new Object[0]);
                sameCacheData = (ApisBusiRealNameVerificationCacheData)this.apisBusiRealNameVerificationCacheDataService.getOne((Wrapper)queryWrapper, false);
                if (!ObjectUtil.isNotEmpty((Object)sameCacheData)) continue;
                if (!idInfo.getName().equalsIgnoreCase(sameCacheData.getName())) {
                    idInfo.setRsCode(ChannelErrorCodeEnum.ERR_C10624_1.getKey());
                    idInfo.setRsMsg(ChannelErrorCodeEnum.ERR_C10624_1.getValue());
                } else if (!StrUtil.equals((CharSequence)idInfo.getBirthday(), (CharSequence)sameCacheData.getBirthday())) {
                    idInfo.setRsCode(ChannelErrorCodeEnum.ERR_C10673.getKey());
                    idInfo.setRsMsg(ChannelErrorCodeEnum.ERR_C10673.getValue());
                } else if (!StrUtil.equals((CharSequence)idInfo.getValidityOfCertificate(), (CharSequence)sameCacheData.getValidityOfCertificate())) {
                    idInfo.setRsCode(ChannelErrorCodeEnum.ERR_C10674.getKey());
                    idInfo.setRsMsg(ChannelErrorCodeEnum.ERR_C10674.getValue());
                } else {
                    idInfo.setRsCode(ChannelErrorCodeEnum.ERR_C10621.getKey());
                    idInfo.setRsMsg(ChannelErrorCodeEnum.ERR_C10621.getValue());
                }
                ret.put(idInfo, sameCacheData);
            }
        }
        return ret;
    }

    public boolean saveRealNameVerificationReqLog(List<ApisBusiRealNameVerificationReqLog> idInfoList) {
        if (ObjectUtil.isNotEmpty(idInfoList)) {
            boolean isSuccess;
            try {
                isSuccess = this.apisBusiRealNameVerificationReqLogService.saveBatch(idInfoList);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                isSuccess = false;
            }
            if (isSuccess) {
                return true;
            }
            log.warn("\u6279\u91cf\u4fdd\u5b58\u6e20\u9053\u8bbf\u95ee\u5b9e\u540d\u8ba4\u8bc1\u63a5\u53e3\u7684\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25\uff01");
        } else {
            log.warn("\u6ca1\u6709\u8981\u4fdd\u5b58\u7684\u6e20\u9053\u8bbf\u95ee\u5b9e\u540d\u8ba4\u8bc1\u63a5\u53e3\u7684\u65e5\u5fd7\u8bb0\u5f55");
        }
        return false;
    }

    public boolean saveRealNameVerificationRes(List<Map> resDataList) {
        if (ObjectUtil.isNotEmpty(resDataList)) {
            boolean isSuccess;
            ArrayList<ApisBusiRealNameVerificationCacheData> cacheDataList = new ArrayList<ApisBusiRealNameVerificationCacheData>();
            LocalDateTime now = LocalDateTime.now();
            try {
                for (Map resData : resDataList) {
                    ApisBusiRealNameVerificationCacheData cacheData = new ApisBusiRealNameVerificationCacheData();
                    cacheData.setResult((String)DataCompletionUtil.castToClass(String.class, resData.get("result"))).setCode((String)DataCompletionUtil.castToClass(String.class, resData.get("code"))).setMsg((String)DataCompletionUtil.castToClass(String.class, resData.get("msg")));
                    Map data = (Map)DataCompletionUtil.castToClass(Map.class, resData.get("data"));
                    if (ObjectUtil.isNotEmpty((Object)data)) {
                        String verifyRs = (String)DataCompletionUtil.castToClass(String.class, data.get("verifyRs"));
                        if (StrUtil.isBlank((CharSequence)verifyRs)) {
                            verifyRs = (String)DataCompletionUtil.castToClass(String.class, data.get("resultCode"));
                        }
                        LocalDateTime endDate = null;
                        String validityOfCertificate = (String)DataCompletionUtil.castToClass(String.class, data.get("validityOfCertificate"));
                        if (StrUtil.isNotBlank((CharSequence)validityOfCertificate)) {
                            try {
                                DateTime date = DateUtil.parse((CharSequence)(validityOfCertificate + "235959"), (String)"yyyyMMddHHmmss");
                                endDate = LocalDateTimeUtil.of((Date)date);
                            }
                            catch (Exception e) {
                                log.error("\u7f13\u5b58\u5b9e\u540d\u9a8c\u8bc1\u4fe1\u606f\uff0c\u89e3\u6790\u8bc1\u4ef6\u6709\u6548\u671f\u51fa\u9519\uff1a{}", (Object)validityOfCertificate);
                            }
                        }
                        cacheData.setVerifyRs(verifyRs).setIsRide((String)DataCompletionUtil.castToClass(String.class, data.get("isRide"))).setName((String)DataCompletionUtil.castToClass(String.class, data.get("name"))).setIdCard((String)DataCompletionUtil.castToClass(String.class, data.get("idCard"))).setIdType((String)DataCompletionUtil.castToClass(String.class, resData.get("idType"))).setPhoto((String)DataCompletionUtil.castToClass(String.class, data.get("photo"))).setIdCardStatus((String)DataCompletionUtil.castToClass(String.class, data.get("idCardStatus"))).setCancellationMark((String)DataCompletionUtil.castToClass(String.class, data.get("cancellationMark"))).setStatus((String)DataCompletionUtil.castToClass(String.class, data.get("status"))).setIdCardVerifyRs((String)DataCompletionUtil.castToClass(String.class, data.get("idCardVerifyRs"))).setNameVerifyRs((String)DataCompletionUtil.castToClass(String.class, data.get("nameVerifyRs"))).setSex((String)DataCompletionUtil.castToClass(String.class, data.get("sex"))).setBirthday((String)DataCompletionUtil.castToClass(String.class, data.get("birthday"))).setNation((String)DataCompletionUtil.castToClass(String.class, data.get("nation"))).setRegResidence((String)DataCompletionUtil.castToClass(String.class, data.get("regResidence"))).setAddress((String)DataCompletionUtil.castToClass(String.class, data.get("address"))).setStartDate(now).setEndDate(endDate).setRsCode((String)DataCompletionUtil.castToClass(String.class, resData.get("rsCode"))).setRsMsg((String)DataCompletionUtil.castToClass(String.class, resData.get("rsMsg"))).setBirthday((String)DataCompletionUtil.castToClass(String.class, data.get("birthday"))).setValidityOfCertificate(validityOfCertificate);
                    }
                    cacheDataList.add(cacheData);
                }
                isSuccess = this.apisBusiRealNameVerificationCacheDataService.saveBatch(cacheDataList);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                isSuccess = false;
            }
            if (isSuccess) {
                return true;
            }
            log.warn("\u6279\u91cf\u4fdd\u5b58\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u63a5\u53e3\u7684\u7ed3\u679c\u6570\u636e\u5931\u8d25\uff01");
        } else {
            log.warn("\u6ca1\u6709\u8981\u4fdd\u5b58\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u63a5\u53e3\u7684\u7ed3\u679c\u6570\u636e");
        }
        return false;
    }

    public static <T> T castToClass(Class<T> type, Object value) {
        return (T)DataCompletionUtil.castToClass(type, (Object)value, (boolean)true);
    }

    public static <T> T castToClass(Class<T> type, Object value, boolean isQuietly) {
        if (null == type) {
            return null;
        }
        if (null == value) {
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        if (isQuietly) {
            return null;
        }
        throw new ClassCastException("Cannot cast " + value.getClass().getName() + " to " + type.getName());
    }
}

