/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.publicapiapp.web;

import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.ThirdPartyHead;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.ThirdPartyRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.ThirdPartyResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.thirdParty.AgentInfoDto;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PublicApiController {
    private static final Logger logger = LoggerFactory.getLogger(PublicApiController.class);
    @Autowired
    ApisBusinessService apisBusinessService;

    @RequestMapping(value={"/publicApi/realNameVerify"})
    public ThirdPartyResponse realNameVerify(@RequestBody ThirdPartyRequest request, @RequestHeader(value="userCode") String userCode) {
        StanderResponse resp = null;
        try {
            logger.warn("\u5b9e\u540d\u8ba4\u8bc1\u63a5\u53e3\u5f00\u59cb\uff1a{}", (Object)System.currentTimeMillis());
            logger.warn("\u767b\u5f55\u7528\u6237\uff1a{}", (Object)userCode);
            Date t1 = new Date();
            logger.warn("\u51fa\u5355\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)request));
            StanderRequest standerRequest = StanderRequest.builder().build();
            standerRequest.setHeader(ThirdPartyRequest.initRequestHead((AgentInfoDto)request.getBody().getAgency()));
            standerRequest.getHeader().setUserCode(userCode);
            standerRequest.setThirdPartyRequest(request);
            resp = this.apisBusinessService.execute("realNameVerify", standerRequest);
            logger.warn("\u5b9e\u540d\u8ba4\u8bc1\u63a5\u53e3\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - t1.getTime()));
            logger.warn("\u51fa\u5355\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)resp));
            return resp.getThirdPartyResponse();
        }
        catch (ApisBusinessException e) {
            return ThirdPartyResponse.builder().head(ThirdPartyHead.builder().errorCode(e.getErrorCode()).errorMessage(e.getMessage()).requestId(request.getHead().getRequestId()).serviceName(request.getHead().getServiceName()).build()).build();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ThirdPartyResponse.builder().head(ThirdPartyHead.builder().errorCode(ChannelErrorCodeEnum.ERR_C10006.getKey()).errorMessage(ChannelErrorCodeEnum.ERR_C10006.getValue()).requestId(request.getHead().getRequestId()).serviceName(request.getHead().getServiceName()).build()).build();
        }
    }
}

