/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.commons.rulesengine.service;

import com.jdaz.sinosoftgz.apis.commons.rulesengine.configs.DslLoaderProperties;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.service.DslLoader;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.vo.RuleScript;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class AbstractDslLoader
implements DslLoader {
    public static String SUFFIX_SEPARATOR = ".";
    protected DslLoaderProperties loaderProperties;

    @Override
    public Optional<RuleScript> getScript(String ruleCode) {
        RuleScript script = (RuleScript)DSL_SCRIPT_CACHE.get(ruleCode);
        if (script == null) {
            DSL_SCRIPT_CACHE.clear();
            DSL_SCRIPT_CACHE.putAll(this.reloadAll());
            script = (RuleScript)DSL_SCRIPT_CACHE.get(ruleCode);
        }
        if (script != null) {
            return Optional.of(script);
        }
        return Optional.empty();
    }

    @Override
    public List<String> getAllRuleCode() {
        if (DSL_SCRIPT_CACHE.size() <= 0) {
            DSL_SCRIPT_CACHE.clear();
            DSL_SCRIPT_CACHE.putAll(this.reloadAll());
        }
        return DSL_SCRIPT_CACHE.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Override
    public List<RuleScript> getScript(String ... ruleCodes) {
        if (DSL_SCRIPT_CACHE.size() <= 0) {
            DSL_SCRIPT_CACHE.clear();
            DSL_SCRIPT_CACHE.putAll(this.reloadAll());
        }
        ArrayList<RuleScript> ruleScriptList = new ArrayList<RuleScript>();
        List<String> ruleCodeList = Arrays.asList(ruleCodes);
        for (Map.Entry entry : DSL_SCRIPT_CACHE.entrySet()) {
            if (!ruleCodeList.contains(entry.getKey())) continue;
            ruleScriptList.add((RuleScript)entry.getValue());
        }
        return ruleScriptList;
    }

    public DslLoaderProperties getLoaderProperties() {
        return this.loaderProperties;
    }

    public void setLoaderProperties(DslLoaderProperties loaderProperties) {
        this.loaderProperties = loaderProperties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractDslLoader)) {
            return false;
        }
        AbstractDslLoader other = (AbstractDslLoader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DslLoaderProperties this$loaderProperties = this.getLoaderProperties();
        DslLoaderProperties other$loaderProperties = other.getLoaderProperties();
        return !(this$loaderProperties == null ? other$loaderProperties != null : !((Object)this$loaderProperties).equals(other$loaderProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractDslLoader;
    }

    public int hashCode() {
        int result = 1;
        DslLoaderProperties $loaderProperties = this.getLoaderProperties();
        result = result * 59 + ($loaderProperties == null ? 43 : ((Object)$loaderProperties).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractDslLoader(loaderProperties=" + this.getLoaderProperties() + ")";
    }

    public AbstractDslLoader(DslLoaderProperties loaderProperties) {
        this.loaderProperties = loaderProperties;
    }
}

