import com.jdaz.sinosoftgz.apis.commons.rulesengine.dsl.RuleResult
import com.jdaz.sinosoftgz.apis.commons.rulesengine.dsl.RuleRouteRequest
import com.jdaz.sinosoftgz.apis.commons.rulesengine.vo.RuleResultType

import static com.jdaz.sinosoftgz.apis.commons.rulesengine.dsl.RuleDsl.*

rule {
    version 1
    ruleCode '规则代码，如AgeVerify'
    ruleName '规则名称，如通用年龄校验'
    desc '规则描述：承保接口通用投保人年龄校验规则，投保人年龄须满18周岁'
    // 规则返回数据类型
    resultType RuleResultType.BOOLEAN
    // 消息模板，当返回数据类型为BOOLEAN且返回false时，或其它数据类型时会处理
    // 模板中可以用${}表达式进行插值引用传入参数中的值
    messageTpl '请求数据applicat.age【${applicat.age}】不能小于18周岁'
    // 规则触发路由，非必须，如不指定则默认触发或走规则路由表直接指定
//    ruleCondition { RuleRouteRequest req ->
//        return req.apiCode == "Insured"
//    }
    // 规则执行脚本
    ruleExecute { Map params ->
        def r = params.get("applicat").get("age") >= 18
        return new RuleResult(result: r)
    }
    // 本地测试脚本，写在这个里面
    testScript { rule ->
        RuleRouteRequest req = new RuleRouteRequest(apiCode: "Insured")
        println(rule.ruleCondition(req))
        println(rule.ruleExecute([applicat:[age: 0]]))
        println(rule.ruleExecute([applicat:[age: 21]]))
    }
}
// 测试，放开下面的注释，运行dsl文件：
//        .runTest()