/*
 * Decompiled with CFR 0.152.
 */
package com.jdcloud.sdk.auth.sign;

import com.jdcloud.sdk.client.SdkClientException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;

public enum SigningAlgorithm {
    HmacSHA256;

    private final ThreadLocal<Mac> macReference;

    private SigningAlgorithm() {
        String algorithmName = this.toString();
        this.macReference = new MacThreadLocal(algorithmName);
    }

    public Mac getMac() {
        return this.macReference.get();
    }

    private static class MacThreadLocal
    extends ThreadLocal<Mac> {
        private final String algorithmName;

        MacThreadLocal(String algorithmName) {
            this.algorithmName = algorithmName;
        }

        @Override
        protected Mac initialValue() {
            try {
                return Mac.getInstance(this.algorithmName);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SdkClientException("Unable to fetch Mac instance for Algorithm " + this.algorithmName + e.getMessage(), e);
            }
        }
    }
}

