/*
 * Decompiled with CFR 0.152.
 */
package com.jdcloud.sdk.utils;

import com.google.api.client.http.ByteArrayContent;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jdcloud.sdk.JdcloudSdkException;
import com.jdcloud.sdk.annotation.BodyParameter;
import com.jdcloud.sdk.http.ContentType;
import com.jdcloud.sdk.http.SdkHttpMethod;
import com.jdcloud.sdk.service.JdcloudRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class ConvertUtils {
    private static final Gson GSON = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss").create();

    public static <R extends JdcloudRequest> ByteArrayContent formatRequestBody(String contentType, R request, String method) throws JAXBException, IOException {
        ByteArrayContent bodyContent = null;
        Object body = ConvertUtils.content(request, method);
        if (body == null) {
            return bodyContent;
        }
        if (ContentType.APPLICATION_XML.toString().equals(contentType)) {
            bodyContent = new ByteArrayContent(contentType, ConvertUtils.beanToXmlByte(body));
        } else {
            String content = GSON.toJson(body);
            bodyContent = ByteArrayContent.fromString((String)contentType, (String)content);
        }
        return bodyContent;
    }

    private static Object content(JdcloudRequest request, String method) {
        if (request == null) {
            return null;
        }
        if (SdkHttpMethod.DELETE.name().equalsIgnoreCase(method) || SdkHttpMethod.GET.name().equalsIgnoreCase(method) || SdkHttpMethod.HEAD.name().equalsIgnoreCase(method)) {
            return null;
        }
        return ConvertUtils.getBodyParameters(request);
    }

    private static Object getBodyParameters(Object request) {
        Object bodyContent = null;
        try {
            Field[] array;
            for (Field field : array = request.getClass().getDeclaredFields()) {
                if (!field.isAnnotationPresent(BodyParameter.class)) continue;
                field.setAccessible(true);
                return field.get(request);
            }
            if (bodyContent == null) {
                bodyContent = request;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JdcloudSdkException(e);
        }
        return bodyContent;
    }

    public static <R> String beanToXml(R request) throws JAXBException, UnsupportedEncodingException {
        return new String(ConvertUtils.beanToXmlByte(request), "UTF-8");
    }

    public static Object xmlToBean(InputStream is, Class<?> load) throws JAXBException, IOException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{load});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        Object object = unmarshaller.unmarshal(is);
        return object;
    }

    private static <R> byte[] beanToXmlByte(R request) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{request.getClass()});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        marshaller.marshal(request, (OutputStream)baos);
        return baos.toByteArray();
    }
}

