/*
 * Decompiled with CFR 0.152.
 */
package com.jdcloud.sdk.utils;

import java.net.InetAddress;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HostNameUtils {
    private static final Pattern S3_ENDPOINT_PATTERN = Pattern.compile("^(?:.+\\.)?s3[.-]([a-z0-9-]+)$");
    private static final Pattern STANDARD_CLOUDSEARCH_ENDPOINT_PATTERN = Pattern.compile("^(?:.+\\.)?([a-z0-9-]+)\\.cloudsearch$");
    private static final Pattern EXTENDED_CLOUDSEARCH_ENDPOINT_PATTERN = Pattern.compile("^(?:.+\\.)?([a-z0-9-]+)\\.cloudsearch\\..+");

    @Deprecated
    public static String parseRegionName(URI endpoint) {
        return HostNameUtils.parseRegion(endpoint.getHost(), null);
    }

    @Deprecated
    public static String parseRegionName(String host, String serviceHint) {
        String region = HostNameUtils.parseRegion(host, serviceHint);
        return region == null ? "us-east-1" : region;
    }

    public static String parseRegion(String host, String serviceHint) {
        if (host == null) {
            throw new IllegalArgumentException("hostname cannot be null");
        }
        String regionNameInInternalConfig = HostNameUtils.parseRegionNameByInternalConfig(host);
        if (regionNameInInternalConfig != null) {
            return regionNameInInternalConfig;
        }
        if (serviceHint != null) {
            Matcher matcher;
            if ("cloudsearch".equals(serviceHint) && !host.startsWith("cloudsearch.") && (matcher = EXTENDED_CLOUDSEARCH_ENDPOINT_PATTERN.matcher(host)).matches()) {
                return matcher.group(1);
            }
            Pattern pattern = Pattern.compile("^(?:.+\\.)?" + Pattern.quote(serviceHint) + "[.-]([a-z0-9-]+)\\.");
            Matcher matcher2 = pattern.matcher(host);
            if (matcher2.find()) {
                return matcher2.group(1);
            }
        }
        return "cn-north-1";
    }

    private static String parseRegionNameByInternalConfig(String host) {
        return null;
    }

    public static String localHostName() {
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            return localhost.getHostName();
        }
        catch (Exception e) {
            return "localhost";
        }
    }
}

