/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.util;

import java.text.Normalizer;
import org.apache.commons.mail.HtmlEmail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailUtils {
    private static final Logger logger = LoggerFactory.getLogger(EmailUtils.class);
    public static final int SEND_EMAIL_OK = 0;
    public static final int SEND_EMAIL_ERROR = 1;
    public static final int SEND_EMAIL_INVALID_ADDRESSES = 2;

    public static int sendEmail(HtmlEmail htmlEmail, String toAddress, String subject, String content) {
        return EmailUtils.sendEmail(htmlEmail, toAddress, subject, content, false);
    }

    public static int sendEmail(HtmlEmail htmlEmail, String toAddress, String subject, String content, boolean sslOnConnect) {
        try {
            logger.info(Normalizer.normalize(String.format("\u53d1\u9001\u90ae\u7bb1\u5730\u5740:%s,\u6d88\u606f\u5185\u5bb9:%s", toAddress, content), Normalizer.Form.NFKD));
            htmlEmail.setSSLOnConnect(sslOnConnect);
            htmlEmail.addTo(toAddress).setSubject(subject).setMsg(content).send();
            return 0;
        }
        catch (Exception e) {
            String errorMsg = e.getCause().getMessage();
            logger.error(Normalizer.normalize(String.format("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25:%s", errorMsg), Normalizer.Form.NFKD));
            String invalidMsg = "Invalid Addresses";
            if (invalidMsg.equals(errorMsg)) {
                return 2;
            }
            return 1;
        }
    }
}

