/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.util;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class PayUtil {
    public static final String[] HEX_DIGITS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    public static final String CURRENCY_FEN_REGEX = "\\-?[0-9]+";
    private static final String ALGORITHM = "AES";
    private static final String ALGORITHM_MODE_PADDING = "AES/ECB/PKCS5Padding";
    public static final String ENCODE_TYPE = "MD5";
    public static final String CHARTSET = "utf-8";

    public static String generateTxMapSN(Map<String, String> param, String uri, String sk, String method) throws UnsupportedEncodingException {
        String basicString = uri;
        if ("POST".equals(method)) {
            PayUtil.sortByMapKey(param, true);
        }
        basicString = basicString + "?" + URLDecoder.decode(PayUtil.joinString(param), CHARTSET);
        return PayUtil.md5Encode(URLDecoder.decode(basicString + sk, CHARTSET));
    }

    public static Map<String, String> paraFilter(Map<String, String> sArray) {
        HashMap<String, String> result = new HashMap<String, String>(10);
        if (sArray == null || sArray.size() <= 0) {
            return result;
        }
        for (String key : sArray.keySet()) {
            String value = sArray.get(key);
            if (value == null || value.equals("") || key.equalsIgnoreCase("sign") || key.equalsIgnoreCase("sign_type")) continue;
            result.put(key, value);
        }
        return result;
    }

    public static Map<String, String> sortByMapKey(Map<String, String> param, boolean isASC) {
        LinkedHashMap<String, String> finalMap = new LinkedHashMap<String, String>();
        param.entrySet().stream().sorted(isASC ? Map.Entry.comparingByKey() : Map.Entry.comparingByKey().reversed()).forEachOrdered(e -> {
            String cfr_ignored_0 = (String)finalMap.put((String)e.getKey(), (String)e.getValue());
        });
        return finalMap;
    }

    public static String joinString(Map<String, String> params) {
        StringBuffer sbstr = new StringBuffer("");
        for (Map.Entry<String, String> entry : params.entrySet()) {
            sbstr.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        if (StringUtils.isNotBlank((CharSequence)sbstr)) {
            return sbstr.substring(0, sbstr.length() - 1);
        }
        return sbstr.toString();
    }

    public static byte[] getContentBytes(String content, String charset) {
        if (charset == null || "".equals(charset)) {
            return content.getBytes();
        }
        try {
            return content.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("MD5\u7b7e\u540d\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef,\u6307\u5b9a\u7684\u7f16\u7801\u96c6\u4e0d\u5bf9,\u60a8\u76ee\u524d\u6307\u5b9a\u7684\u7f16\u7801\u96c6\u662f:" + charset);
        }
    }

    public static String byteArrayToHexString(byte[] b) {
        StringBuilder resultSb = new StringBuilder();
        for (byte aB : b) {
            resultSb.append(PayUtil.byteToHexString(aB));
        }
        return resultSb.toString();
    }

    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n = 256 + n;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return HEX_DIGITS[d1] + HEX_DIGITS[d2];
    }

    public static String md5Encode(String origin) {
        String resultString = null;
        try {
            resultString = origin;
            MessageDigest md = MessageDigest.getInstance(ENCODE_TYPE);
            resultString = PayUtil.byteArrayToHexString(md.digest(resultString.getBytes()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultString;
    }

    public static byte[] base64Decode(String encodedText) {
        Base64.Decoder decoder = Base64.getDecoder();
        return decoder.decode(encodedText);
    }

    public static String base64Encode(byte[] data) {
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString(data);
    }

    public static String aesDecryptData(String base64Data, String payKey) throws Exception {
        SecretKeySpec key = new SecretKeySpec(PayUtil.md5Encode(payKey).toLowerCase().getBytes(), ALGORITHM);
        Cipher cipher = Cipher.getInstance(ALGORITHM_MODE_PADDING);
        cipher.init(2, key);
        return new String(cipher.doFinal(PayUtil.base64Decode(base64Data)));
    }

    public static Long changeY2F(BigDecimal amount) {
        String currency = amount.toString();
        int index = currency.indexOf(".");
        int length = currency.length();
        int len2 = 2;
        int len3 = 3;
        Long amLong = 0L;
        amLong = index == -1 ? Long.valueOf(currency + "00") : (length - index >= len3 ? Long.valueOf(currency.substring(0, index + 3).replace(".", "")) : (length - index == len2 ? Long.valueOf(currency.substring(0, index + 2).replace(".", "") + 0) : Long.valueOf(currency.substring(0, index + 1).replace(".", "") + "00")));
        return amLong;
    }

    public static BigDecimal changeF2Y(Long amount) throws Exception {
        if (!String.valueOf(amount).matches(CURRENCY_FEN_REGEX)) {
            throw new Exception("\u91d1\u989d\u683c\u5f0f\u6709\u8bef");
        }
        return BigDecimal.valueOf(amount).divide(new BigDecimal(100));
    }

    public static String createSign(Map<String, String> param, String key) {
        List<Object> list = new ArrayList<String>(param.keySet());
        Object[] ary = list.toArray();
        Arrays.sort(ary);
        list = Arrays.asList(ary);
        String str = "";
        for (int i = 0; i < list.size(); ++i) {
            str = str + list.get(i) + "=" + param.get(list.get(i) + "") + "&";
        }
        str = str + "key=" + key;
        str = PayUtil.md5Encode(str).toUpperCase();
        return str;
    }
}

