/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.util;

import com.jeecms.common.util.SystemCommandUtil;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PortUtil.class);
    private int maxRandomCount = 1000;
    private int randomCount = 0;

    public void resetCount() {
        this.randomCount = 0;
    }

    public boolean isPortAvailable(int port) throws IOException {
        String[] commond = new String[2];
        commond[0] = "netstat";
        String encoding = "gbk";
        SystemCommandUtil systemCommandUtil = new SystemCommandUtil();
        if (systemCommandUtil.isWindows()) {
            commond[1] = "-aon";
        } else {
            commond[1] = "-anp";
            encoding = "utf-8";
        }
        String ret = systemCommandUtil.excuteCmdMultiThread(commond, encoding);
        boolean matches = Pattern.compile("(.+)(" + port + "\\s+)(.*)").matcher(ret).find();
        return !matches;
    }

    private int getRandomPort(int minPort, int maxPort) {
        SecureRandom random = new SecureRandom();
        int s = random.nextInt(maxPort) % (maxPort - minPort + 1) + minPort;
        return s;
    }

    public int getUnAvailableRandomPort(int minPort, int maxPort) {
        if (++this.randomCount > this.maxRandomCount) {
            throw new RuntimeException("\u65e0\u6cd5\u4ece" + minPort + "\u5230" + maxPort + "\u7ed1\u5b9aehcache rmi\u540c\u6b65\u7aef\u53e3\u53f7,\u8bf7\u68c0\u67e5\u7aef\u53e3\u5360\u7528\u60c5\u51b5");
        }
        int randomPort = this.getRandomPort(minPort, maxPort);
        try {
            if (!this.isPortAvailable(randomPort)) {
                return this.getUnAvailableRandomPort(minPort, maxPort);
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            return 0;
        }
        return randomPort;
    }
}

