/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.util;

import com.alibaba.fastjson.JSONObject;
import com.jeecms.common.util.ProcessOldDataService;
import com.jeecms.common.util.ResourceDao;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@ConditionalOnBean(value={ProcessOldDataService.class})
@Component
public class ProcessResourceUtil {
    static Logger logger = LoggerFactory.getLogger(ProcessResourceUtil.class);
    private static final String PATH = logger.getClass().getClassLoader().getResource("").getPath();
    private static final String KEY_INDEX = "index_util_version";
    private static final String KEY_IP = "ip_util_version";
    private static final int CODE = 200;
    @Autowired
    private ResourceDao dao;

    public String getLocalVersion(Integer type) {
        return this.dao.getVersion(type == 1 ? KEY_IP : KEY_INDEX);
    }

    public String getLineVersion(String name) {
        try {
            JSONObject json;
            RestTemplate rest = new RestTemplate();
            String url = "http://api.jeecms.com/MODULE-RES/plus/check?name=" + name;
            ResponseEntity entity = rest.getForEntity(url, JSONObject.class, new Object[0]);
            if (entity != null && (json = (JSONObject)entity.getBody()) != null) {
                return json.getJSONObject("data").getString("version");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void processResource(boolean isFile, String localVersion, String lineVersion, Integer type) {
        String key;
        boolean status = false;
        String string = key = type == 1 ? KEY_IP : KEY_INDEX;
        if (isFile) {
            if (StringUtils.isNotBlank((CharSequence)lineVersion)) {
                if (StringUtils.isNotBlank((CharSequence)localVersion)) {
                    if (!localVersion.equals(lineVersion)) {
                        status = this.operatingFile(true, type);
                        if (status) {
                            this.processValue(key, lineVersion, false);
                        }
                    } else {
                        this.processValue(key, lineVersion, true);
                    }
                } else {
                    status = this.operatingFile(true, type);
                    if (status) {
                        this.processValue(key, lineVersion, false);
                    }
                }
            }
        } else {
            status = this.operatingFile(false, type);
            if (StringUtils.isNotBlank((CharSequence)lineVersion)) {
                if (StringUtils.isNotBlank((CharSequence)localVersion)) {
                    if (status) {
                        if (!localVersion.equals(lineVersion)) {
                            this.processValue(key, lineVersion, false);
                        } else {
                            this.processValue(key, lineVersion, true);
                        }
                    }
                } else if (status) {
                    this.processValue(key, lineVersion, false);
                }
            }
        }
    }

    private void processValue(String key, String lineVersion, boolean isProcess) {
        Integer count = this.dao.getCount(key);
        if (count != null && count > 0) {
            if (count > 1) {
                this.dao.deleteValule(key);
                this.dao.processValue(key, lineVersion, false);
            } else {
                if (isProcess) {
                    return;
                }
                this.dao.processValue(key, lineVersion, true);
            }
        } else {
            this.dao.processValue(key, lineVersion, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean operatingFile(boolean isUpdate, Integer type) {
        String realPath;
        boolean isIp = type == 1;
        String tempZipPath = isIp ? PATH.concat("geolite2/a.zip") : PATH.concat("a.zip");
        String tempUnzipPath = isIp ? PATH.concat("geolite2/a.mmdb") : PATH.concat("ahanlp");
        HttpURLConnection httpConn = null;
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        String backupPath = isIp ? PATH.concat("geolite2/b.mmdb") : PATH.concat("bhanlp");
        File file = new File(tempZipPath);
        bos = new BufferedOutputStream(new FileOutputStream(file));
        String name = isIp ? "GeoLite2-City" : "Hanlp";
        URL urlObj = new URL("http://api.jeecms.com/MODULE-RES/plus/download?name=" + name);
        httpConn = (HttpURLConnection)urlObj.openConnection();
        httpConn.setRequestMethod("GET");
        httpConn.setDoInput(true);
        httpConn.setConnectTimeout(5000);
        httpConn.connect();
        if (httpConn.getResponseCode() == 200) {
            bis = new BufferedInputStream(httpConn.getInputStream());
            int c = 0;
            byte[] buffer = new byte[8192];
            while ((c = bis.read(buffer)) != -1) {
                bos.write(buffer, 0, c);
                bos.flush();
            }
        }
        boolean status = false;
        String string = realPath = isIp ? PATH.concat("geolite2/GeoLite2-City.mmdb") : PATH.concat("hanlp");
        if (isUpdate) {
            String tempUpzipPath = isIp ? tempUnzipPath : PATH.concat("a");
            status = this.upzipFile(file, tempUpzipPath, isIp);
            if (status) {
                file = new File(tempUnzipPath);
                File oldFile = new File(realPath);
                Boolean deleteStatus = oldFile.renameTo(new File(backupPath));
                if (deleteStatus.booleanValue()) {
                    System.gc();
                    boolean updateStatus = file.renameTo(oldFile);
                    File backupFile = new File(backupPath);
                    if (updateStatus) {
                        System.gc();
                        this.delFile(backupFile);
                    } else {
                        backupFile.renameTo(new File(realPath));
                    }
                }
            }
        } else {
            status = this.upzipFile(file, isIp ? realPath : PATH, isIp);
        }
        boolean bl = status;
        try {
            File remoFile3;
            File remoFile2;
            this.closeFlow(null, null, null, bis, bos);
            httpConn.disconnect();
            System.gc();
            File remoFile1 = new File(tempZipPath);
            if (remoFile1.exists()) {
                remoFile1.delete();
            }
            if ((remoFile2 = new File(tempUnzipPath)).exists()) {
                remoFile2.delete();
            }
            if ((remoFile3 = new File(backupPath)).exists()) {
                remoFile3.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
        catch (Exception e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                try {
                    File remoFile3;
                    File remoFile2;
                    this.closeFlow(null, null, null, bis, bos);
                    httpConn.disconnect();
                    System.gc();
                    File remoFile1 = new File(tempZipPath);
                    if (remoFile1.exists()) {
                        remoFile1.delete();
                    }
                    if ((remoFile2 = new File(tempUnzipPath)).exists()) {
                        remoFile2.delete();
                    }
                    if ((remoFile3 = new File(backupPath)).exists()) {
                        remoFile3.delete();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                File remoFile3;
                File remoFile2;
                this.closeFlow(null, null, null, bis, bos);
                httpConn.disconnect();
                System.gc();
                File remoFile1 = new File(tempZipPath);
                if (remoFile1.exists()) {
                    remoFile1.delete();
                }
                if ((remoFile2 = new File(tempUnzipPath)).exists()) {
                    remoFile2.delete();
                }
                if ((remoFile3 = new File(backupPath)).exists()) {
                    remoFile3.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upzipFile(File file, String descDir, boolean isIp) {
        String filePath;
        File parentFile;
        ZipFile zipFile;
        FileOutputStream out;
        InputStream in;
        block8: {
            in = null;
            out = null;
            zipFile = null;
            parentFile = null;
            filePath = descDir;
            if (file.exists()) break block8;
            boolean bl = false;
            this.closeFlow(in, out, zipFile, null, null);
            return bl;
        }
        try {
            zipFile = new ZipFile(file, "UTF-8");
            Enumeration en = zipFile.getEntries();
            while (en.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)en.nextElement();
                String fileName = entry.getName();
                if (entry.isDirectory()) continue;
                filePath = isIp ? descDir : descDir.concat(fileName);
                File newFile = new File(filePath);
                if (!isIp && !(parentFile = newFile.getParentFile()).exists()) {
                    parentFile.mkdirs();
                }
                in = zipFile.getInputStream(entry);
                out = new FileOutputStream(newFile);
                int len = 0;
                byte[] bytes = new byte[1024];
                while ((len = in.read(bytes)) > 0) {
                    ((OutputStream)out).write(bytes, 0, len);
                }
                out.flush();
            }
            boolean bl = true;
            this.closeFlow(in, out, zipFile, null, null);
            return bl;
        }
        catch (IOException e) {
            try {
                boolean bl = false;
                this.closeFlow(in, out, zipFile, null, null);
                return bl;
            }
            catch (Throwable throwable) {
                this.closeFlow(in, out, zipFile, null, null);
                throw throwable;
            }
        }
    }

    private void closeFlow(InputStream in, OutputStream out, ZipFile zipFile, BufferedInputStream bis, BufferedOutputStream bos) {
        try {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
            if (zipFile != null) {
                zipFile.close();
            }
            if (bos != null) {
                bos.close();
            }
            if (bis != null) {
                bis.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean delFile(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                this.delFile(f);
            }
        }
        return file.delete();
    }

    public void deleteTempFile() {
        File tempZipIp;
        File tempZipIndex = new File(PATH.concat("geolite2/a.zip"));
        if (tempZipIndex.exists()) {
            tempZipIndex.delete();
        }
        if ((tempZipIp = new File(PATH.concat("a.zip"))).exists()) {
            tempZipIp.delete();
        }
        File tempIndex = new File(PATH.concat(PATH.concat("ahanlp")));
        this.delFile(tempIndex);
        File tempIp = new File(PATH.concat("geolite2/a.mmdb"));
        if (tempIp.exists()) {
            tempIp.delete();
        }
        File oldErrorIndex = new File(PATH.concat("bhanlp"));
        this.delFile(oldErrorIndex);
        File oldErrorIp = new File(PATH.concat("geolite2/b.mmdb"));
        if (oldErrorIp.exists()) {
            oldErrorIp.delete();
        }
    }
}

