/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.util;

import com.alibaba.fastjson.JSONObject;
import com.jeecms.common.util.GetRequestJsonUtil;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class SignUtil {
    private static final String CSK = "ZHx9TZ2YRD5ArmninMCYm01q8cG15pLL";
    public static final String[] hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    public static String createSign(HttpServletRequest request) {
        Map<String, String> param = SignUtil.getSignMap(request);
        return SignUtil.createSign(param, CSK);
    }

    public static String createSign(Map<String, String> param) {
        return SignUtil.createSign(param, CSK);
    }

    public static Map<String, String> getSignMap(HttpServletRequest request) {
        HashMap<String, String> param = new HashMap<String, String>();
        Enumeration penum = request.getParameterNames();
        while (penum.hasMoreElements()) {
            String pKey = (String)penum.nextElement();
            String value = request.getParameter(pKey);
            if (pKey.equals("sign") || !StringUtils.isNotBlank((CharSequence)value) || pKey.endsWith("]")) continue;
            param.put(pKey, value);
        }
        try {
            JSONObject json = GetRequestJsonUtil.getParamsFromRequestBody(request);
            if (json != null) {
                param.put("json", json.toJSONString());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return param;
    }

    public static String createSign(Map<String, String> param, String key) {
        List<Object> list = new ArrayList<String>(param.keySet());
        Object[] ary = list.toArray();
        Arrays.sort(ary);
        list = Arrays.asList(ary);
        String str = "";
        for (int i = 0; i < list.size(); ++i) {
            str = str + list.get(i) + "=" + param.get(list.get(i) + "") + "&";
        }
        str = str + "key=" + key;
        str = SignUtil.MD5Encode(str, "utf-8").toUpperCase();
        return str;
    }

    public static String MD5Encode(String origin, String charsetName) {
        String resultString = null;
        try {
            resultString = new String(origin);
            MessageDigest md = MessageDigest.getInstance("MD5");
            resultString = StringUtils.isBlank((CharSequence)charsetName) ? SignUtil.byteArrayToHexString(md.digest(resultString.getBytes())) : SignUtil.byteArrayToHexString(md.digest(resultString.getBytes(charsetName)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resultString;
    }

    public static String byteArrayToHexString(byte[] b) {
        StringBuffer resultSb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            resultSb.append(SignUtil.byteToHexString(b[i]));
        }
        return resultSb.toString();
    }

    public static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n += 256;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return hexDigits[d1] + hexDigits[d2];
    }
}

