/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.Scanner;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SystemCommandUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SystemCommandUtil.class);

    public boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName.indexOf("Windows") != -1;
    }

    public static String getCpuIdWindows() {
        String serial = "";
        try (Scanner sc = null;){
            Process process = Runtime.getRuntime().exec(new String[]{"wmic", "cpu", "get", "ProcessorId"});
            process.getOutputStream().close();
            sc = new Scanner(process.getInputStream());
            sc.next();
            serial = sc.next();
        }
        return serial;
    }

    public static String getCpuIdLinux() {
        String result = "";
        String cpuIdCmd = "dmidecode";
        BufferedReader bufferedReader = null;
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(new String[]{"sh", "-c", cpuIdCmd});
            bufferedReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = null;
            int index = -1;
            while ((line = bufferedReader.readLine()) != null) {
                index = line.toLowerCase().indexOf("uuid");
                if (index < 0) continue;
                result = line.substring(index + "uuid".length() + 1).trim();
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result.trim();
    }

    public static String getCpuIdMac() {
        String result = "";
        String cpuIdCmd = "system_profiler SPHardwareDataType";
        BufferedReader bufferedReader = null;
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(new String[]{"sh", "-c", cpuIdCmd});
            bufferedReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = null;
            int index = -1;
            while ((line = bufferedReader.readLine()) != null) {
                index = line.toLowerCase().indexOf("uuid");
                if (index < 0) continue;
                result = line.substring(index + "uuid".length() + 1).trim();
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result.trim();
    }

    public static String getCpuId() {
        String os = SystemCommandUtil.getOsName();
        String cpuId = "";
        String system1 = "WINDOWS";
        String system2 = "LINUX";
        String system3 = "MAC";
        if (os.toUpperCase(Locale.ENGLISH).equals(system1)) {
            cpuId = SystemCommandUtil.getCpuIdWindows();
        } else if (os.toUpperCase(Locale.ENGLISH).equals(system2)) {
            cpuId = SystemCommandUtil.getCpuIdLinux();
        } else if (os.toUpperCase(Locale.ENGLISH).equals(system3)) {
            cpuId = SystemCommandUtil.getCpuIdMac();
        }
        return cpuId;
    }

    public static String getOsName() {
        return System.getProperty("os.name").toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String excuteCmdMultiThread(String[] cmd, String encoding) throws IOException {
        Process p = null;
        try {
            String string;
            p = Runtime.getRuntime().exec(cmd);
            ThreadFactoryBuilder tfb = new ThreadFactoryBuilder();
            ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 2000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), tfb.build());
            executor.execute(new InputStreamRunnable(p.getErrorStream(), "ErrorStream"));
            executor.shutdown();
            String encodingStr = StringUtils.isEmpty((Object)encoding) ? "gbk" : encoding;
            String string2 = string = IOUtils.toString((InputStream)p.getInputStream(), (String)encodingStr);
            return string2;
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
    }

    class InputStreamRunnable
    implements Runnable {
        BufferedReader bReader = null;
        String type = null;

        public InputStreamRunnable(InputStream is, String typeStr) {
            try {
                this.bReader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(is), "UTF-8"));
                this.type = typeStr;
            }
            catch (Exception ex) {
                LOG.error("\u8bfb\u53d6InputStream\u7684\u7ebf\u7a0b\u5f02\u5e38", (Throwable)ex);
            }
        }

        @Override
        public void run() {
            String line = null;
            try {
                while ((line = this.bReader.readLine()) != null) {
                    LOG.error(line);
                }
                this.bReader.close();
            }
            catch (Exception ex) {
                LOG.error("", (Throwable)ex);
            }
        }
    }
}

