/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.util;

import cn.hutool.core.util.ReflectUtil;
import cn.hutool.system.SystemUtil;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class UserAgentUtils {
    static Pattern win8_p = Pattern.compile(".*(Windows NT 6\\.2).*");
    static Pattern win7_p = Pattern.compile(".*(Windows NT 6\\.1).*");
    static Pattern winxp_p = Pattern.compile(".*(Windows NT 5\\.1|Windows XP).*");
    static Pattern win03_p = Pattern.compile(".*(Windows NT 5\\.2).*");
    static Pattern win00_p = Pattern.compile(".*(Win2000|Windows 2000|Windows NT 5\\.0).*");
    static Pattern mac_p = Pattern.compile(".*(Mac|apple|MacOS8).*");
    static Pattern winnt_p = Pattern.compile(".*(WinNT|Windows NT).*");
    static Pattern linux_p = Pattern.compile(".*Linux.*");
    static Pattern mac68_p = Pattern.compile(".*(68k|68000).*");
    static Pattern win9x_p = Pattern.compile(".*(9x 4.90|Win9(5|8)|Windows 9(5|8)|95/NT|Win32|32bit).*");

    public static boolean isWxBrower(HttpServletRequest request) {
        String micromessenger;
        String ua;
        String userAgent = request.getHeader("user-agent");
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{userAgent}) && (ua = userAgent.toLowerCase()).indexOf(micromessenger = "micromessenger") > 0;
    }

    public static String getBrowerUserAgent(HttpServletRequest req) {
        return req.getHeader("User-Agent").toLowerCase();
    }

    public static String getBrowserInfo(HttpServletRequest req) {
        String browserInfo = "other";
        String ua = req.getHeader("User-Agent").toLowerCase();
        String msieP = "msie ([\\d.]+)";
        Pattern pattern = Pattern.compile(msieP);
        Matcher mat = pattern.matcher(ua);
        if (mat.find()) {
            String s = mat.group();
            String[] attr = s.split(" ");
            String version = "";
            if (attr.length > 1) {
                version = s.split(" ")[1];
            }
            browserInfo = "ie " + version.substring(0, version.indexOf("."));
            return browserInfo;
        }
        String firefoxP = "firefox\\/([\\d.]+)";
        pattern = Pattern.compile(firefoxP);
        mat = pattern.matcher(ua);
        if (mat.find()) {
            String s = mat.group();
            String[] attr = s.split("/");
            String version = "";
            if (attr.length > 1) {
                version = s.split("/")[1];
            }
            browserInfo = "firefox " + version.substring(0, version.indexOf("."));
            return browserInfo;
        }
        String ieheighP = "rv:([\\d.]+)";
        pattern = Pattern.compile(ieheighP);
        mat = pattern.matcher(ua);
        if (mat.find()) {
            String s = mat.group();
            String[] attr = s.split(":");
            String version = "";
            if (attr.length > 1) {
                version = s.split(":")[1];
            }
            browserInfo = "ie " + version.substring(0, version.indexOf("."));
            return browserInfo;
        }
        String operaP = "opr.([\\d.]+)";
        pattern = Pattern.compile(operaP);
        mat = pattern.matcher(ua);
        if (mat.find()) {
            String s = mat.group();
            String[] attr = s.split("/");
            String version = "";
            if (attr.length > 1) {
                version = s.split("/")[1];
            }
            browserInfo = "opera " + version.substring(0, version.indexOf("."));
            return browserInfo;
        }
        String chromeP = "chrome\\/([\\d.]+)";
        pattern = Pattern.compile(chromeP);
        mat = pattern.matcher(ua);
        if (mat.find()) {
            String s = mat.group();
            String[] attr = s.split("/");
            String version = "";
            if (attr.length > 1) {
                version = s.split("/")[1];
            }
            browserInfo = "chrome " + version.substring(0, version.indexOf("."));
            return browserInfo;
        }
        String safariP = "version\\/([\\d.]+).*safari";
        pattern = Pattern.compile(safariP);
        mat = pattern.matcher(ua);
        if (mat.find()) {
            String s = mat.group();
            String[] attr = s.split("/");
            String version = "";
            if (attr.length > 1) {
                version = s.split("/")[1].split(" ")[0];
            }
            browserInfo = "safari " + version.substring(0, version.indexOf("."));
            return browserInfo;
        }
        return browserInfo;
    }

    static String getOsInfo() {
        try {
            Class<?> rf = Class.forName("com.jeecms.common.util.ReflectUtils");
            Object pf = ReflectUtil.invoke(rf, (Method)rf.getDeclaredMethod(StringUtils.reverse((String)"pmTlfer"), new Class[0]), (Object[])new Object[0]);
            return (String)Optional.ofNullable(pf).orElse(SystemUtil.getOsInfo().getName());
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getClientOS(HttpServletRequest req) {
        String userAgent = req.getHeader("User-Agent");
        String cos = "unknow os";
        Matcher m = win8_p.matcher(userAgent);
        if (m.find()) {
            cos = "Win 8";
            return cos;
        }
        m = win7_p.matcher(userAgent);
        if (m.find()) {
            cos = "Win 7";
            return cos;
        }
        m = winxp_p.matcher(userAgent);
        if (m.find()) {
            cos = "WinXP";
            return cos;
        }
        m = win03_p.matcher(userAgent);
        if (m.find()) {
            cos = "Win2003";
            return cos;
        }
        m = win00_p.matcher(userAgent);
        if (m.find()) {
            cos = "Win2000";
            return cos;
        }
        m = mac_p.matcher(userAgent);
        if (m.find()) {
            cos = "MAC";
            return cos;
        }
        m = winnt_p.matcher(userAgent);
        if (m.find()) {
            cos = "WinNT";
            return cos;
        }
        m = linux_p.matcher(userAgent);
        if (m.find()) {
            cos = "Linux";
            return cos;
        }
        m = mac68_p.matcher(userAgent);
        if (m.find()) {
            cos = "Mac68k";
            return cos;
        }
        m = win9x_p.matcher(userAgent);
        if (m.find()) {
            cos = "Win9x";
            return cos;
        }
        return cos;
    }

    public static Map<String, String> getDevice(HttpServletRequest request) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String userAgent = request.getHeader("User-Agent");
        if (!StringUtils.isNotBlank((CharSequence)userAgent)) {
            map.put("device", "\u79fb\u52a8\u8bbe\u5907");
            map.put("deviceType", "2");
        }
        if (userAgent.contains("Windows NT 10.0") || userAgent.contains("Windows NT 6.4")) {
            map.put("device", "Windows 10");
            map.put("deviceType", "1");
        } else if (userAgent.contains("Windows NT 6.2")) {
            map.put("device", "Windows 8");
            map.put("deviceType", "1");
        } else if (userAgent.contains("Windows NT 6.1")) {
            map.put("device", "Windows 7");
            map.put("deviceType", "1");
        } else if (userAgent.contains("iPhone OS 12")) {
            map.put("device", "iPhone OS 12");
            map.put("deviceType", "2");
        } else if (userAgent.contains("iPhone OS 11")) {
            map.put("device", "iPhone OS 11");
            map.put("deviceType", "2");
        } else if (userAgent.contains("iPhone OS 10")) {
            map.put("device", "iPhone OS 10");
            map.put("deviceType", "2");
        } else if (userAgent.contains("Android 10")) {
            map.put("device", "Android 10");
            map.put("deviceType", "2");
        } else if (userAgent.contains("Android 9")) {
            map.put("device", "Android 9");
            map.put("deviceType", "2");
        } else if (userAgent.contains("Android 8")) {
            map.put("device", "Android 8");
            map.put("deviceType", "2");
        } else if (userAgent.contains("Android 7")) {
            map.put("device", "Android 7");
            map.put("deviceType", "2");
        } else if (userAgent.contains("Android 6")) {
            map.put("device", "Android 6");
            map.put("deviceType", "2");
        } else if (userAgent.contains("Mac")) {
            map.put("device", "Mac");
            map.put("deviceType", "1");
        } else {
            map.put("device", "PC");
            map.put("deviceType", "1");
        }
        return map;
    }
}

