/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.util.mediautil;

import cn.hutool.core.util.ReflectUtil;
import com.jeecms.common.util.mediautil.ImageMetaInfo;
import com.jeecms.common.util.mediautil.MusicMetaInfo;
import com.jeecms.common.util.mediautil.VideoMetaInfo;
import com.jeecms.common.util.mediautil.enums.CrfValueEnum;
import com.jeecms.common.util.mediautil.enums.PresetValueEnum;
import com.jeecms.common.util.mediautil.gif.AnimatedGifEncoder;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class MediaUtil {
    private static final Logger log = LoggerFactory.getLogger(MediaUtil.class);
    public static final String[] VIDEO_TYPE = new String[]{"MP4", "WMV", "AVI"};
    public static final String[] IMAGE_TYPE = new String[]{"JPG", "JPEG", "PNG", "GIF"};
    public static final String[] AUDIO_TYPE = new String[]{"AAC"};
    public static final String[] AUDIO_SUFFIX = new String[]{"mp3", "wav", "aif", "au", "ram", "wma", "mmf", "amr", "flac", "aac"};
    public static final String[] VIDEO_SUFFIX = new String[]{"mp4", "m4v", "mov", "qt", "avi", "flv", "wmv", "asf", "mpeg", "mpg", "vob", "rmvb", "rm", "ts", "3gp", "asf", "wmv", "mkv", "dat"};
    private static final long DEFAULT_TIME = 10000L;
    private static final int DEFAULT_WIDTH = 320;
    private static final int DEFAULT_TIME_LENGTH = 10;
    private static final int DEFAULT_GIF_PLAYTIME = 110;
    private static final int MIN_FRAME_WIDTH_HEIGHT = 21;
    private static final int HORIZONTAL_ANGLE_CLOCKWISE = 90;
    private static final int HORIZONTAL_ANGLE_COUNTERCLOCKWISE = 270;
    private static final int DEFAULT_ZIP_WIDTH = 640;
    private static final int DEFAULT_ZIP_HEIGHT = 640;
    private static String FFMPEG_PATH = "D:\\ffmpeg\\bin\\ffmpeg.exe";
    private static Pattern durationPattern;
    private static Pattern rotatePattern;
    private static Pattern videoStreamPattern;
    private static Pattern musicStreamPattern;

    public static String getFFmpegPath() {
        return FFMPEG_PATH;
    }

    public static boolean setFFmpegPath(String ffmpeg_path) {
        if (StringUtils.isBlank((CharSequence)ffmpeg_path)) {
            log.error("--- \u8bbe\u7f6effmpeg\u6267\u884c\u8def\u5f84\u5931\u8d25\uff0c\u56e0\u4e3a\u4f20\u5165\u7684ffmpeg\u53ef\u6267\u884c\u7a0b\u5e8f\u8def\u5f84\u4e3a\u7a7a\uff01 ---");
            return false;
        }
        File ffmpegFile = new File(ffmpeg_path);
        if (!ffmpegFile.exists()) {
            log.error("--- \u8bbe\u7f6effmpeg\u6267\u884c\u8def\u5f84\u5931\u8d25\uff0c\u56e0\u4e3a\u4f20\u5165\u7684ffmpeg\u53ef\u6267\u884c\u7a0b\u5e8f\u8def\u5f84\u4e0b\u7684ffmpeg\u6587\u4ef6\u4e0d\u5b58\u5728\uff01 ---");
            return false;
        }
        FFMPEG_PATH = ffmpeg_path;
        log.info("--- \u8bbe\u7f6effmpeg\u6267\u884c\u8def\u5f84\u6210\u529f --- \u5f53\u524dffmpeg\u53ef\u6267\u884c\u7a0b\u5e8f\u8def\u5f84\u4e3a\uff1a " + ffmpeg_path);
        return true;
    }

    public static boolean isRun(String ffmpegPath) {
        if (StringUtils.isBlank((CharSequence)ffmpegPath)) {
            return false;
        }
        File ffmpegFile = new File(ffmpegPath);
        return ffmpegFile.exists();
    }

    public static boolean isExecutable() {
        File ffmpegFile = new File(FFMPEG_PATH);
        if (!ffmpegFile.exists()) {
            log.error("--- \u5de5\u4f5c\u72b6\u6001\u5f02\u5e38\uff0c\u56e0\u4e3a\u4f20\u5165\u7684ffmpeg\u53ef\u6267\u884c\u7a0b\u5e8f\u8def\u5f84\u4e0b\u7684ffmpeg\u6587\u4ef6\u4e0d\u5b58\u5728\uff01 ---");
            return false;
        }
        ArrayList<String> cmds = new ArrayList<String>(1);
        cmds.add("-version");
        String ffmpegVersionStr = MediaUtil.executeCommand(cmds);
        if (StringUtils.isBlank((CharSequence)ffmpegVersionStr)) {
            log.error("--- \u5de5\u4f5c\u72b6\u6001\u5f02\u5e38\uff0c\u56e0\u4e3affmpeg\u547d\u4ee4\u6267\u884c\u5931\u8d25\uff01 ---");
            return false;
        }
        log.info("--- \u5de5\u4f5c\u72b6\u6001\u6b63\u5e38 ---");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeCommand(List<String> commonds) {
        if (CollectionUtils.isEmpty(commonds)) {
            log.error("--- \u6307\u4ee4\u6267\u884c\u5931\u8d25\uff0c\u56e0\u4e3a\u8981\u6267\u884c\u7684FFmpeg\u6307\u4ee4\u4e3a\u7a7a\uff01 ---");
            return null;
        }
        LinkedList<String> ffmpegCmds = new LinkedList<String>(commonds);
        ffmpegCmds.addFirst(FFMPEG_PATH);
        log.info("--- \u5f85\u6267\u884c\u7684FFmpeg\u6307\u4ee4\u4e3a\uff1a---" + ffmpegCmds);
        Runtime runtime = Runtime.getRuntime();
        Process ffmpeg = null;
        try {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            ReflectUtil.invoke((Object)builder, (String)"command", (Object[])new Object[]{ffmpegCmds});
            ffmpeg = builder.start();
            log.info("--- \u5f00\u59cb\u6267\u884cFFmpeg\u6307\u4ee4\uff1a--- \u6267\u884c\u7ebf\u7a0b\u540d\uff1a" + builder.toString());
            BufferedReader br = new BufferedReader(new InputStreamReader(ffmpeg.getErrorStream()));
            StringBuilder stringBuilder = new StringBuilder();
            String line = "";
            while ((line = br.readLine()) != null) {
                stringBuilder.append(line);
            }
            br.close();
            ffmpeg.waitFor();
            String cmdStr = Arrays.toString(ffmpegCmds.toArray()).replace(",", "");
            String resultStr = StringUtils.isBlank((CharSequence)stringBuilder.toString()) ? "\u3010\u5f02\u5e38\u3011" : "\u6b63\u5e38";
            log.info("--- \u5df2\u6267\u884c\u7684FFmepg\u547d\u4ee4\uff1a ---" + cmdStr + " \u5df2\u6267\u884c\u5b8c\u6bd5,\u6267\u884c\u7ed3\u679c\uff1a " + resultStr);
            String string = stringBuilder.toString();
            if (null != ffmpeg) {
                ProcessKiller ffmpegKiller = new ProcessKiller(ffmpeg);
                runtime.addShutdownHook(ffmpegKiller);
            }
            return string;
        }
        catch (Exception e) {
            try {
                log.error("--- FFmpeg\u547d\u4ee4\u6267\u884c\u51fa\u9519\uff01 --- \u51fa\u9519\u4fe1\u606f\uff1a " + e.getMessage());
                String string = null;
                if (null != ffmpeg) {
                    ProcessKiller ffmpegKiller = new ProcessKiller(ffmpeg);
                    runtime.addShutdownHook(ffmpegKiller);
                }
                return string;
            }
            catch (Throwable throwable) {
                if (null != ffmpeg) {
                    ProcessKiller ffmpegKiller = new ProcessKiller(ffmpeg);
                    runtime.addShutdownHook(ffmpegKiller);
                }
                throw throwable;
            }
        }
    }

    public static File zipAndConvertVideoToMp4(File fileInput, File fileOutput) {
        VideoMetaInfo videoMetaInfo = MediaUtil.getVideoMetaInfo(fileInput);
        Integer width = videoMetaInfo.getWidth();
        Integer height = videoMetaInfo.getHeight();
        if (width > 640) {
            height = 640 * height / width;
            height = height & 0xFFFFFFFE;
            width = 640;
        } else if (height > 640) {
            width = 640 * width / height;
            width = width & 0xFFFFFFFE;
            height = 640;
        }
        if (videoMetaInfo.getRotate() == 90 || videoMetaInfo.getRotate() == 270) {
            height = height ^ width;
            width = height ^ width;
            height = height ^ width;
        }
        MediaUtil.convertVideo(fileInput, fileOutput, true, CrfValueEnum.MEDIUM_QUALITY, PresetValueEnum.MEDIUM_ZIP_SPEED, width, height);
        return fileOutput;
    }

    public static void convertVideo(File fileInput, File fileOutPut, boolean withAudio, CrfValueEnum crf, PresetValueEnum preset, Integer width, Integer height) {
        String format;
        if (null == fileInput || !fileInput.exists()) {
            throw new RuntimeException("\u6e90\u89c6\u9891\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6e90\u89c6\u9891\u8def\u5f84");
        }
        if (null == fileOutPut) {
            throw new RuntimeException("\u8f6c\u6362\u540e\u7684\u89c6\u9891\u8def\u5f84\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8f6c\u6362\u540e\u7684\u89c6\u9891\u5b58\u653e\u8def\u5f84\u662f\u5426\u6b63\u786e");
        }
        if (!fileOutPut.exists()) {
            try {
                fileOutPut.createNewFile();
            }
            catch (IOException e) {
                log.error("\u89c6\u9891\u8f6c\u6362\u65f6\u65b0\u5efa\u8f93\u51fa\u6587\u4ef6\u5931\u8d25");
            }
        }
        if (!MediaUtil.isLegalFormat(format = MediaUtil.getFormat(fileInput), VIDEO_TYPE)) {
            throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790\u7684\u89c6\u9891\u683c\u5f0f\uff1a" + format);
        }
        ArrayList<String> commond = new ArrayList<String>();
        commond.add("-i");
        commond.add(fileInput.getAbsolutePath());
        if (!withAudio) {
            commond.add("-an");
        }
        if (null != width && width > 0 && null != height && height > 0) {
            commond.add("-s");
            String resolution = width.toString() + "x" + height.toString();
            commond.add(resolution);
        }
        commond.add("-vcodec");
        commond.add("libx264");
        commond.add("-preset");
        commond.add(preset.getPresetValue());
        commond.add("-crf");
        commond.add(crf.getCode().toString());
        commond.add("-movflags");
        commond.add("faststart");
        commond.add("-r");
        commond.add("15");
        commond.add("-b:v");
        commond.add("300k");
        commond.add("-y");
        commond.add(fileOutPut.getAbsolutePath());
        MediaUtil.executeCommand(commond);
    }

    public static void cutVideoFrame(File videoFile, File fileOutPut) {
        MediaUtil.cutVideoFrame(videoFile, fileOutPut, 10000L);
    }

    public static void cutVideoFrame(File videoFile, File fileOutPut, long time) {
        MediaUtil.cutVideoFrame(videoFile, fileOutPut, time, 320);
    }

    public static void cutVideoFrame(File videoFile, File fileOutPut, long time, int width) {
        if (null == videoFile || !videoFile.exists()) {
            throw new RuntimeException("\u6e90\u89c6\u9891\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6e90\u89c6\u9891\u8def\u5f84");
        }
        if (null == fileOutPut) {
            throw new RuntimeException("\u8f6c\u6362\u540e\u7684\u89c6\u9891\u8def\u5f84\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8f6c\u6362\u540e\u7684\u89c6\u9891\u5b58\u653e\u8def\u5f84\u662f\u5426\u6b63\u786e");
        }
        VideoMetaInfo info = MediaUtil.getVideoMetaInfo(videoFile);
        if (null == info) {
            log.error("--- \u672a\u80fd\u89e3\u6790\u6e90\u89c6\u9891\u4fe1\u606f\uff0c\u89c6\u9891\u5e27\u62bd\u53d6\u64cd\u4f5c\u5931\u8d25 --- \u6e90\u89c6\u9891\uff1a " + videoFile);
            return;
        }
        int height = width * info.getHeight() / info.getWidth();
        MediaUtil.cutVideoFrame(videoFile, fileOutPut, time, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cutVideoFrame(File videoFile, File fileOutPut, long time, int width, int height) {
        if (null == videoFile || !videoFile.exists()) {
            throw new RuntimeException("\u6e90\u89c6\u9891\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6e90\u89c6\u9891\u8def\u5f84");
        }
        if (null == fileOutPut) {
            throw new RuntimeException("\u8f6c\u6362\u540e\u7684\u89c6\u9891\u8def\u5f84\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8f6c\u6362\u540e\u7684\u89c6\u9891\u5b58\u653e\u8def\u5f84\u662f\u5426\u6b63\u786e");
        }
        String format = MediaUtil.getFormat(fileOutPut);
        if (!MediaUtil.isLegalFormat(format, IMAGE_TYPE)) {
            throw new RuntimeException("\u65e0\u6cd5\u751f\u6210\u6307\u5b9a\u683c\u5f0f\u7684\u5e27\u56fe\u7247\uff1a" + format);
        }
        String fileOutPutPath = fileOutPut.getAbsolutePath();
        if (!"GIF".equals(StringUtils.upperCase((String)format))) {
            MediaUtil.cutVideoFrame(videoFile, fileOutPutPath, time, width, height, 1, false);
        } else {
            String path = fileOutPut.getParent();
            String name = fileOutPut.getName();
            String tempPath = path + File.separator + System.currentTimeMillis() + "_" + name.substring(0, name.indexOf("."));
            File file = new File(tempPath);
            if (!file.exists()) {
                file.mkdir();
            }
            try {
                MediaUtil.cutVideoFrame(videoFile, tempPath, time, width, height, 10, true);
                String[] images = file.list();
                for (int i = 0; i < images.length; ++i) {
                    images[i] = tempPath + File.separator + images[i];
                }
                MediaUtil.createGifImage(images, fileOutPut.getAbsolutePath(), 110);
            }
            catch (Exception e) {
                log.error("--- \u622a\u53d6\u89c6\u9891\u5e27\u64cd\u4f5c\u51fa\u9519 --- \u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
            }
            finally {
                String[] images = file.list();
                for (int i = 0; i < images.length; ++i) {
                    File fileDelete = new File(tempPath + File.separator + images[i]);
                    fileDelete.delete();
                }
                file.delete();
            }
        }
    }

    private static void cutVideoFrame(File videoFile, String path, long time, Integer width, Integer height, int timeLength, boolean isContinuty) {
        if (videoFile == null || !videoFile.exists()) {
            throw new RuntimeException("\u6e90\u89c6\u9891\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u6e90\u89c6\u9891\u8def\u5f84\uff1a ");
        }
        if (null == path) {
            throw new RuntimeException("\u8f6c\u6362\u540e\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8f6c\u6362\u540e\u7684\u6587\u4ef6\u5b58\u653e\u8def\u5f84\u662f\u5426\u6b63\u786e");
        }
        VideoMetaInfo info = MediaUtil.getVideoMetaInfo(videoFile);
        if (null == info) {
            throw new RuntimeException("\u672a\u89e3\u6790\u5230\u89c6\u9891\u4fe1\u606f");
        }
        if (time + (long)timeLength > info.getDuration()) {
            throw new RuntimeException("\u5f00\u59cb\u622a\u53d6\u89c6\u9891\u5e27\u7684\u65f6\u95f4\u70b9\u4e0d\u5408\u6cd5\uff1a" + MediaUtil.formatTimes(time) + "\uff0c\u56e0\u4e3a\u622a\u53d6\u65f6\u95f4\u70b9\u665a\u4e8e\u89c6\u9891\u7684\u6700\u540e\u65f6\u95f4\u70b9");
        }
        try {
            ArrayList<String> commond = new ArrayList<String>();
            commond.add("-i");
            commond.add(videoFile.getAbsolutePath());
            commond.add("-ss");
            commond.add(MediaUtil.formatTimes(time));
            if (isContinuty) {
                commond.add("-t");
                commond.add(timeLength + "");
            } else {
                commond.add("-y");
                commond.add("-vframes");
                commond.add("1");
            }
            commond.add("-an");
            commond.add("-f");
            commond.add("image2");
            if (isContinuty) {
                commond.add("-r");
                commond.add("3");
            }
            if (width != null && height != null) {
                if (width < 21 || height < 21) {
                    throw new RuntimeException("\u622a\u53d6\u7684\u89c6\u9891\u5e27\u56fe\u7247\u7684\u5bbd\u5ea6\u6216\u9ad8\u5ea6\u4e0d\u5408\u6cd5\uff0c\u5bbd\u9ad8\u503c\u5fc5\u987b\u5927\u4e8e20");
                }
                commond.add("-s");
                commond.add(width + "*" + height);
            }
            if (isContinuty) {
                commond.add(path + File.separator + "foo-%03d.jpeg");
            } else {
                commond.add(path);
            }
            MediaUtil.executeCommand(commond);
        }
        catch (Exception e) {
            log.error("--- \u89c6\u9891\u5e27\u62bd\u53d6\u8fc7\u7a0b\u51fa\u9519 --- \u9519\u8bef\u4fe1\u606f\uff1a " + e.getMessage());
        }
    }

    public static void cutVideo(File videoFile, File outputFile, long startTime, int timeLength) {
        if (videoFile == null || !videoFile.exists()) {
            throw new RuntimeException("\u89c6\u9891\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a");
        }
        if (null == outputFile) {
            throw new RuntimeException("\u8f6c\u6362\u540e\u7684\u89c6\u9891\u8def\u5f84\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8f6c\u6362\u540e\u7684\u89c6\u9891\u5b58\u653e\u8def\u5f84\u662f\u5426\u6b63\u786e");
        }
        VideoMetaInfo info = MediaUtil.getVideoMetaInfo(videoFile);
        if (null == info) {
            throw new RuntimeException("\u672a\u89e3\u6790\u5230\u89c6\u9891\u4fe1\u606f");
        }
        if (startTime + (long)timeLength > info.getDuration()) {
            throw new RuntimeException("\u622a\u53d6\u65f6\u95f4\u4e0d\u5408\u6cd5\uff1a" + MediaUtil.formatTimes(startTime) + "\uff0c\u56e0\u4e3a\u622a\u53d6\u65f6\u95f4\u5927\u4e8e\u89c6\u9891\u7684\u65f6\u957f");
        }
        try {
            if (!outputFile.exists()) {
                outputFile.createNewFile();
            }
            ArrayList<String> commond = new ArrayList<String>();
            commond.add("-ss");
            commond.add(MediaUtil.formatTimes(startTime));
            commond.add("-t");
            commond.add("" + timeLength);
            commond.add("-i");
            commond.add(videoFile.getAbsolutePath());
            commond.add("-vcodec");
            commond.add("copy");
            commond.add("-acodec");
            commond.add("copy");
            commond.add(outputFile.getAbsolutePath());
            MediaUtil.executeCommand(commond);
        }
        catch (IOException e) {
            log.error("--- \u89c6\u9891\u622a\u53d6\u8fc7\u7a0b\u51fa\u9519 ---");
        }
    }

    public static void getAudioFromVideo(File videoFile, File audioFile) {
        if (null == videoFile || !videoFile.exists()) {
            throw new RuntimeException("\u6e90\u89c6\u9891\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a ");
        }
        if (null == audioFile) {
            throw new RuntimeException("\u8981\u63d0\u53d6\u7684\u97f3\u9891\u8def\u5f84\u4e3a\u7a7a\uff1a");
        }
        String format = MediaUtil.getFormat(audioFile);
        if (!MediaUtil.isLegalFormat(format, AUDIO_TYPE)) {
            throw new RuntimeException("\u65e0\u6cd5\u751f\u6210\u6307\u5b9a\u683c\u5f0f\u7684\u97f3\u9891\uff1a" + format + " \u8bf7\u68c0\u67e5\u8981\u8f93\u51fa\u7684\u97f3\u9891\u6587\u4ef6\u662f\u5426\u662fAAC\u7c7b\u578b");
        }
        try {
            if (!audioFile.exists()) {
                audioFile.createNewFile();
            }
            ArrayList<String> commond = new ArrayList<String>();
            commond.add("-i");
            commond.add(videoFile.getAbsolutePath());
            commond.add("-vn");
            commond.add("-y");
            commond.add("-acodec");
            commond.add("copy");
            commond.add(audioFile.getAbsolutePath());
            MediaUtil.executeCommand(commond);
        }
        catch (Exception e) {
            log.error("--- \u62bd\u53d6\u89c6\u9891\u4e2d\u7684\u97f3\u9891\u4fe1\u606f\u7684\u8fc7\u7a0b\u51fa\u9519 --- \u9519\u8bef\u4fe1\u606f\uff1a " + e.getMessage());
        }
    }

    public static VideoMetaInfo getVideoMetaInfo(File videoFile) {
        if (null == videoFile || !videoFile.exists()) {
            log.error("--- \u89e3\u6790\u89c6\u9891\u4fe1\u606f\u5931\u8d25\uff0c\u56e0\u4e3a\u8981\u89e3\u6790\u7684\u6e90\u89c6\u9891\u6587\u4ef6\u4e0d\u5b58\u5728 ---");
            return null;
        }
        String parseResult = MediaUtil.getMetaInfoFromFFmpeg(videoFile);
        Matcher durationMatcher = durationPattern.matcher(parseResult);
        Matcher rotateMatcher = rotatePattern.matcher(parseResult);
        Matcher videoStreamMatcher = videoStreamPattern.matcher(parseResult);
        Matcher videoMusicStreamMatcher = musicStreamPattern.matcher(parseResult);
        Long duration = 0L;
        int rotate = 0;
        int videoBitrate = 0;
        String videoFormat = MediaUtil.getFormat(videoFile);
        Long videoSize = videoFile.length();
        String videoEncoder = "";
        int videoHeight = 0;
        int videoWidth = 0;
        float videoFramerate = 0.0f;
        String musicFormat = "";
        long samplerate = 0L;
        int musicBitrate = 0;
        try {
            if (durationMatcher.find()) {
                long hours = Integer.parseInt(durationMatcher.group(1));
                long minutes = Integer.parseInt(durationMatcher.group(2));
                long seconds = Integer.parseInt(durationMatcher.group(3));
                double dec = Double.parseDouble(durationMatcher.group(4));
                System.out.println("\u89c6\u9891\u65f6\u957f\uff08\u672a\u8f6c\u6362\uff09=====" + dec);
                duration = (long)(dec * 1000.0) + seconds * 1000L + minutes * 60L * 1000L + hours * 60L * 60L * 1000L;
                videoBitrate = Integer.parseInt(durationMatcher.group(6));
            }
            if (rotateMatcher.find()) {
                rotate = Integer.parseInt(rotateMatcher.group(1));
            }
            if (videoStreamMatcher.find()) {
                videoEncoder = videoStreamMatcher.group(1);
                videoWidth = Integer.parseInt(videoStreamMatcher.group(3));
                videoHeight = Integer.parseInt(videoStreamMatcher.group(4));
                videoFramerate = Float.parseFloat(videoStreamMatcher.group(6));
            }
            if (videoMusicStreamMatcher.find()) {
                musicFormat = videoMusicStreamMatcher.group(1);
                samplerate = Long.parseLong(videoMusicStreamMatcher.group(3));
                musicBitrate = Integer.parseInt(videoMusicStreamMatcher.group(6));
            }
        }
        catch (Exception e) {
            log.error("--- \u89e3\u6790\u89c6\u9891\u53c2\u6570\u4fe1\u606f\u51fa\u9519\uff01 --- \u9519\u8bef\u4fe1\u606f\uff1a " + e.getMessage());
            return null;
        }
        MusicMetaInfo musicMetaInfo = new MusicMetaInfo();
        musicMetaInfo.setFormat(musicFormat);
        musicMetaInfo.setDuration(duration);
        musicMetaInfo.setBitRate(musicBitrate);
        musicMetaInfo.setSampleRate(samplerate);
        VideoMetaInfo videoMetaInfo = new VideoMetaInfo();
        videoMetaInfo.setFormat(videoFormat);
        videoMetaInfo.setSize(videoSize);
        videoMetaInfo.setBitRate(videoBitrate);
        videoMetaInfo.setDuration(duration);
        videoMetaInfo.setEncoder(videoEncoder);
        videoMetaInfo.setFrameRate(Float.valueOf(videoFramerate));
        videoMetaInfo.setHeight(videoHeight);
        videoMetaInfo.setWidth(videoWidth);
        videoMetaInfo.setMusicMetaInfo(musicMetaInfo);
        videoMetaInfo.setRotate(rotate);
        System.out.println("\u89c6\u9891\u65f6\u957f=====" + videoMetaInfo.getDuration());
        return videoMetaInfo;
    }

    public static VideoMetaInfo getVideoMetaInfo(InputStream inputStream) {
        VideoMetaInfo videoInfo = new VideoMetaInfo();
        try {
            File file = File.createTempFile("tmp", null);
            if (!file.exists()) {
                return null;
            }
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)file);
            videoInfo = MediaUtil.getVideoMetaInfo(file);
            file.deleteOnExit();
            return videoInfo;
        }
        catch (Exception e) {
            log.error("--- \u4ece\u6d41\u4e2d\u83b7\u53d6\u89c6\u9891\u57fa\u672c\u4fe1\u606f\u51fa\u9519 --- \u9519\u8bef\u4fe1\u606f\uff1a " + e.getMessage());
            return null;
        }
    }

    public static MusicMetaInfo getMusicMetaInfo(File musicFile) {
        if (null == musicFile || !musicFile.exists()) {
            log.error("--- \u65e0\u6cd5\u83b7\u53d6\u97f3\u9891\u4fe1\u606f\uff0c\u56e0\u4e3a\u8981\u89e3\u6790\u7684\u97f3\u9891\u6587\u4ef6\u4e3a\u7a7a ---");
            return null;
        }
        String parseResult = MediaUtil.getMetaInfoFromFFmpeg(musicFile);
        long duration = 0L;
        int musicBitrate = 0;
        long samplerate = 0L;
        String musicFormat = "";
        Long musicSize = musicFile.length();
        Matcher durationMacher = durationPattern.matcher(parseResult);
        Matcher musicStreamMacher = musicStreamPattern.matcher(parseResult);
        try {
            if (durationMacher.find()) {
                long hours = Integer.parseInt(durationMacher.group(1));
                long minutes = Integer.parseInt(durationMacher.group(2));
                long seconds = Integer.parseInt(durationMacher.group(3));
                double dec = Double.parseDouble(durationMacher.group(4));
                duration = (long)(dec * 1000.0 + (double)(seconds * 1000L) + (double)(minutes * 60L * 1000L) + (double)(hours * 60L * 60L * 1000L));
                musicBitrate = Integer.parseInt(durationMacher.group(6));
            }
            if (musicStreamMacher.find()) {
                musicFormat = musicStreamMacher.group(1);
                samplerate = Long.parseLong(musicStreamMacher.group(3));
                musicBitrate = Integer.parseInt(musicStreamMacher.group(6));
            }
        }
        catch (Exception e) {
            log.error("--- \u89e3\u6790\u97f3\u9891\u53c2\u6570\u4fe1\u606f\u51fa\u9519\uff01 --- \u9519\u8bef\u4fe1\u606f\uff1a " + e.getMessage());
            return null;
        }
        MusicMetaInfo musicMetaInfo = new MusicMetaInfo();
        musicMetaInfo.setFormat(musicFormat);
        musicMetaInfo.setDuration(duration);
        musicMetaInfo.setBitRate(musicBitrate);
        musicMetaInfo.setSampleRate(samplerate);
        musicMetaInfo.setSize(musicSize);
        return musicMetaInfo;
    }

    public static MusicMetaInfo getMusicMetaInfo(InputStream inputStream) {
        try {
            File file = File.createTempFile("tmp", null);
            if (!file.exists()) {
                return null;
            }
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)file);
            MusicMetaInfo musicMetaInfo = MediaUtil.getMusicMetaInfo(file);
            file.deleteOnExit();
            return musicMetaInfo;
        }
        catch (Exception e) {
            log.error("--- \u4ece\u6d41\u4e2d\u83b7\u53d6\u97f3\u9891\u57fa\u672c\u4fe1\u606f\u51fa\u9519 --- \u9519\u8bef\u4fe1\u606f\uff1a " + e.getMessage());
            return null;
        }
    }

    public static ImageMetaInfo getImageInfo(InputStream inputStream) {
        BufferedImage image = null;
        ImageMetaInfo imageInfo = new ImageMetaInfo();
        try {
            image = ImageIO.read(inputStream);
            imageInfo.setWidth(image.getWidth());
            imageInfo.setHeight(image.getHeight());
            imageInfo.setSize(Long.valueOf(String.valueOf(inputStream.available())));
            return imageInfo;
        }
        catch (Exception e) {
            log.error("--- \u83b7\u53d6\u56fe\u7247\u7684\u57fa\u672c\u4fe1\u606f\u5931\u8d25 --- \u9519\u8bef\u4fe1\u606f\uff1a " + e.getMessage());
            return null;
        }
    }

    public static ImageMetaInfo getImageInfo(File imageFile) {
        BufferedImage image = null;
        ImageMetaInfo imageInfo = new ImageMetaInfo();
        try {
            if (null == imageFile || !imageFile.exists()) {
                return null;
            }
            image = ImageIO.read(imageFile);
            imageInfo.setWidth(image.getWidth());
            imageInfo.setHeight(image.getHeight());
            imageInfo.setSize(imageFile.length());
            imageInfo.setFormat(MediaUtil.getFormat(imageFile));
            return imageInfo;
        }
        catch (Exception e) {
            log.error("--- \u83b7\u53d6\u56fe\u7247\u7684\u57fa\u672c\u4fe1\u606f\u5931\u8d25 --- \u9519\u8bef\u4fe1\u606f\uff1a " + e.getMessage());
            return null;
        }
    }

    public static boolean isGivenFormat(File inputFile, String[] givenFormat) {
        if (null == inputFile || !inputFile.exists()) {
            log.error("--- \u65e0\u6cd5\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b\u662f\u5426\u6ee1\u8db3\u8981\u6c42\uff0c\u56e0\u4e3a\u8981\u68c0\u67e5\u7684\u6587\u4ef6\u4e0d\u5b58\u5728 --- \u6e90\u6587\u4ef6\uff1a " + inputFile);
            return false;
        }
        if (null == givenFormat || givenFormat.length <= 0) {
            log.error("--- \u65e0\u6cd5\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b\u662f\u5426\u6ee1\u8db3\u8981\u6c42\uff0c\u56e0\u4e3a\u6ca1\u6709\u6307\u5b9a\u7684\u6587\u4ef6\u7c7b\u578b ---");
            return false;
        }
        String fomat = MediaUtil.getFormat(inputFile);
        return MediaUtil.isLegalFormat(fomat, givenFormat);
    }

    private static String getMetaInfoFromFFmpeg(File inputFile) {
        if (inputFile == null || !inputFile.exists()) {
            throw new RuntimeException("\u6e90\u5a92\u4f53\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u6e90\u5a92\u4f53\u6587\u4ef6\u8def\u5f84\uff1a ");
        }
        ArrayList<String> commond = new ArrayList<String>();
        commond.add("-i");
        commond.add(inputFile.getAbsolutePath());
        String executeResult = MediaUtil.executeCommand(commond);
        return executeResult;
    }

    private static boolean isLegalFormat(String format, String[] formats) {
        for (String item : formats) {
            if (!item.equals(StringUtils.upperCase((String)format))) continue;
            return true;
        }
        return false;
    }

    private static void createGifImage(String[] image, String outputPath, int playTime) {
        if (null == outputPath) {
            throw new RuntimeException("\u8f6c\u6362\u540e\u7684GIF\u8def\u5f84\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8f6c\u6362\u540e\u7684GIF\u5b58\u653e\u8def\u5f84\u662f\u5426\u6b63\u786e");
        }
        try {
            AnimatedGifEncoder encoder = new AnimatedGifEncoder();
            encoder.setRepeat(0);
            encoder.start(outputPath);
            BufferedImage[] src = new BufferedImage[image.length];
            for (int i = 0; i < src.length; ++i) {
                encoder.setDelay(playTime);
                src[i] = ImageIO.read(new File(image[i]));
                encoder.addFrame(src[i]);
            }
            encoder.finish();
        }
        catch (Exception e) {
            log.error("--- \u591a\u5f20\u9759\u6001\u56fe\u8f6c\u6362\u6210\u52a8\u6001GIF\u56fe\u7684\u8fc7\u7a0b\u51fa\u9519 --- \u9519\u8bef\u4fe1\u606f\uff1a " + e.getMessage());
        }
    }

    private static String getFormat(File file) {
        String fileName = file.getName();
        String format = StringUtils.substringAfterLast((String)fileName, (String)".");
        return format;
    }

    public static void cutVideoCover(File videoFile, String impFile) {
        MediaUtil.cutVideoFrame(videoFile, impFile, 1000L, null, null, 0, false);
    }

    private static String formatTimes(long millisecond) {
        long ms = millisecond % 1000L;
        long s = (millisecond /= 1000L) % 60L;
        long m = (millisecond /= 60L) % 60L;
        long h = (millisecond /= 60L) % 60L;
        return String.format("%02d:%02d:%02d.%03d", h, m, s, ms);
    }

    public static void main(String[] args) {
        File outFile = new File("d:/test/1.mp4");
        MediaUtil.cutVideoFrame(outFile, "d:/test/bbbhh.jpg", 1000L, null, null, 0, false);
    }

    public static boolean isMusic(String filenameOrSuffix) {
        String suffix = StringUtils.substringAfterLast((String)("." + filenameOrSuffix), (String)".").toLowerCase();
        return ArrayUtils.contains((Object[])AUDIO_SUFFIX, (Object)suffix);
    }

    public static boolean isVideo(String filenameOrSuffix) {
        String suffix = StringUtils.substringAfterLast((String)("." + filenameOrSuffix), (String)".").toLowerCase();
        return ArrayUtils.contains((Object[])VIDEO_SUFFIX, (Object)suffix);
    }

    static {
        String durationRegex = "Duration: (\\d*?):(\\d*?):(\\d*?)(\\.\\d*?), start: (.*?), bitrate: (\\d*) kb/s.*";
        durationPattern = Pattern.compile(durationRegex);
        String rotateRegex = "rotate\\s*:\\s*(\\d*)";
        rotatePattern = Pattern.compile(rotateRegex);
        String videoStreamRegex = "Stream #\\d:\\d[(]??\\S*[)]??: Video: (\\S*\\S$?)[^,]*, (.*?), (\\d*)x(\\d*)[^,]*, (\\d*) kb/s,[^,]*[, ] *(\\d*[.]??\\d*) fps";
        videoStreamPattern = Pattern.compile(videoStreamRegex);
        String musicStreamRegex = "Stream #\\d:\\d[(]??\\S*[)]??: Audio: (\\S*\\S$?)(.*), (.*?) Hz, (.*?), (.*?), (\\d*) kb/s";
        musicStreamPattern = Pattern.compile(musicStreamRegex);
    }

    static class PrintStream
    extends Thread {
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        StringBuffer stringBuffer = new StringBuffer();

        public PrintStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public void run() {
            try {
                if (null == this.inputStream) {
                    log.error("--- \u8bfb\u53d6\u8f93\u51fa\u6d41\u51fa\u9519\uff01\u56e0\u4e3a\u5f53\u524d\u8f93\u51fa\u6d41\u4e3a\u7a7a\uff01---");
                }
                this.bufferedReader = new BufferedReader(new InputStreamReader(this.inputStream));
                String line = null;
                while ((line = this.bufferedReader.readLine()) != null) {
                    log.info(line);
                    this.stringBuffer.append(line);
                }
            }
            catch (Exception e) {
                log.error("--- \u8bfb\u53d6\u8f93\u5165\u6d41\u51fa\u9519\u4e86\uff01--- \u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
            }
            finally {
                try {
                    if (null != this.bufferedReader) {
                        this.bufferedReader.close();
                    }
                    if (null != this.inputStream) {
                        this.inputStream.close();
                    }
                }
                catch (IOException e) {
                    log.error("--- \u8c03\u7528PrintStream\u8bfb\u53d6\u8f93\u51fa\u6d41\u540e\uff0c\u5173\u95ed\u6d41\u65f6\u51fa\u9519\uff01---");
                }
            }
        }
    }

    private static class ProcessKiller
    extends Thread {
        private Process process;

        public ProcessKiller(Process process) {
            this.process = process;
        }

        @Override
        public void run() {
            this.process.destroy();
            log.info("--- \u5df2\u9500\u6bc1FFmpeg\u8fdb\u7a0b --- \u8fdb\u7a0b\u540d\uff1a " + this.process.toString());
        }
    }
}

