/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.wechat.util.client.httpclient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;

public abstract class HttpClientDelegateBase {
    public static byte[] readURLImage(String imageUrl) throws IOException {
        if (StringUtils.isBlank((CharSequence)imageUrl)) {
            return null;
        }
        byte[] result = null;
        URL url = new URL(imageUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setConnectTimeout(5000);
        try (InputStream inStream = conn.getInputStream();){
            result = HttpClientDelegateBase.readInputStream(inStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static byte[] readInputStream(InputStream inStream) throws IOException {
        byte[] result = null;
        try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            inStream.close();
            result = outStream.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

