/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.io;

import com.jfinal.template.io.Encoder;
import com.jfinal.template.io.FloatingWriter;
import com.jfinal.template.io.IWritable;
import com.jfinal.template.io.IntegerWriter;
import com.jfinal.template.io.LongWriter;
import com.jfinal.template.io.Writer;
import java.io.IOException;
import java.io.OutputStream;

public class ByteWriter
extends Writer {
    OutputStream out;
    Encoder encoder;
    char[] chars;
    byte[] bytes;
    private static final byte[] TRUE_BYTES = "true".getBytes();
    private static final byte[] FALSE_BYTES = "false".getBytes();

    public ByteWriter(Encoder encoder, int bufferSize) {
        this.encoder = encoder;
        this.chars = new char[bufferSize];
        this.bytes = new byte[bufferSize * (int)encoder.maxBytesPerChar()];
    }

    public ByteWriter init(OutputStream outputStream) {
        this.out = outputStream;
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() {
        try {
            if (this.out != null) {
                this.out.flush();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.out = null;
        }
    }

    @Override
    public void write(String str, int offset, int len) throws IOException {
        while (len > this.chars.length) {
            this.write(str, offset, this.chars.length);
            offset += this.chars.length;
            len -= this.chars.length;
        }
        str.getChars(offset, offset + len, this.chars, 0);
        int byteLen = this.encoder.encode(this.chars, 0, len, this.bytes);
        this.out.write(this.bytes, 0, byteLen);
    }

    @Override
    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    @Override
    public void write(StringBuilder stringBuilder, int offset, int len) throws IOException {
        while (len > this.chars.length) {
            this.write(stringBuilder, offset, this.chars.length);
            offset += this.chars.length;
            len -= this.chars.length;
        }
        stringBuilder.getChars(offset, offset + len, this.chars, 0);
        int byteLen = this.encoder.encode(this.chars, 0, len, this.bytes);
        this.out.write(this.bytes, 0, byteLen);
    }

    @Override
    public void write(StringBuilder stringBuilder) throws IOException {
        this.write(stringBuilder, 0, stringBuilder.length());
    }

    @Override
    public void write(IWritable writable) throws IOException {
        byte[] data = writable.getBytes();
        this.out.write(data, 0, data.length);
    }

    @Override
    public void write(int intValue) throws IOException {
        IntegerWriter.write(this, intValue);
    }

    @Override
    public void write(long longValue) throws IOException {
        LongWriter.write(this, longValue);
    }

    @Override
    public void write(double doubleValue) throws IOException {
        FloatingWriter.write(this, doubleValue);
    }

    @Override
    public void write(float floatValue) throws IOException {
        FloatingWriter.write(this, floatValue);
    }

    @Override
    public void write(boolean booleanValue) throws IOException {
        this.out.write(booleanValue ? TRUE_BYTES : FALSE_BYTES);
    }
}

