/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.server.undertow;

import com.jfinal.server.undertow.CompositeResourceManager;
import com.jfinal.server.undertow.PathKitExt;
import com.jfinal.server.undertow.UndertowKit;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import java.io.File;

public class ResourceManagerKit {
    public static ResourceManager buildResourceManager(String resourcePath, ClassLoader classLoader) {
        String[] resourcePathArray;
        if (!resourcePath.contains("webapp")) {
            resourcePath = resourcePath + ",webapp";
        }
        CompositeResourceManager ret = new CompositeResourceManager();
        for (String path : resourcePathArray = resourcePath.split(",")) {
            if (!new File(path = path.trim()).isDirectory()) continue;
            ret.add((ResourceManager)new FileResourceManager(new File(path)));
        }
        if (UndertowKit.isDeployMode()) {
            ResourceManagerKit.forDeployMode(classLoader, ret);
        }
        return ret;
    }

    private static void forDeployMode(ClassLoader classLoader, CompositeResourceManager ret) {
        if (ret.isEmpty()) {
            String path = PathKitExt.getLocationPath();
            if (path.endsWith(File.separatorChar + "lib")) {
                path = path.substring(0, path.lastIndexOf(File.separatorChar));
            }
            if (new File(path = new File(path + File.separator + "webapp").getAbsolutePath()).isDirectory()) {
                ret.add((ResourceManager)new FileResourceManager(new File(path)));
            }
        }
        ret.add((ResourceManager)new ClassPathResourceManager(classLoader, "webapp"));
    }
}

