/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.server.undertow.hotswap;

import java.io.File;
import java.util.ArrayList;

public class HotSwapResolver {
    protected String[] classPathDirs;
    protected String[] systemClassPrefix = new String[]{"java.", "javax.", "sun.", "com.sun.", "com.jfinal.server.undertow."};
    protected String[] hotSwapClassPrefix = new String[]{"com.jfinal.", "net.sf.ehcache.", "redis.clients.", "org.nustaq.", "org.quartz.", "net.dreamlu."};

    public HotSwapResolver(String[] classPathDirs) {
        this.classPathDirs = classPathDirs != null ? classPathDirs : new String[0];
    }

    public boolean isSystemClass(String className) {
        for (String s : this.systemClassPrefix) {
            if (!className.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    public boolean isHotSwapClass(String className) {
        for (String s : this.hotSwapClassPrefix) {
            if (!className.startsWith(s)) continue;
            return true;
        }
        return this.findClassInClassPathDirs(className);
    }

    protected boolean findClassInClassPathDirs(String className) {
        String fileName = className.replace('.', '/').concat(".class");
        if (this.classPathDirs.length == 1) {
            if (this.findFile(this.classPathDirs[0], fileName)) {
                return true;
            }
        } else {
            for (String dir : this.classPathDirs) {
                if (!this.findFile(dir, fileName)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean findFile(String filePath, String fileName) {
        File file = new File(filePath + fileName);
        return file.isFile();
    }

    public synchronized void addSystemClassPrefix(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : this.systemClassPrefix) {
            list.add(s);
        }
        list.add(prefix.trim());
        this.systemClassPrefix = list.toArray(new String[list.size()]);
    }

    public synchronized void addHotSwapClassPrefix(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : this.hotSwapClassPrefix) {
            list.add(s);
        }
        list.add(prefix.trim());
        this.hotSwapClassPrefix = list.toArray(new String[list.size()]);
    }
}

