/*
 * Decompiled with CFR 0.152.
 */
package com.labijie.infra.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.labijie.infra.json.DecimalAsStringDeserializer;
import com.labijie.infra.json.DecimalAsStringSerializer;
import com.labijie.infra.json.LongAsStringDeserializer;
import com.labijie.infra.utils.ExtensionsKt;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u000b0\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J5\u0010\n\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00142\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0015J;\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0017\"\b\b\u0000\u0010\u000b*\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00142\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0019J5\u0010\u001a\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00142\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u001dJ-\u0010\u001e\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\u00012\u0006\u0010\u001f\u001a\u00020 2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u000b0\u000f\u00a2\u0006\u0002\u0010!J5\u0010\u001e\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\u00012\u0006\u0010\u001f\u001a\u00020 2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00142\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\"J6\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u000b0$\"\b\b\u0000\u0010\u000b*\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00142\b\b\u0002\u0010\u0010\u001a\u00020\u0011JT\u0010%\u001a\u000e\u0012\u0004\u0012\u0002H'\u0012\u0004\u0012\u0002H(0&\"\b\b\u0000\u0010'*\u00020\u0001\"\b\b\u0001\u0010(*\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H'0\u00142\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H(0\u00142\b\b\u0002\u0010\u0010\u001a\u00020\u0011J6\u0010+\u001a\b\u0012\u0004\u0012\u0002H\u000b0,\"\b\b\u0000\u0010\u000b*\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00142\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0010\u0010-\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u00020\u00012\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0018\u00100\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020\u00012\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0018\u00101\u001a\u00020 2\u0006\u0010/\u001a\u00020\u00012\b\b\u0002\u0010\u0010\u001a\u00020\u0011R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u00062"}, d2={"Lcom/labijie/infra/json/JacksonHelper;", "", "()V", "defaultObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "getDefaultObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "webCompatibilityMapper", "getWebCompatibilityMapper", "deserialize", "T", "bytes", "", "typeReference", "Lcom/fasterxml/jackson/core/type/TypeReference;", "compatibleWeb", "", "([BLcom/fasterxml/jackson/core/type/TypeReference;Z)Ljava/lang/Object;", "clazz", "Lkotlin/reflect/KClass;", "([BLkotlin/reflect/KClass;Z)Ljava/lang/Object;", "deserializeArray", "", "elementClass", "([BLkotlin/reflect/KClass;Z)[Ljava/lang/Object;", "deserializeFromJsonNode", "jsonNode", "Lcom/fasterxml/jackson/databind/JsonNode;", "(Lcom/fasterxml/jackson/databind/JsonNode;Lkotlin/reflect/KClass;Z)Ljava/lang/Object;", "deserializeFromString", "json", "", "(Ljava/lang/String;Lcom/fasterxml/jackson/core/type/TypeReference;)Ljava/lang/Object;", "(Ljava/lang/String;Lkotlin/reflect/KClass;Z)Ljava/lang/Object;", "deserializeList", "", "deserializeMap", "", "TKey", "TValue", "keyClass", "valueClass", "deserializeSet", "", "getObjectMapper", "serialize", "data", "serializeAsJsonNode", "serializeAsString", "core"})
public final class JacksonHelper {
    private static final ObjectMapper defaultObjectMapper;
    @NotNull
    private static final ObjectMapper webCompatibilityMapper;
    public static final JacksonHelper INSTANCE;

    public final ObjectMapper getDefaultObjectMapper() {
        return defaultObjectMapper;
    }

    @NotNull
    public final ObjectMapper getWebCompatibilityMapper() {
        return webCompatibilityMapper;
    }

    private final ObjectMapper getObjectMapper(boolean compatibleWeb) {
        ObjectMapper objectMapper;
        if (compatibleWeb) {
            objectMapper = webCompatibilityMapper;
        } else {
            ObjectMapper objectMapper2 = defaultObjectMapper;
            objectMapper = objectMapper2;
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"defaultObjectMapper");
        }
        return objectMapper;
    }

    @NotNull
    public final byte[] serialize(@NotNull Object data, boolean compatibleWeb) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        byte[] byArray = this.getObjectMapper(compatibleWeb).writeValueAsBytes(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getObjectMapper(compatib\u2026).writeValueAsBytes(data)");
        return byArray;
    }

    public static /* synthetic */ byte[] serialize$default(JacksonHelper jacksonHelper, Object object, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return jacksonHelper.serialize(object, bl);
    }

    @NotNull
    public final <T> T deserialize(@NotNull byte[] bytes, @NotNull KClass<T> clazz, boolean compatibleWeb) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Object object = this.getObjectMapper(compatibleWeb).readValue(bytes, JvmClassMappingKt.getJavaClass(clazz));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getObjectMapper(compatib\u2026dValue(bytes, clazz.java)");
        return (T)object;
    }

    public static /* synthetic */ Object deserialize$default(JacksonHelper jacksonHelper, byte[] byArray, KClass kClass, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return jacksonHelper.deserialize(byArray, kClass, bl);
    }

    public final <T> T deserialize(@NotNull byte[] bytes, @NotNull TypeReference<? extends T> typeReference, boolean compatibleWeb) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter(typeReference, (String)"typeReference");
        return (T)this.getObjectMapper(compatibleWeb).readValue(bytes, typeReference);
    }

    public static /* synthetic */ Object deserialize$default(JacksonHelper jacksonHelper, byte[] byArray, TypeReference typeReference, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return jacksonHelper.deserialize(byArray, typeReference, bl);
    }

    @NotNull
    public final String serializeAsString(@NotNull Object data, boolean compatibleWeb) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = this.getObjectMapper(compatibleWeb).writeValueAsString(data);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getObjectMapper(compatib\u2026.writeValueAsString(data)");
        return string;
    }

    public static /* synthetic */ String serializeAsString$default(JacksonHelper jacksonHelper, Object object, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return jacksonHelper.serializeAsString(object, bl);
    }

    @NotNull
    public final JsonNode serializeAsJsonNode(@NotNull Object data, boolean compatibleWeb) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        JsonNode jsonNode = this.getObjectMapper(compatibleWeb).valueToTree(data);
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"getObjectMapper(compatibleWeb).valueToTree(data)");
        return jsonNode;
    }

    public static /* synthetic */ JsonNode serializeAsJsonNode$default(JacksonHelper jacksonHelper, Object object, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return jacksonHelper.serializeAsJsonNode(object, bl);
    }

    @NotNull
    public final <T> T deserializeFromJsonNode(@NotNull JsonNode jsonNode, @NotNull KClass<T> clazz, boolean compatibleWeb) {
        Intrinsics.checkNotNullParameter((Object)jsonNode, (String)"jsonNode");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Object object = this.getObjectMapper(compatibleWeb).treeToValue((TreeNode)jsonNode, JvmClassMappingKt.getJavaClass(clazz));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getObjectMapper(compatib\u2026lue(jsonNode, clazz.java)");
        return (T)object;
    }

    public static /* synthetic */ Object deserializeFromJsonNode$default(JacksonHelper jacksonHelper, JsonNode jsonNode, KClass kClass, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return jacksonHelper.deserializeFromJsonNode(jsonNode, kClass, bl);
    }

    @NotNull
    public final <T> T deserializeFromString(@NotNull String json, @NotNull KClass<T> clazz, boolean compatibleWeb) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Object object = this.getObjectMapper(compatibleWeb).readValue(json, JvmClassMappingKt.getJavaClass(clazz));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getObjectMapper(compatib\u2026adValue(json, clazz.java)");
        return (T)object;
    }

    public static /* synthetic */ Object deserializeFromString$default(JacksonHelper jacksonHelper, String string, KClass kClass, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return jacksonHelper.deserializeFromString(string, kClass, bl);
    }

    @NotNull
    public final <T> T deserializeFromString(@NotNull String json, @NotNull TypeReference<? extends T> typeReference) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(typeReference, (String)"typeReference");
        Object object = defaultObjectMapper.readValue(json, typeReference);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"defaultObjectMapper.readValue(json, typeReference)");
        return (T)object;
    }

    @NotNull
    public final <T> List<T> deserializeList(@NotNull byte[] bytes, @NotNull KClass<T> elementClass, boolean compatibleWeb) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter(elementClass, (String)"elementClass");
        return ExtensionsKt.deserializeList(this.getObjectMapper(compatibleWeb), bytes, elementClass);
    }

    public static /* synthetic */ List deserializeList$default(JacksonHelper jacksonHelper, byte[] byArray, KClass kClass, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return jacksonHelper.deserializeList(byArray, kClass, bl);
    }

    @NotNull
    public final <T> Set<T> deserializeSet(@NotNull byte[] bytes, @NotNull KClass<T> elementClass, boolean compatibleWeb) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter(elementClass, (String)"elementClass");
        return ExtensionsKt.deserializeSet(this.getObjectMapper(compatibleWeb), bytes, elementClass);
    }

    public static /* synthetic */ Set deserializeSet$default(JacksonHelper jacksonHelper, byte[] byArray, KClass kClass, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return jacksonHelper.deserializeSet(byArray, kClass, bl);
    }

    @NotNull
    public final <T> T[] deserializeArray(@NotNull byte[] bytes, @NotNull KClass<T> elementClass, boolean compatibleWeb) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter(elementClass, (String)"elementClass");
        return ExtensionsKt.deserializeArray(this.getObjectMapper(compatibleWeb), bytes, elementClass);
    }

    public static /* synthetic */ Object[] deserializeArray$default(JacksonHelper jacksonHelper, byte[] byArray, KClass kClass, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return jacksonHelper.deserializeArray(byArray, kClass, bl);
    }

    @NotNull
    public final <TKey, TValue> Map<TKey, TValue> deserializeMap(@NotNull byte[] bytes, @NotNull KClass<TKey> keyClass, @NotNull KClass<TValue> valueClass, boolean compatibleWeb) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter(keyClass, (String)"keyClass");
        Intrinsics.checkNotNullParameter(valueClass, (String)"valueClass");
        return ExtensionsKt.deserializeMap(this.getObjectMapper(compatibleWeb), bytes, keyClass, valueClass);
    }

    public static /* synthetic */ Map deserializeMap$default(JacksonHelper jacksonHelper, byte[] byArray, KClass kClass, KClass kClass2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return jacksonHelper.deserializeMap(byArray, kClass, kClass2, bl);
    }

    private JacksonHelper() {
    }

    static {
        JacksonHelper jacksonHelper;
        INSTANCE = jacksonHelper = new JacksonHelper();
        ObjectMapper objectMapper = new ObjectMapper().configure(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.WRITE_ENUMS_USING_INDEX, true).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        boolean bl = false;
        boolean bl2 = false;
        ObjectMapper $this$apply = objectMapper;
        boolean bl3 = false;
        SimpleModule decimalModule = new SimpleModule("CustomDecimalModule");
        decimalModule.addDeserializer(BigDecimal.class, (JsonDeserializer)new DecimalAsStringDeserializer());
        decimalModule.addSerializer(BigDecimal.class, (JsonSerializer)new DecimalAsStringSerializer());
        ObjectMapper objectMapper2 = $this$apply.registerModule((Module)decimalModule);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"this.registerModule(decimalModule)");
        com.fasterxml.jackson.module.kotlin.ExtensionsKt.registerKotlinModule((ObjectMapper)objectMapper2);
        defaultObjectMapper = objectMapper;
        objectMapper = new ObjectMapper().configure(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.WRITE_ENUMS_USING_INDEX, true).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        bl = false;
        bl2 = false;
        $this$apply = objectMapper;
        boolean bl4 = false;
        SimpleModule numericModule = new SimpleModule("NumericModule");
        numericModule.addDeserializer(BigDecimal.class, (JsonDeserializer)new DecimalAsStringDeserializer());
        numericModule.addSerializer(BigDecimal.class, (JsonSerializer)new DecimalAsStringSerializer());
        numericModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
        Class<Long> clazz = Long.TYPE;
        if (clazz == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<in kotlin.Any>");
        }
        numericModule.addDeserializer(clazz, (JsonDeserializer)new LongAsStringDeserializer());
        numericModule.addSerializer(Class.forName("java.lang.Long"), (JsonSerializer)ToStringSerializer.instance);
        Class<?> clazz2 = Class.forName("java.lang.Long");
        if (clazz2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<in kotlin.Any>");
        }
        numericModule.addDeserializer(clazz2, (JsonDeserializer)new LongAsStringDeserializer());
        ObjectMapper objectMapper3 = $this$apply.registerModule((Module)numericModule);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper3, (String)"this.registerModule(numericModule)");
        com.fasterxml.jackson.module.kotlin.ExtensionsKt.registerKotlinModule((ObjectMapper)objectMapper3);
        ObjectMapper objectMapper4 = objectMapper;
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper4, (String)"ObjectMapper()\n         \u2026linModule()\n            }");
        webCompatibilityMapper = objectMapper4;
    }
}

