/*
 * Decompiled with CFR 0.152.
 */
package com.labijie.infra.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.labijie.infra.json.DecimalAsStringSerializer;
import com.labijie.infra.json.LongAsStringDeserializer;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.msgpack.jackson.dataformat.MessagePackFactory;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0006\u001a\u0002H\u0007\"\b\b\u0000\u0010\u0007*\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0001R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/labijie/infra/json/MessagePackHelper;", "", "()V", "defaultObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "deserialize", "T", "bytes", "", "clazz", "Lkotlin/reflect/KClass;", "([BLkotlin/reflect/KClass;)Ljava/lang/Object;", "serialize", "pojo", "core"})
public final class MessagePackHelper {
    private static final ObjectMapper defaultObjectMapper;
    public static final MessagePackHelper INSTANCE;

    @NotNull
    public final byte[] serialize(@NotNull Object pojo) {
        Intrinsics.checkNotNullParameter((Object)pojo, (String)"pojo");
        byte[] byArray = defaultObjectMapper.writeValueAsBytes(pojo);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"defaultObjectMapper.writeValueAsBytes(pojo)");
        return byArray;
    }

    @NotNull
    public final <T> T deserialize(@NotNull byte[] bytes, @NotNull KClass<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Object object = defaultObjectMapper.readValue(bytes, JvmClassMappingKt.getJavaClass(clazz));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"defaultObjectMapper.readValue(bytes, clazz.java)");
        return (T)object;
    }

    private MessagePackHelper() {
    }

    static {
        MessagePackHelper messagePackHelper;
        INSTANCE = messagePackHelper = new MessagePackHelper();
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new MessagePackFactory()).configure(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.WRITE_ENUMS_USING_INDEX, true).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        boolean bl = false;
        boolean bl2 = false;
        ObjectMapper $this$apply = objectMapper;
        boolean bl3 = false;
        SimpleModule decimalModule = new SimpleModule("Numeric");
        decimalModule.addSerializer(BigDecimal.class, (JsonSerializer)new DecimalAsStringSerializer());
        decimalModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
        Class<Long> clazz = Long.TYPE;
        if (clazz == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<in kotlin.Any>");
        }
        decimalModule.addDeserializer(clazz, (JsonDeserializer)new LongAsStringDeserializer());
        decimalModule.addSerializer(Class.forName("java.lang.Long"), (JsonSerializer)ToStringSerializer.instance);
        Class<?> clazz2 = Class.forName("java.lang.Long");
        if (clazz2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<in kotlin.Any>");
        }
        decimalModule.addDeserializer(clazz2, (JsonDeserializer)new LongAsStringDeserializer());
        $this$apply.registerModule((Module)decimalModule);
        defaultObjectMapper = objectMapper;
    }
}

