/*
 * Decompiled with CFR 0.152.
 */
package com.labijie.infra.kryo.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J(\u0010\b\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/labijie/infra/kryo/serializer/DateSerializer;", "Lcom/esotericsoftware/kryo/Serializer;", "Ljava/util/Date;", "()V", "copy", "kryo", "Lcom/esotericsoftware/kryo/Kryo;", "original", "read", "input", "Lcom/esotericsoftware/kryo/io/Input;", "type", "Ljava/lang/Class;", "write", "", "output", "Lcom/esotericsoftware/kryo/io/Output;", "obj", "core"})
public final class DateSerializer
extends Serializer<Date> {
    public static final DateSerializer INSTANCE;

    @NotNull
    public Date read(@NotNull Kryo kryo, @NotNull Input input, @NotNull Class<? extends Date> type) {
        Intrinsics.checkNotNullParameter((Object)kryo, (String)"kryo");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        try {
            return new Date(input.readLong(true));
        }
        catch (KryoException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            throw (Throwable)new KryoException((Throwable)e);
        }
    }

    public void write(@NotNull Kryo kryo, @NotNull Output output, @NotNull Date obj) {
        Intrinsics.checkNotNullParameter((Object)kryo, (String)"kryo");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        output.writeLong(obj.getTime(), true);
    }

    @NotNull
    public Date copy(@NotNull Kryo kryo, @NotNull Date original) {
        Intrinsics.checkNotNullParameter((Object)kryo, (String)"kryo");
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Object object = original.clone();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.util.Date");
        }
        return (Date)object;
    }

    private DateSerializer() {
    }

    static {
        DateSerializer dateSerializer;
        INSTANCE = dateSerializer = new DateSerializer();
    }
}

