/*
 * Decompiled with CFR 0.152.
 */
package com.labijie.infra.kryo.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.labijie.infra.utils.ExtensionsKt;
import java.time.Instant;
import java.time.LocalDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/labijie/infra/kryo/serializer/LocalDateTimeSerializer;", "Lcom/esotericsoftware/kryo/Serializer;", "Ljava/time/LocalDateTime;", "()V", "read", "kryo", "Lcom/esotericsoftware/kryo/Kryo;", "input", "Lcom/esotericsoftware/kryo/io/Input;", "type", "Ljava/lang/Class;", "write", "", "output", "Lcom/esotericsoftware/kryo/io/Output;", "date", "core"})
public final class LocalDateTimeSerializer
extends Serializer<LocalDateTime> {
    public static final LocalDateTimeSerializer INSTANCE;

    public void write(@NotNull Kryo kryo, @NotNull Output output, @NotNull LocalDateTime date) {
        Intrinsics.checkNotNullParameter((Object)kryo, (String)"kryo");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        output.writeLong(ExtensionsKt.toEpochMilli$default(date, null, 1, null), true);
    }

    @NotNull
    public LocalDateTime read(@NotNull Kryo kryo, @NotNull Input input, @Nullable Class<? extends LocalDateTime> type) {
        Intrinsics.checkNotNullParameter((Object)kryo, (String)"kryo");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        try {
            long mills = input.readLong(true);
            Instant instant = Instant.ofEpochMilli(mills);
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"Instant.ofEpochMilli(mills)");
            return ExtensionsKt.toLocalDateTime$default(instant, null, 1, null);
        }
        catch (KryoException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            throw (Throwable)new KryoException((Throwable)e);
        }
    }

    private LocalDateTimeSerializer() {
    }

    static {
        LocalDateTimeSerializer localDateTimeSerializer;
        INSTANCE = localDateTimeSerializer = new LocalDateTimeSerializer();
    }
}

