/*
 * Decompiled with CFR 0.152.
 */
package com.labijie.infra.kryo.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/labijie/infra/kryo/serializer/UUIDSerializer;", "Lcom/esotericsoftware/kryo/Serializer;", "Ljava/util/UUID;", "()V", "read", "kryo", "Lcom/esotericsoftware/kryo/Kryo;", "input", "Lcom/esotericsoftware/kryo/io/Input;", "uuidClass", "Ljava/lang/Class;", "write", "", "output", "Lcom/esotericsoftware/kryo/io/Output;", "uuid", "core"})
public final class UUIDSerializer
extends Serializer<UUID> {
    public static final UUIDSerializer INSTANCE;

    public void write(@NotNull Kryo kryo, @NotNull Output output, @NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)kryo, (String)"kryo");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        output.writeLong(uuid.getMostSignificantBits());
        output.writeLong(uuid.getLeastSignificantBits());
    }

    @NotNull
    public UUID read(@NotNull Kryo kryo, @NotNull Input input, @NotNull Class<? extends UUID> uuidClass) {
        Intrinsics.checkNotNullParameter((Object)kryo, (String)"kryo");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter(uuidClass, (String)"uuidClass");
        return new UUID(input.readLong(), input.readLong());
    }

    private UUIDSerializer() {
    }

    static {
        UUIDSerializer uUIDSerializer;
        INSTANCE = uUIDSerializer = new UUIDSerializer();
        uUIDSerializer.setImmutable(true);
    }
}

