/*
 * Decompiled with CFR 0.152.
 */
package com.labijie.infra.security;

import com.labijie.infra.security.Rfc6238TokenServiceProperties;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0002J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u001e\u0010\u0012\u001a\u00020\u000f2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nJ\u001e\u0010\u0014\u001a\u00020\n2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nJ\b\u0010\u0015\u001a\u00020\u0011H\u0002J&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000f2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nJ&\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\n2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/labijie/infra/security/Rfc6238TokenService;", "", "properties", "Lcom/labijie/infra/security/Rfc6238TokenServiceProperties;", "(Lcom/labijie/infra/security/Rfc6238TokenServiceProperties;)V", "defaultSecurityToken", "", "applyModifier", "input", "modifier", "", "computeHash", "data", "key", "computeTotp", "", "timestepNumber", "", "generateCode", "securityToken", "generateCodeString", "getCurrentTimeStepNumber", "validateCode", "", "code", "validateCodeString", "core"})
public final class Rfc6238TokenService {
    private final byte[] defaultSecurityToken;
    private final Rfc6238TokenServiceProperties properties;

    private final byte[] computeHash(byte[] data, byte[] key) {
        SecretKeySpec signingKey = new SecretKeySpec(key, "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(signingKey);
        byte[] byArray = mac.doFinal(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"mac.doFinal(data)");
        return byArray;
    }

    private final int computeTotp(byte[] key, long timestepNumber, String modifier) {
        int mod = 1000000;
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(timestepNumber);
        byte[] timestepAsBytes = buffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)timestepAsBytes, (String)"timestepAsBytes");
        byte[] hash = this.computeHash(this.applyModifier(timestepAsBytes, modifier), key);
        int offset = hash[hash.length - 1] & 0xF;
        boolean bl = offset + 4 < hash.length;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        int binaryCode = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
        return binaryCode % mod;
    }

    private final byte[] applyModifier(byte[] input, String modifier) {
        CharSequence charSequence = modifier;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return input;
        }
        String string = modifier;
        Charset charset = Charsets.UTF_8;
        boolean bl3 = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] modifierBytes = byArray;
        ByteBuffer combined = ByteBuffer.allocate(input.length + modifierBytes.length);
        combined.put(input);
        combined.put(modifierBytes);
        byte[] byArray2 = combined.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"combined.array()");
        return byArray2;
    }

    private final long getCurrentTimeStepNumber() {
        return System.currentTimeMillis() / this.properties.getTimeStep().toMillis();
    }

    public final int generateCode(@Nullable byte[] securityToken, @Nullable String modifier) {
        long currentTimeStep = this.getCurrentTimeStepNumber();
        byte[] byArray = securityToken;
        if (securityToken == null) {
            byArray = this.defaultSecurityToken;
        }
        return this.computeTotp(byArray, currentTimeStep, modifier);
    }

    public static /* synthetic */ int generateCode$default(Rfc6238TokenService rfc6238TokenService, byte[] byArray, String string, int n, Object object) {
        if ((n & 1) != 0) {
            byArray = null;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return rfc6238TokenService.generateCode(byArray, string);
    }

    public final boolean validateCode(int code, @Nullable byte[] securityToken, @Nullable String modifier) {
        long currentTimeStep = this.getCurrentTimeStepNumber();
        int n = -2;
        Iterable $this$forEach$iv = (Iterable)new IntRange(n, 2);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int computed;
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            byte[] byArray = securityToken;
            if (securityToken == null) {
                byArray = this.defaultSecurityToken;
            }
            if ((computed = this.computeTotp(byArray, currentTimeStep + (long)it, modifier)) != code) continue;
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean validateCode$default(Rfc6238TokenService rfc6238TokenService, int n, byte[] byArray, String string, int n2, Object object) {
        if ((n2 & 2) != 0) {
            byArray = null;
        }
        if ((n2 & 4) != 0) {
            string = null;
        }
        return rfc6238TokenService.validateCode(n, byArray, string);
    }

    @NotNull
    public final String generateCodeString(@Nullable String securityToken, @Nullable String modifier) {
        byte[] byArray;
        String string = securityToken;
        if (string != null) {
            String string2 = string;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray2 = string3.getBytes(charset);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        } else {
            byArray = null;
        }
        return StringsKt.padStart((String)String.valueOf(this.generateCode(byArray, modifier)), (int)6, (char)'0');
    }

    public static /* synthetic */ String generateCodeString$default(Rfc6238TokenService rfc6238TokenService, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return rfc6238TokenService.generateCodeString(string, string2);
    }

    public final boolean validateCodeString(@NotNull String code, @Nullable String securityToken, @Nullable String modifier) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        if (code.length() != 6) {
            return false;
        }
        String string = code;
        boolean bl = false;
        Integer num = StringsKt.toIntOrNull((String)((Object)StringsKt.trim((CharSequence)string)).toString());
        if (num != null) {
            byte[] byArray;
            int n = num;
            String string2 = securityToken;
            if (string2 != null) {
                string = string2;
                Charset charset = Charsets.UTF_8;
                boolean bl2 = false;
                String string3 = string;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray2 = string3.getBytes(charset);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
            } else {
                byArray = null;
            }
            return this.validateCode(n, byArray, modifier);
        }
        return false;
    }

    public static /* synthetic */ boolean validateCodeString$default(Rfc6238TokenService rfc6238TokenService, String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        return rfc6238TokenService.validateCodeString(string, string2, string3);
    }

    public Rfc6238TokenService(@NotNull Rfc6238TokenServiceProperties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.properties = properties;
        String string = this.properties.getSecurityToken();
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        this.defaultSecurityToken = byArray;
    }

    public /* synthetic */ Rfc6238TokenService(Rfc6238TokenServiceProperties rfc6238TokenServiceProperties, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            rfc6238TokenServiceProperties = new Rfc6238TokenServiceProperties(null, null, 3, null);
        }
        this(rfc6238TokenServiceProperties);
    }

    public Rfc6238TokenService() {
        this(null, 1, null);
    }
}

