/*
 * Decompiled with CFR 0.152.
 */
package com.labijie.infra.utils;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0090\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t\u001a\u0010\u0010\u000b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\r\u001a5\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\b\b\u0000\u0010\u0010*\u00020\u0005*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0015\u00a2\u0006\u0002\u0010\u0016\u001a0\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0018\"\b\b\u0000\u0010\u0010*\u00020\u0005*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0015\u001aN\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u0002H\u001c0\u001a\"\b\b\u0000\u0010\u001b*\u00020\u0005\"\b\b\u0001\u0010\u001c*\u00020\u0005*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u00152\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u0015\u001a0\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00100 \"\b\b\u0000\u0010\u0010*\u00020\u0005*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0015\u001a9\u0010!\u001a\u0002H\"\"\b\b\u0000\u0010#*\u0002H\"\"\b\b\u0001\u0010\"*\u00020$*\u0004\u0018\u0001H#2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H\"0&H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'\u001a\u0018\u0010!\u001a\u0004\u0018\u00010\t*\u0004\u0018\u00010\t2\b\u0010(\u001a\u0004\u0018\u00010\t\u001a\n\u0010)\u001a\u00020\t*\u00020*\u001a\u001e\u0010+\u001a\u00020**\u00020*2\u0012\b\u0002\u0010,\u001a\f\u0012\u0006\b\u0001\u0012\u00020*\u0018\u00010\u0015\u001a\n\u0010-\u001a\u00020.*\u00020*\u001a\n\u0010/\u001a\u00020\u0013*\u000200\u001a\n\u0010/\u001a\u00020\u0013*\u000201\u001a\u0014\u00102\u001a\u000201*\u0002032\b\b\u0002\u0010\f\u001a\u00020\r\u001a\n\u00104\u001a\u000200*\u00020\u0013\u001a\u0014\u00105\u001a\u000203*\u0002062\b\b\u0002\u00107\u001a\u000208\u001a\n\u00109\u001a\u000201*\u00020\u0013\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006:"}, d2={"DEFAULT_FORMAT", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "", "getLogger", "(Ljava/lang/Object;)Lorg/slf4j/Logger;", "findIpAddress", "", "netmask", "nowString", "zoneOffset", "Ljava/time/ZoneOffset;", "deserializeArray", "", "T", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "bytes", "", "elementClass", "Lkotlin/reflect/KClass;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;[BLkotlin/reflect/KClass;)[Ljava/lang/Object;", "deserializeList", "", "deserializeMap", "", "TKey", "TValue", "keyClass", "valueClass", "deserializeSet", "", "ifNullOrBlank", "R", "C", "", "defaultValue", "Lkotlin/Function0;", "(Ljava/lang/CharSequence;Lkotlin/jvm/functions/Function0;)Ljava/lang/CharSequence;", "default", "printStackToString", "", "recurseCause", "type", "throwIfNecessary", "", "toByteArray", "", "", "toEpochMilli", "Ljava/time/LocalDateTime;", "toInt", "toLocalDateTime", "Ljava/time/Instant;", "zoneId", "Ljava/time/ZoneId;", "toLong", "core"})
public final class ExtensionsKt {
    private static final DateTimeFormatter DEFAULT_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    @NotNull
    public static final Logger getLogger(@NotNull Object $this$logger) {
        Intrinsics.checkNotNullParameter((Object)$this$logger, (String)"$this$logger");
        Logger logger = LoggerFactory.getLogger($this$logger.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(this::class.java)");
        return logger;
    }

    @Nullable
    public static final String ifNullOrBlank(@Nullable String $this$ifNullOrBlank, @Nullable String string) {
        CharSequence charSequence = $this$ifNullOrBlank;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return string;
        }
        return $this$ifNullOrBlank;
    }

    @NotNull
    public static final <C extends R, R extends CharSequence> R ifNullOrBlank(@Nullable C $this$ifNullOrBlank, @NotNull Function0<? extends R> defaultValue) {
        int $i$f$ifNullOrBlank = 0;
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        return (R)($this$ifNullOrBlank == null || StringsKt.isBlank($this$ifNullOrBlank) ? (CharSequence)defaultValue.invoke() : $this$ifNullOrBlank);
    }

    @NotNull
    public static final String nowString(@NotNull ZoneOffset zoneOffset) {
        Intrinsics.checkNotNullParameter((Object)zoneOffset, (String)"zoneOffset");
        DateTimeFormatter format = DEFAULT_FORMAT;
        String string = LocalDateTime.now(zoneOffset).format(format);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"LocalDateTime.now(zoneOffset).format(format)");
        return string;
    }

    public static /* synthetic */ String nowString$default(ZoneOffset zoneOffset, int n, Object object) {
        if ((n & 1) != 0) {
            ZoneOffset zoneOffset2 = ZoneOffset.UTC;
            Intrinsics.checkNotNullExpressionValue((Object)zoneOffset2, (String)"ZoneOffset.UTC");
            zoneOffset = zoneOffset2;
        }
        return ExtensionsKt.nowString(zoneOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String printStackToString(@NotNull Throwable $this$printStackToString) {
        Intrinsics.checkNotNullParameter((Object)$this$printStackToString, (String)"$this$printStackToString");
        String stack = "";
        Closeable closeable = new ByteArrayOutputStream();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ByteArrayOutputStream it = (ByteArrayOutputStream)closeable;
            boolean bl3 = false;
            Object object = new PrintWriter(it);
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                PrintWriter it2 = (PrintWriter)object;
                boolean bl6 = false;
                $this$printStackToString.printStackTrace(it2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
            }
            byte[] byArray = it.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"it.toByteArray()");
            object = byArray;
            Charset charset = Charsets.UTF_8;
            boolean bl7 = false;
            boolean bl8 = false;
            stack = new String((byte[])object, charset);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return stack;
    }

    @Nullable
    public static final String findIpAddress(@NotNull String netmask) {
        Intrinsics.checkNotNullParameter((Object)netmask, (String)"netmask");
        Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface ni;
            NetworkInterface networkInterface = ni = netInterfaces.nextElement();
            Intrinsics.checkNotNullExpressionValue((Object)networkInterface, (String)"ni");
            Enumeration<InetAddress> ia = networkInterface.getInetAddresses();
            while (ia.hasMoreElements()) {
                InetAddress ip = ia.nextElement();
                String r = StringsKt.replace$default((String)StringsKt.replace$default((String)netmask, (String)".", (String)"\\.", (boolean)false, (int)4, null), (String)"*", (String)"(.*)", (boolean)false, (int)4, null);
                Regex regex = new Regex(r);
                InetAddress inetAddress = ip;
                Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"ip");
                String string = inetAddress.getHostAddress();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ip.hostAddress");
                if (!regex.matches((CharSequence)string)) continue;
                return ip.getHostAddress();
            }
        }
        return null;
    }

    public static final void throwIfNecessary(@NotNull Throwable $this$throwIfNecessary) {
        Intrinsics.checkNotNullParameter((Object)$this$throwIfNecessary, (String)"$this$throwIfNecessary");
        if ($this$throwIfNecessary instanceof VirtualMachineError) {
            throw $this$throwIfNecessary;
        }
    }

    @NotNull
    public static final Throwable recurseCause(@NotNull Throwable $this$recurseCause, @Nullable KClass<? extends Throwable> type) {
        Throwable t;
        Intrinsics.checkNotNullParameter((Object)$this$recurseCause, (String)"$this$recurseCause");
        Throwable throwable = t = $this$recurseCause instanceof InvocationTargetException ? ((InvocationTargetException)$this$recurseCause).getTargetException() : $this$recurseCause;
        if (type != null && KClasses.isSubclassOf((KClass)Reflection.getOrCreateKotlinClass(t.getClass()), type)) {
            Throwable throwable2 = t;
            Intrinsics.checkNotNullExpressionValue((Object)throwable2, (String)"t");
            return throwable2;
        }
        while (t.getCause() != null) {
            Throwable c;
            Intrinsics.checkNotNull((Object)t.getCause());
            if (type != null && KClasses.isSubclassOf((KClass)Reflection.getOrCreateKotlinClass(c.getClass()), type)) {
                return c;
            }
            t = c;
        }
        Throwable throwable3 = t;
        Intrinsics.checkNotNullExpressionValue((Object)throwable3, (String)"t");
        return throwable3;
    }

    public static /* synthetic */ Throwable recurseCause$default(Throwable throwable, KClass kClass, int n, Object object) {
        if ((n & 1) != 0) {
            kClass = null;
        }
        return ExtensionsKt.recurseCause(throwable, (KClass<? extends Throwable>)kClass);
    }

    @NotNull
    public static final <T> List<T> deserializeList(@NotNull ObjectMapper $this$deserializeList, @NotNull byte[] bytes, @NotNull KClass<T> elementClass) {
        Intrinsics.checkNotNullParameter((Object)$this$deserializeList, (String)"$this$deserializeList");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter(elementClass, (String)"elementClass");
        CollectionType javaType = $this$deserializeList.getTypeFactory().constructCollectionType(List.class, JvmClassMappingKt.getJavaClass(elementClass));
        Object object = $this$deserializeList.readValue(bytes, (JavaType)javaType);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.readValue(bytes, javaType)");
        return (List)object;
    }

    @NotNull
    public static final <T> Set<T> deserializeSet(@NotNull ObjectMapper $this$deserializeSet, @NotNull byte[] bytes, @NotNull KClass<T> elementClass) {
        Intrinsics.checkNotNullParameter((Object)$this$deserializeSet, (String)"$this$deserializeSet");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter(elementClass, (String)"elementClass");
        CollectionType javaType = $this$deserializeSet.getTypeFactory().constructCollectionType(Set.class, JvmClassMappingKt.getJavaClass(elementClass));
        Object object = $this$deserializeSet.readValue(bytes, (JavaType)javaType);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.readValue(bytes, javaType)");
        return (Set)object;
    }

    @NotNull
    public static final <T> T[] deserializeArray(@NotNull ObjectMapper $this$deserializeArray, @NotNull byte[] bytes, @NotNull KClass<T> elementClass) {
        Intrinsics.checkNotNullParameter((Object)$this$deserializeArray, (String)"$this$deserializeArray");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter(elementClass, (String)"elementClass");
        ArrayType javaType = $this$deserializeArray.getTypeFactory().constructArrayType(JvmClassMappingKt.getJavaClass(elementClass));
        Object object = $this$deserializeArray.readValue(bytes, (JavaType)javaType);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.readValue(bytes, javaType)");
        return (Object[])object;
    }

    @NotNull
    public static final <TKey, TValue> Map<TKey, TValue> deserializeMap(@NotNull ObjectMapper $this$deserializeMap, @NotNull byte[] bytes, @NotNull KClass<TKey> keyClass, @NotNull KClass<TValue> valueClass) {
        Intrinsics.checkNotNullParameter((Object)$this$deserializeMap, (String)"$this$deserializeMap");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter(keyClass, (String)"keyClass");
        Intrinsics.checkNotNullParameter(valueClass, (String)"valueClass");
        MapType javaType = $this$deserializeMap.getTypeFactory().constructMapType(Map.class, JvmClassMappingKt.getJavaClass(keyClass), JvmClassMappingKt.getJavaClass(valueClass));
        Object object = $this$deserializeMap.readValue(bytes, (JavaType)javaType);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.readValue(bytes, javaType)");
        return (Map)object;
    }

    @NotNull
    public static final byte[] toByteArray(long $this$toByteArray) {
        byte[] b = new byte[8];
        b[7] = (byte)($this$toByteArray & 0xFFL);
        b[6] = (byte)($this$toByteArray >> 8 & 0xFFL);
        b[5] = (byte)($this$toByteArray >> 16 & 0xFFL);
        b[4] = (byte)($this$toByteArray >> 24 & 0xFFL);
        b[3] = (byte)($this$toByteArray >> 32 & 0xFFL);
        b[2] = (byte)($this$toByteArray >> 40 & 0xFFL);
        b[1] = (byte)($this$toByteArray >> 48 & 0xFFL);
        b[0] = (byte)($this$toByteArray >> 56 & 0xFFL);
        return b;
    }

    public static final long toLong(@NotNull byte[] $this$toLong) {
        Intrinsics.checkNotNullParameter((Object)$this$toLong, (String)"$this$toLong");
        return ((long)$this$toLong[0] & 0xFFL) << 56 | ((long)$this$toLong[1] & 0xFFL) << 48 | ((long)$this$toLong[2] & 0xFFL) << 40 | ((long)$this$toLong[3] & 0xFFL) << 32 | ((long)$this$toLong[4] & 0xFFL) << 24 | ((long)$this$toLong[5] & 0xFFL) << 16 | ((long)$this$toLong[6] & 0xFFL) << 8 | ((long)$this$toLong[7] & 0xFFL) << 0;
    }

    @NotNull
    public static final byte[] toByteArray(int $this$toByteArray) {
        byte[] b = new byte[4];
        b[3] = (byte)($this$toByteArray & 0xFF);
        b[2] = (byte)($this$toByteArray >> 8 & 0xFF);
        b[1] = (byte)($this$toByteArray >> 16 & 0xFF);
        b[0] = (byte)($this$toByteArray >> 24 & 0xFF);
        return b;
    }

    public static final int toInt(@NotNull byte[] $this$toInt) {
        Intrinsics.checkNotNullParameter((Object)$this$toInt, (String)"$this$toInt");
        return $this$toInt[3] & 0xFF | ($this$toInt[2] & 0xFF) << 8 | ($this$toInt[1] & 0xFF) << 16 | ($this$toInt[0] & 0xFF) << 24;
    }

    @NotNull
    public static final LocalDateTime toLocalDateTime(@NotNull Instant $this$toLocalDateTime, @NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)$this$toLocalDateTime, (String)"$this$toLocalDateTime");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        LocalDateTime localDateTime = LocalDateTime.ofInstant($this$toLocalDateTime, zoneId);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"LocalDateTime.ofInstant(this, zoneId)");
        return localDateTime;
    }

    public static /* synthetic */ LocalDateTime toLocalDateTime$default(Instant instant, ZoneId zoneId, int n, Object object) {
        if ((n & 1) != 0) {
            ZoneOffset zoneOffset = ZoneOffset.UTC;
            Intrinsics.checkNotNullExpressionValue((Object)zoneOffset, (String)"ZoneOffset.UTC");
            zoneId = zoneOffset;
        }
        return ExtensionsKt.toLocalDateTime(instant, zoneId);
    }

    public static final long toEpochMilli(@NotNull LocalDateTime $this$toEpochMilli, @NotNull ZoneOffset zoneOffset) {
        Intrinsics.checkNotNullParameter((Object)$this$toEpochMilli, (String)"$this$toEpochMilli");
        Intrinsics.checkNotNullParameter((Object)zoneOffset, (String)"zoneOffset");
        return $this$toEpochMilli.toInstant(zoneOffset).toEpochMilli();
    }

    public static /* synthetic */ long toEpochMilli$default(LocalDateTime localDateTime, ZoneOffset zoneOffset, int n, Object object) {
        if ((n & 1) != 0) {
            ZoneOffset zoneOffset2 = ZoneOffset.UTC;
            Intrinsics.checkNotNullExpressionValue((Object)zoneOffset2, (String)"ZoneOffset.UTC");
            zoneOffset = zoneOffset2;
        }
        return ExtensionsKt.toEpochMilli(localDateTime, zoneOffset);
    }
}

