/*
 * Decompiled with CFR 0.152.
 */
package com.labijie.infra.utils;

import java.util.Arrays;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u000e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005J\u0006\u0010\u0012\u001a\u00020\u0007J\u0006\u0010\u0013\u001a\u00020\u0000J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00000\u00162\u0006\u0010\u0017\u001a\u00020\u0003J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/labijie/infra/utils/HostAndPort;", "", "host", "", "portValue", "", "hasBracketlessColons", "", "(Ljava/lang/String;IZ)V", "getHost", "()Ljava/lang/String;", "port", "getPort", "()I", "equals", "other", "getPortOrDefault", "defaultPort", "hasPort", "requireBracketsForIPv6", "toString", "tryFromString", "Ljava/util/Optional;", "str", "withDefaultPort", "Companion", "core"})
public final class HostAndPort {
    @NotNull
    private final String host;
    private final int portValue;
    private final boolean hasBracketlessColons;
    private static final int NO_PORT = -1;
    public static final Companion Companion = new Companion(null);

    public final boolean hasPort() {
        return this.portValue >= 0;
    }

    @NotNull
    public final Optional<HostAndPort> tryFromString(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        try {
            HostAndPort hp = Companion.fromString(str);
            Optional<HostAndPort> optional = Optional.of(hp);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"Optional.of(hp)");
            return optional;
        }
        catch (IllegalArgumentException ex) {
            Optional<HostAndPort> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"Optional.empty()");
            return optional;
        }
    }

    public final int getPort() {
        if (!this.hasPort()) {
            throw (Throwable)new IllegalStateException("validated port number");
        }
        return this.portValue;
    }

    public final int getPortOrDefault(int defaultPort) {
        return this.hasPort() ? this.portValue : defaultPort;
    }

    @NotNull
    public final HostAndPort withDefaultPort(int defaultPort) {
        com.labijie.infra.utils.HostAndPort$Companion.checkArgument$default(Companion, HostAndPort.Companion.isValidPort(defaultPort), null, new Object[0], 2, null);
        return this.hasPort() || this.portValue == defaultPort ? this : new HostAndPort(this.host, defaultPort, this.hasBracketlessColons);
    }

    @NotNull
    public final HostAndPort requireBracketsForIPv6() {
        HostAndPort.Companion.checkArgument(!this.hasBracketlessColons, "Possible bracketless IPv6 literal: %s", this.host);
        return this;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!(object instanceof HostAndPort)) {
            object = null;
        }
        HostAndPort hostAndPort = (HostAndPort)object;
        if (hostAndPort == null) {
            return false;
        }
        HostAndPort that = hostAndPort;
        return Intrinsics.areEqual((Object)this.host, (Object)that.host) && this.portValue == that.portValue && this.hasBracketlessColons == that.hasBracketlessColons;
    }

    @NotNull
    public String toString() {
        StringBuilder builder = new StringBuilder(this.host.length() + 8);
        if (StringsKt.indexOf$default((CharSequence)this.host, (char)':', (int)0, (boolean)false, (int)6, null) >= 0) {
            builder.append('[').append(this.host).append(']');
        } else {
            builder.append(this.host);
        }
        if (this.hasPort()) {
            builder.append(':').append(this.portValue);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    private HostAndPort(String host, int portValue, boolean hasBracketlessColons) {
        this.host = host;
        this.portValue = portValue;
        this.hasBracketlessColons = hasBracketlessColons;
    }

    public /* synthetic */ HostAndPort(String host, int portValue, boolean hasBracketlessColons, DefaultConstructorMarker $constructor_marker) {
        this(host, portValue, hasBracketlessColons);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J9\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\u0016\u0010\u000b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\f\"\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nJ\u0016\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0004J\u0010\u0010\u0013\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\nJ\u001b\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u0014\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/labijie/infra/utils/HostAndPort$Companion;", "", "()V", "NO_PORT", "", "checkArgument", "", "condition", "", "formatString", "", "argValue", "", "(ZLjava/lang/String;[Ljava/lang/Object;)V", "fromHost", "Lcom/labijie/infra/utils/HostAndPort;", "host", "fromParts", "port", "fromString", "hostPortString", "getHostAndPortFromBracketedHost", "(Ljava/lang/String;)[Ljava/lang/String;", "isValidPort", "core"})
    public static final class Companion {
        @NotNull
        public final HostAndPort fromParts(@NotNull String host, int port) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            this.checkArgument(this.isValidPort(port), "Port out of range: %s", port);
            HostAndPort parsedHost = this.fromString(host);
            this.checkArgument(!parsedHost.hasPort(), "Host has a port: %s", host);
            return new HostAndPort(parsedHost.getHost(), port, parsedHost.hasBracketlessColons, null);
        }

        private final void checkArgument(boolean condition, String formatString, Object ... argValue) {
            if (!condition) {
                String string;
                CharSequence charSequence = formatString;
                boolean bl = false;
                boolean bl2 = false;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    string = "invalid argument";
                } else {
                    charSequence = StringCompanionObject.INSTANCE;
                    Object[] objectArray = new Object[]{argValue};
                    bl2 = false;
                    String string2 = String.format(formatString, Arrays.copyOf(objectArray, objectArray.length));
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                }
                throw (Throwable)new IllegalArgumentException(string);
            }
        }

        static /* synthetic */ void checkArgument$default(Companion companion, boolean bl, String string, Object[] objectArray, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            companion.checkArgument(bl, string, objectArray);
        }

        @NotNull
        public final HostAndPort fromHost(@NotNull String host) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            HostAndPort parsedHost = this.fromString(host);
            this.checkArgument(!parsedHost.hasPort(), "Host has a port: %s", host);
            return parsedHost;
        }

        @NotNull
        public final HostAndPort fromString(@Nullable String hostPortString) {
            boolean bl;
            int n;
            CharSequence charSequence;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (hostPortString == null) {
                boolean bl5 = false;
                String string = "Required value was null.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            String host = null;
            String portString = null;
            boolean hasBracketlessColons = false;
            if (StringsKt.startsWith$default((String)hostPortString, (String)"[", (boolean)false, (int)2, null)) {
                String[] hostAndPort = this.getHostAndPortFromBracketedHost(hostPortString);
                host = hostAndPort[0];
                portString = hostAndPort[1];
            } else {
                int colonPos = StringsKt.indexOf$default((CharSequence)hostPortString, (char)':', (int)0, (boolean)false, (int)6, null);
                if (colonPos >= 0 && StringsKt.indexOf$default((CharSequence)hostPortString, (char)':', (int)(colonPos + 1), (boolean)false, (int)4, null) == -1) {
                    charSequence = hostPortString;
                    n = 0;
                    bl = false;
                    String string = ((String)charSequence).substring(n, colonPos);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    host = string;
                    charSequence = hostPortString;
                    n = colonPos + 1;
                    bl = false;
                    String string2 = ((String)charSequence).substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                    portString = string2;
                } else {
                    host = hostPortString;
                    hasBracketlessColons = colonPos >= 0;
                }
            }
            int port = -1;
            charSequence = portString;
            n = 0;
            bl = false;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                this.checkArgument(!StringsKt.startsWith$default((String)portString, (String)"+", (boolean)false, (int)2, null), "Unparseable port number: %s", hostPortString);
                try {
                    port = Integer.parseInt(portString);
                }
                catch (NumberFormatException e) {
                    throw (Throwable)new IllegalArgumentException("Unparseable port number: " + hostPortString);
                }
                this.checkArgument(this.isValidPort(port), "Port number out of range: %s", hostPortString);
            }
            return new HostAndPort(host, port, hasBracketlessColons, null);
        }

        /*
         * WARNING - void declaration
         */
        private final String[] getHostAndPortFromBracketedHost(String hostPortString) {
            this.checkArgument(hostPortString.charAt(0) == '[', "Bracketed host-port string must start with a bracket: %s", hostPortString);
            int colonIndex = StringsKt.indexOf$default((CharSequence)hostPortString, (char)':', (int)0, (boolean)false, (int)6, null);
            int closeBracketIndex = StringsKt.lastIndexOf$default((CharSequence)hostPortString, (char)']', (int)0, (boolean)false, (int)6, null);
            this.checkArgument(colonIndex > -1 && closeBracketIndex > colonIndex, "Invalid bracketed host/port: %s", hostPortString);
            String string = hostPortString;
            int n = 1;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, closeBracketIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String host = string3;
            if (closeBracketIndex + 1 == hostPortString.length()) {
                return new String[]{host, ""};
            }
            this.checkArgument(hostPortString.charAt(closeBracketIndex + 1) == ':', "Only a colon may follow a close bracket: %s", hostPortString);
            int n2 = closeBracketIndex + 2;
            n = hostPortString.length();
            while (n2 < n) {
                void i;
                this.checkArgument(Character.isDigit(hostPortString.charAt((int)i)), "Port must be numeric: %s", hostPortString);
                ++i;
            }
            String[] stringArray = new String[2];
            stringArray[0] = host;
            String string4 = hostPortString;
            n = closeBracketIndex + 2;
            bl = false;
            String string5 = string4;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            stringArray[1] = string6;
            return stringArray;
        }

        private final boolean isValidPort(int port) {
            int n = port;
            return 0 <= n && 65535 >= n;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

