/*
 * Decompiled with CFR 0.152.
 */
package com.labijie.infra.oauth2;

import com.labijie.infra.oauth2.configuration.OAuth2ServerProperties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.OAuth2RequestValidator;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.request.DefaultOAuth2RequestValidator;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u001c\u0010\u0007\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/labijie/infra/oauth2/CompositeOAuth2RequestValidator;", "Lorg/springframework/security/oauth2/provider/OAuth2RequestValidator;", "serverProperties", "Lcom/labijie/infra/oauth2/configuration/OAuth2ServerProperties;", "(Lcom/labijie/infra/oauth2/configuration/OAuth2ServerProperties;)V", "validator", "Lorg/springframework/security/oauth2/provider/request/DefaultOAuth2RequestValidator;", "validateScope", "", "authorizationRequest", "Lorg/springframework/security/oauth2/provider/AuthorizationRequest;", "client", "Lorg/springframework/security/oauth2/provider/ClientDetails;", "tokenRequest", "Lorg/springframework/security/oauth2/provider/TokenRequest;", "oauth2-starter"})
public final class CompositeOAuth2RequestValidator
implements OAuth2RequestValidator {
    private final DefaultOAuth2RequestValidator validator;
    private final OAuth2ServerProperties serverProperties;

    public void validateScope(@Nullable AuthorizationRequest authorizationRequest, @Nullable ClientDetails client) {
        if (this.serverProperties.getScopeValidationEnabled()) {
            this.validator.validateScope(authorizationRequest, client);
        }
    }

    public void validateScope(@Nullable TokenRequest tokenRequest, @Nullable ClientDetails client) {
        if (this.serverProperties.getScopeValidationEnabled()) {
            this.validator.validateScope(tokenRequest, client);
        }
    }

    public CompositeOAuth2RequestValidator(@NotNull OAuth2ServerProperties serverProperties) {
        Intrinsics.checkNotNullParameter((Object)serverProperties, (String)"serverProperties");
        this.serverProperties = serverProperties;
        this.validator = new DefaultOAuth2RequestValidator();
    }
}

